/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.service.context.ServiceContextUtil;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.DocumentFolder;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.delivery.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.DocumentFolderDTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.DocumentFolderEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseDocumentFolderResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.DocumentFolderResource;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/document-folder.properties"}, scope=ServiceScope.PROTOTYPE, service={DocumentFolderResource.class})
public class DocumentFolderResourceImpl
extends BaseDocumentFolderResourceImpl
implements EntityModelResource {
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DocumentFolderDTOConverter _documentFolderDTOConverter;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private Portal _portal;

    @Override
    public void deleteDocumentFolder(Long documentFolderId) throws Exception {
        this._dlAppService.deleteFolder(documentFolderId.longValue());
    }

    @Override
    public DocumentFolder getDocumentFolder(Long documentFolderId) throws Exception {
        return this._toDocumentFolder(this._dlAppService.getFolder(documentFolderId.longValue()));
    }

    @Override
    public Page<DocumentFolder> getDocumentFolderDocumentFoldersPage(Long parentDocumentFolderId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        DocumentFolder parentDocumentFolder = this._toDocumentFolder(this._dlAppService.getFolder(parentDocumentFolderId.longValue()));
        return this._getDocumentFoldersPage(parentDocumentFolder.getSiteId(), search, filter, parentDocumentFolder.getId(), pagination, sorts);
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new DocumentFolderEntityModel(EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(DLFolder.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService));
    }

    @Override
    public Page<DocumentFolder> getSiteDocumentFoldersPage(Long siteId, Boolean flatten, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Long documentFolderId = null;
        if (!GetterUtil.getBoolean((Object)flatten)) {
            documentFolderId = 0L;
        }
        return this._getDocumentFoldersPage(siteId, search, filter, documentFolderId, pagination, sorts);
    }

    @Override
    public DocumentFolder patchDocumentFolder(Long documentFolderId, DocumentFolder documentFolder) throws Exception {
        Folder existingFolder = this._dlAppService.getFolder(documentFolderId.longValue());
        return this._updateDocumentFolder(documentFolderId, documentFolder.getCustomFields(), Optional.ofNullable(documentFolder.getDescription()).orElse(existingFolder.getDescription()), Optional.ofNullable(documentFolder.getName()).orElse(existingFolder.getName()));
    }

    @Override
    public DocumentFolder postDocumentFolderDocumentFolder(Long parentDocumentFolderId, DocumentFolder documentFolder) throws Exception {
        DocumentFolder parentDocumentFolder = this._toDocumentFolder(this._dlAppService.getFolder(parentDocumentFolderId.longValue()));
        return this._addFolder(parentDocumentFolder.getSiteId(), parentDocumentFolder.getId(), documentFolder);
    }

    @Override
    public DocumentFolder postSiteDocumentFolder(Long siteId, DocumentFolder documentFolder) throws Exception {
        return this._addFolder(siteId, 0L, documentFolder);
    }

    @Override
    public DocumentFolder putDocumentFolder(Long documentFolderId, DocumentFolder documentFolder) throws Exception {
        return this._updateDocumentFolder(documentFolderId, documentFolder.getCustomFields(), documentFolder.getDescription(), documentFolder.getName());
    }

    private DocumentFolder _addFolder(Long siteId, Long parentDocumentFolderId, DocumentFolder documentFolder) throws Exception {
        return this._toDocumentFolder(this._dlAppService.addFolder(siteId.longValue(), parentDocumentFolderId.longValue(), documentFolder.getName(), documentFolder.getDescription(), ServiceContextUtil.createServiceContext(CustomFieldsUtil.toMap(DLFolder.class.getName(), this.contextCompany.getCompanyId(), documentFolder.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale()), (long)siteId, (String)documentFolder.getViewableByAsString())));
    }

    private Page<DocumentFolder> _getDocumentFoldersPage(Long siteId, String search, Filter filter, Long parentDocumentFolderId, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQuery -> {
            if (parentDocumentFolderId != null) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("folderId", String.valueOf(parentDocumentFolderId)), BooleanClauseOccur.MUST);
            }
        }, (Filter)filter, DLFolder.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, document -> this._toDocumentFolder(this._dlAppService.getFolder(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    private DocumentFolder _toDocumentFolder(Folder folder) throws Exception {
        return this._documentFolderDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), folder.getFolderId()));
    }

    private DocumentFolder _updateDocumentFolder(Long documentFolderId, CustomField[] customFields, String description, String name) throws Exception {
        return this._toDocumentFolder(this._dlAppService.updateFolder(documentFolderId.longValue(), name, description, ServiceContextUtil.createServiceContext(CustomFieldsUtil.toMap(DLFolder.class.getName(), this.contextCompany.getCompanyId(), customFields, this.contextAcceptLanguage.getPreferredLocale()), (long)0L, null)));
    }
}

