/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.list.model.AssetListEntry;
import com.liferay.asset.list.service.AssetListEntryService;
import com.liferay.headless.delivery.dto.v1_0.ContentSetElement;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.delivery.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseContentSetElementResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.ContentSetElementResource;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.segments.provider.SegmentsEntryProvider;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/content-set-element.properties"}, scope=ServiceScope.PROTOTYPE, service={ContentSetElementResource.class})
public class ContentSetElementResourceImpl
extends BaseContentSetElementResourceImpl {
    @Reference
    private AssetListEntryService _assetListEntryService;
    @Context
    private HttpHeaders _httpHeaders;
    @Reference
    private SegmentsEntryProvider _segmentsEntryProvider;
    @Context
    private User _user;

    @Override
    public Page<ContentSetElement> getContentSetContentSetElementsPage(Long contentSetId, Pagination pagination) throws Exception {
        AssetListEntry assetListEntry = this._assetListEntryService.getAssetListEntry(contentSetId.longValue());
        return this._getContentSetContentSetElementsPage(assetListEntry, pagination);
    }

    @Override
    public Page<ContentSetElement> getSiteContentSetByKeyContentSetElementsPage(Long siteId, String key, Pagination pagination) throws Exception {
        AssetListEntry assetListEntry = this._assetListEntryService.getAssetListEntry(siteId.longValue(), key);
        return this._getContentSetContentSetElementsPage(assetListEntry, pagination);
    }

    @Override
    public Page<ContentSetElement> getSiteContentSetByUuidContentSetElementsPage(Long siteId, String uuid, Pagination pagination) throws Exception {
        AssetListEntry assetListEntry = this._assetListEntryService.getAssetListEntryByUuidAndGroupId(uuid, siteId.longValue());
        return this._getContentSetContentSetElementsPage(assetListEntry, pagination);
    }

    private com.liferay.segments.context.Context _createSegmentsContext() {
        com.liferay.segments.context.Context context = new com.liferay.segments.context.Context();
        MultivaluedMap multivaluedMap = this._httpHeaders.getRequestHeaders();
        for (Map.Entry entry : multivaluedMap.entrySet()) {
            String key = StringUtil.toLowerCase((String)((String)entry.getKey()));
            List values = (List)entry.getValue();
            String value = (String)values.get(0);
            if (key.equals("accept-language")) {
                context.put("languageId", (Serializable)((Object)value.replace("-", "_")));
                continue;
            }
            if (key.equals("host")) {
                context.put("url", (Serializable)((Object)value));
                continue;
            }
            if (key.equals("referer")) {
                context.put("referrerURL", (Serializable)((Object)value));
                continue;
            }
            if (key.equals("user-agent")) {
                context.put("userAgent", (Serializable)((Object)value));
                continue;
            }
            if (key.startsWith("x-")) {
                context.put(CamelCaseUtil.toCamelCase((String)key.replace("x-", "")), (Serializable)((Object)value));
                continue;
            }
            context.put(key, (Serializable)((Object)value));
        }
        context.put("localDate", (Serializable)LocalDate.from(ZonedDateTime.now()));
        return context;
    }

    private Page<ContentSetElement> _getContentSetContentSetElementsPage(AssetListEntry assetListEntry, Pagination pagination) throws Exception {
        long[] segmentsEntryIds = this._segmentsEntryProvider.getSegmentsEntryIds(assetListEntry.getGroupId(), this._user.getModelClassName(), this._user.getPrimaryKey(), this._createSegmentsContext());
        return Page.of(this.transform(assetListEntry.getAssetEntries(segmentsEntryIds, pagination.getStartPosition(), pagination.getEndPosition()), this::_toContentSetElement), (Pagination)pagination, (long)assetListEntry.getAssetEntriesCount(segmentsEntryIds));
    }

    private ContentSetElement _toContentSetElement(final AssetEntry assetEntry) {
        final DTOConverter dtoConverter = DTOConverterRegistry.getDTOConverter(assetEntry.getClassName());
        return new ContentSetElement(){
            {
                this.id = assetEntry.getClassPK();
                this.title = assetEntry.getTitle(ContentSetElementResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.setContent(() -> {
                    if (dtoConverter == null) {
                        return null;
                    }
                    return dtoConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(ContentSetElementResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), assetEntry.getClassPK(), ContentSetElementResourceImpl.this.contextUriInfo));
                });
                this.setContentType(() -> {
                    if (dtoConverter == null) {
                        return assetEntry.getClassName();
                    }
                    return dtoConverter.getContentType();
                });
            }
        };
    }
}

