/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryService;
import com.liferay.headless.common.spi.resource.SPICommentResource;
import com.liferay.headless.delivery.dto.v1_0.Comment;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CommentUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseCommentResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.CommentResource;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/comment.properties"}, scope=ServiceScope.PROTOTYPE, service={CommentResource.class})
public class CommentResourceImpl
extends BaseCommentResourceImpl
implements EntityModelResource {
    @Reference
    private BlogsEntryService _blogsEntryService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private DLFileEntryService _dlFileEntryService;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private Portal _portal;

    @Override
    public void deleteComment(Long commentId) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        spiCommentResource.deleteComment(commentId);
    }

    @Override
    public Page<Comment> getBlogPostingCommentsPage(Long blogPostingId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        BlogsEntry blogsEntry = this._blogsEntryService.getEntry(blogPostingId.longValue());
        return spiCommentResource.getEntityCommentsPage(blogsEntry.getGroupId(), BlogsEntry.class.getName(), blogPostingId.longValue(), search, filter, pagination, sorts);
    }

    @Override
    public Comment getComment(Long commentId) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        return (Comment)spiCommentResource.getComment(commentId);
    }

    @Override
    public Page<Comment> getCommentCommentsPage(Long parentCommentId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        return spiCommentResource.getCommentCommentsPage(parentCommentId, search, filter, pagination, sorts);
    }

    @Override
    public Page<Comment> getDocumentCommentsPage(Long documentId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        DLFileEntry dlFileEntry = this._dlFileEntryService.getFileEntry(documentId.longValue());
        return spiCommentResource.getEntityCommentsPage(dlFileEntry.getGroupId(), DLFileEntry.class.getName(), documentId.longValue(), search, filter, pagination, sorts);
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        return spiCommentResource.getEntityModel(multivaluedMap);
    }

    @Override
    public Page<Comment> getStructuredContentCommentsPage(Long structuredContentId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        return spiCommentResource.getEntityCommentsPage(journalArticle.getGroupId(), JournalArticle.class.getName(), structuredContentId.longValue(), search, filter, pagination, sorts);
    }

    @Override
    public Comment postBlogPostingComment(Long blogPostingId, Comment comment) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        BlogsEntry blogsEntry = this._blogsEntryService.getEntry(blogPostingId.longValue());
        return (Comment)spiCommentResource.postEntityComment(blogsEntry.getGroupId(), BlogsEntry.class.getName(), blogPostingId.longValue(), comment.getText());
    }

    @Override
    public Comment postCommentComment(Long parentCommentId, Comment comment) throws Exception {
        com.liferay.portal.kernel.comment.Comment parentComment = this._commentManager.fetchComment(parentCommentId.longValue());
        if (parentComment == null) {
            throw new NotFoundException();
        }
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        return (Comment)spiCommentResource.postCommentComment(parentComment, comment.getText());
    }

    @Override
    public Comment postDocumentComment(Long documentId, Comment comment) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        DLFileEntry fileEntry = this._dlFileEntryService.getFileEntry(documentId.longValue());
        return (Comment)spiCommentResource.postEntityComment(fileEntry.getGroupId(), DLFileEntry.class.getName(), documentId.longValue(), comment.getText());
    }

    @Override
    public Comment postStructuredContentComment(Long structuredContentId, Comment comment) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        return (Comment)spiCommentResource.postEntityComment(journalArticle.getGroupId(), JournalArticle.class.getName(), structuredContentId.longValue(), comment.getText());
    }

    @Override
    public Comment putComment(Long commentId, Comment comment) throws Exception {
        SPICommentResource<Comment> spiCommentResource = this._getSPICommentResource();
        return (Comment)spiCommentResource.putComment(commentId, comment.getText());
    }

    private SPICommentResource<Comment> _getSPICommentResource() {
        return new SPICommentResource(this._commentManager, this.contextCompany, comment -> CommentUtil.toComment(comment, this._commentManager, this._portal));
    }
}

