/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.dto.v1_0.StructuredContent;
import com.liferay.headless.delivery.resource.v1_0.StructuredContentResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseStructuredContentResourceImpl
implements StructuredContentResource {
    @Context
    protected AcceptLanguage contextAcceptLanguage;
    @Context
    protected Company contextCompany;
    @Context
    protected UriInfo contextUriInfo;

    @GET
    @Operation(description="Retrieves a list of the content structure's structured content. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="contentStructureId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/content-structures/{contentStructureId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Page<StructuredContent> getContentStructureStructuredContentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="contentStructureId") Long contentStructureId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @GET
    @Operation(description="Retrieves the Site's structured content. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Page<StructuredContent> getSiteStructuredContentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new structured content.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent postSiteStructuredContent(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, StructuredContent structuredContent) throws Exception {
        return new StructuredContent();
    }

    @GET
    @Operation(description="Retrieves a structured content by its key (`articleKey`).")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="key")})
    @Path(value="/sites/{siteId}/structured-contents/by-key/{key}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent getSiteStructuredContentByKey(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="key") String key) throws Exception {
        return new StructuredContent();
    }

    @GET
    @Operation(description="Retrieves a structured content by its UUID.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="uuid")})
    @Path(value="/sites/{siteId}/structured-contents/by-uuid/{uuid}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent getSiteStructuredContentByUuid(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="uuid") String uuid) throws Exception {
        return new StructuredContent();
    }

    @GET
    @Operation(description="Retrieves the folder's structured content. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/structured-content-folders/{structuredContentFolderId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Page<StructuredContent> getStructuredContentFolderStructuredContentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentFolderId") Long structuredContentFolderId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new structured content in the folder.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId")})
    @Path(value="/structured-content-folders/{structuredContentFolderId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent postStructuredContentFolderStructuredContent(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentFolderId") Long structuredContentFolderId, StructuredContent structuredContent) throws Exception {
        return new StructuredContent();
    }

    @DELETE
    @Operation(description="Deletes the structured content and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="StructuredContent")})
    public void deleteStructuredContent(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the structured content via its ID.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent getStructuredContent(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
        return new StructuredContent();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @PATCH
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent patchStructuredContent(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId, StructuredContent structuredContent) throws Exception {
        StructuredContent existingStructuredContent = this.getStructuredContent(structuredContentId);
        if (structuredContent.getAvailableLanguages() != null) {
            existingStructuredContent.setAvailableLanguages(structuredContent.getAvailableLanguages());
        }
        if (structuredContent.getContentStructureId() != null) {
            existingStructuredContent.setContentStructureId(structuredContent.getContentStructureId());
        }
        if (structuredContent.getDateCreated() != null) {
            existingStructuredContent.setDateCreated(structuredContent.getDateCreated());
        }
        if (structuredContent.getDateModified() != null) {
            existingStructuredContent.setDateModified(structuredContent.getDateModified());
        }
        if (structuredContent.getDatePublished() != null) {
            existingStructuredContent.setDatePublished(structuredContent.getDatePublished());
        }
        if (structuredContent.getDescription() != null) {
            existingStructuredContent.setDescription(structuredContent.getDescription());
        }
        if (structuredContent.getFriendlyUrlPath() != null) {
            existingStructuredContent.setFriendlyUrlPath(structuredContent.getFriendlyUrlPath());
        }
        if (structuredContent.getKey() != null) {
            existingStructuredContent.setKey(structuredContent.getKey());
        }
        if (structuredContent.getKeywords() != null) {
            existingStructuredContent.setKeywords(structuredContent.getKeywords());
        }
        if (structuredContent.getNumberOfComments() != null) {
            existingStructuredContent.setNumberOfComments(structuredContent.getNumberOfComments());
        }
        if (structuredContent.getSiteId() != null) {
            existingStructuredContent.setSiteId(structuredContent.getSiteId());
        }
        if (structuredContent.getTaxonomyCategoryIds() != null) {
            existingStructuredContent.setTaxonomyCategoryIds(structuredContent.getTaxonomyCategoryIds());
        }
        if (structuredContent.getTitle() != null) {
            existingStructuredContent.setTitle(structuredContent.getTitle());
        }
        if (structuredContent.getUuid() != null) {
            existingStructuredContent.setUuid(structuredContent.getUuid());
        }
        if (structuredContent.getViewableBy() != null) {
            existingStructuredContent.setViewableBy(structuredContent.getViewableBy());
        }
        this.preparePatch(structuredContent, existingStructuredContent);
        return this.putStructuredContent(structuredContentId, existingStructuredContent);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the structured content with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent putStructuredContent(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId, StructuredContent structuredContent) throws Exception {
        return new StructuredContent();
    }

    @DELETE
    @Operation(description="Deletes the structured content's rating and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}/my-rating")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="StructuredContent")})
    public void deleteStructuredContentMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the structured content's rating.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Rating getStructuredContentMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
        return new Rating();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Create a rating for the structured content.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Rating postStructuredContentMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId, Rating rating) throws Exception {
        return new Rating();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the rating with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Rating putStructuredContentMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId, Rating rating) throws Exception {
        return new Rating();
    }

    @GET
    @Operation(description="Retrieves the structured content's rendered template (the result of applying the structure's values to a template).")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId"), @Parameter(in=ParameterIn.PATH, name="templateId")})
    @Path(value="/structured-contents/{structuredContentId}/rendered-content/{templateId}")
    @Produces(value={"text/html"})
    @Tags(value={@Tag(name="StructuredContent")})
    public String getStructuredContentRenderedContentTemplate(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId, @NotNull @Parameter(hidden=true) @PathParam(value="templateId") Long templateId) throws Exception {
        return "";
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    protected void preparePatch(StructuredContent structuredContent, StructuredContent existingStructuredContent) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

