/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.MessageBoardAttachment;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardAttachmentResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseMessageBoardAttachmentResourceImpl
implements MessageBoardAttachmentResource {
    @Context
    protected AcceptLanguage contextAcceptLanguage;
    @Context
    protected Company contextCompany;
    @Context
    protected UriInfo contextUriInfo;

    @DELETE
    @Operation(description="Deletes the message board attachment and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardAttachmentId")})
    @Path(value="/message-board-attachments/{messageBoardAttachmentId}")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public void deleteMessageBoardAttachment(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardAttachmentId") Long messageBoardAttachmentId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the message board attachment.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardAttachmentId")})
    @Path(value="/message-board-attachments/{messageBoardAttachmentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public MessageBoardAttachment getMessageBoardAttachment(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardAttachmentId") Long messageBoardAttachmentId) throws Exception {
        return new MessageBoardAttachment();
    }

    @GET
    @Operation(description="Retrieves the message board message's attachments.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Path(value="/message-board-messages/{messageBoardMessageId}/message-board-attachments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public Page<MessageBoardAttachment> getMessageBoardMessageMessageBoardAttachmentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardMessageId") Long messageBoardMessageId) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"multipart/form-data"})
    @Operation(description="Creates an attachment for the message board message. The request body must be `multipart/form-data` with two parts, the file's bytes (`file`), and an optional JSON string (`MessageBoardAttachment`) with the metadata.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Path(value="/message-board-messages/{messageBoardMessageId}/message-board-attachments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public MessageBoardAttachment postMessageBoardMessageMessageBoardAttachment(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardMessageId") Long messageBoardMessageId, MultipartBody multipartBody) throws Exception {
        return new MessageBoardAttachment();
    }

    @GET
    @Operation(description="Retrieves the message board thread's attachments.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Path(value="/message-board-threads/{messageBoardThreadId}/message-board-attachments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public Page<MessageBoardAttachment> getMessageBoardThreadMessageBoardAttachmentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardThreadId") Long messageBoardThreadId) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"multipart/form-data"})
    @Operation(description="Creates a new attachment for the message board thread. The request body should be `multipart/form-data` with two parts, the file's bytes (`file`), and an optional JSON string (`knowledgeBaseAttachment`) with the metadata.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Path(value="/message-board-threads/{messageBoardThreadId}/message-board-attachments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public MessageBoardAttachment postMessageBoardThreadMessageBoardAttachment(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardThreadId") Long messageBoardThreadId, MultipartBody multipartBody) throws Exception {
        return new MessageBoardAttachment();
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    protected void preparePatch(MessageBoardAttachment messageBoardAttachment, MessageBoardAttachment existingMessageBoardAttachment) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

