/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.Comment;
import com.liferay.headless.delivery.resource.v1_0.CommentResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseCommentResourceImpl
implements CommentResource {
    @Context
    protected AcceptLanguage contextAcceptLanguage;
    @Context
    protected Company contextCompany;
    @Context
    protected UriInfo contextUriInfo;

    @GET
    @Operation(description="Retrieves the blog post's comments in a list. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="blogPostingId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/blog-postings/{blogPostingId}/comments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Comment")})
    public Page<Comment> getBlogPostingCommentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="blogPostingId") Long blogPostingId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new comment on the blog post.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="blogPostingId")})
    @Path(value="/blog-postings/{blogPostingId}/comments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Comment")})
    public Comment postBlogPostingComment(@NotNull @Parameter(hidden=true) @PathParam(value="blogPostingId") Long blogPostingId, Comment comment) throws Exception {
        return new Comment();
    }

    @DELETE
    @Operation(description="Deletes the comment and returns a 204 if the operation succeeded.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="commentId")})
    @Path(value="/comments/{commentId}")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="Comment")})
    public void deleteComment(@NotNull @Parameter(hidden=true) @PathParam(value="commentId") Long commentId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the comment.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="commentId")})
    @Path(value="/comments/{commentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Comment")})
    public Comment getComment(@NotNull @Parameter(hidden=true) @PathParam(value="commentId") Long commentId) throws Exception {
        return new Comment();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the comment with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="commentId")})
    @Path(value="/comments/{commentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Comment")})
    public Comment putComment(@NotNull @Parameter(hidden=true) @PathParam(value="commentId") Long commentId, Comment comment) throws Exception {
        return new Comment();
    }

    @GET
    @Operation(description="Retrieves the parent comment's child comments. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentCommentId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/comments/{parentCommentId}/comments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Comment")})
    public Page<Comment> getCommentCommentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="parentCommentId") Long parentCommentId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new child comment of the existing comment.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentCommentId")})
    @Path(value="/comments/{parentCommentId}/comments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Comment")})
    public Comment postCommentComment(@NotNull @Parameter(hidden=true) @PathParam(value="parentCommentId") Long parentCommentId, Comment comment) throws Exception {
        return new Comment();
    }

    @GET
    @Operation(description="Retrieves the document's comments. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/documents/{documentId}/comments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Comment")})
    public Page<Comment> getDocumentCommentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="documentId") Long documentId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new comment on the document.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Path(value="/documents/{documentId}/comments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Comment")})
    public Comment postDocumentComment(@NotNull @Parameter(hidden=true) @PathParam(value="documentId") Long documentId, Comment comment) throws Exception {
        return new Comment();
    }

    @GET
    @Operation(description="Retrieves the structured content's comments. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/structured-contents/{structuredContentId}/comments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Comment")})
    public Page<Comment> getStructuredContentCommentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new comment on the structured content.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}/comments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Comment")})
    public Comment postStructuredContentComment(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId, Comment comment) throws Exception {
        return new Comment();
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    protected void preparePatch(Comment comment, Comment existingComment) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

