/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.BlogPostingImage;
import com.liferay.headless.delivery.resource.v1_0.BlogPostingImageResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseBlogPostingImageResourceImpl
implements BlogPostingImageResource {
    @Context
    protected AcceptLanguage contextAcceptLanguage;
    @Context
    protected Company contextCompany;
    @Context
    protected UriInfo contextUriInfo;

    @DELETE
    @Operation(description="Deletes the blog post's image.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="blogPostingImageId")})
    @Path(value="/blog-posting-images/{blogPostingImageId}")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="BlogPostingImage")})
    public void deleteBlogPostingImage(@NotNull @Parameter(hidden=true) @PathParam(value="blogPostingImageId") Long blogPostingImageId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the blog post's image. The binary image is returned as a relative URL to the image itself.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="blogPostingImageId")})
    @Path(value="/blog-posting-images/{blogPostingImageId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="BlogPostingImage")})
    public BlogPostingImage getBlogPostingImage(@NotNull @Parameter(hidden=true) @PathParam(value="blogPostingImageId") Long blogPostingImageId) throws Exception {
        return new BlogPostingImage();
    }

    @GET
    @Operation(description="Retrieves the Site's blog post images. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/blog-posting-images")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="BlogPostingImage")})
    public Page<BlogPostingImage> getSiteBlogPostingImagesPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"multipart/form-data"})
    @Operation(description="Creates a blog post image. The request body must be `multipart/form-data` with two parts, the file's bytes (`file`), and an optional JSON string (`blogPostingImage`) with the metadata.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/blog-posting-images")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="BlogPostingImage")})
    public BlogPostingImage postSiteBlogPostingImage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, MultipartBody multipartBody) throws Exception {
        return new BlogPostingImage();
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    protected void preparePatch(BlogPostingImage blogPostingImage, BlogPostingImage existingBlogPostingImage) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

