/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.headless.delivery.dto.v1_0.RelatedContent;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.Collection;
import java.util.Locale;

public class RelatedContentUtil {
    public static RelatedContent[] toRelatedContents(AssetEntryLocalService assetEntryLocalService, AssetLinkLocalService assetLinkLocalService, String className, long classPK, Locale locale) throws Exception {
        AssetEntry assetEntry = assetEntryLocalService.getEntry(className, classPK);
        return (RelatedContent[])TransformUtil.transformToArray((Collection)assetLinkLocalService.getDirectLinks(assetEntry.getEntryId()), assetLink -> RelatedContentUtil._toRelatedContent(assetEntryLocalService.getEntry(assetLink.getEntryId2()), locale), RelatedContent.class);
    }

    private static RelatedContent _toRelatedContent(final AssetEntry assetEntry, final Locale locale) {
        if (assetEntry == null) {
            return null;
        }
        return new RelatedContent(){
            {
                this.id = assetEntry.getClassPK();
                this.title = assetEntry.getTitle(locale);
                this.setContentType(() -> {
                    DTOConverter dtoConverter = DTOConverterRegistry.getDTOConverter(assetEntry.getClassName());
                    if (dtoConverter == null) {
                        return assetEntry.getClassName();
                    }
                    return dtoConverter.getContentType();
                });
            }
        };
    }
}

