/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.headless.delivery.dto.v1_0.MessageBoardMessage;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"asset.entry.class.name=com.liferay.message.boards.model.MBMessage"}, service={DTOConverter.class, MessageBoardMessageDTOConverter.class})
public class MessageBoardMessageDTOConverter
implements DTOConverter {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBMessageService _mbMessageService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private UserService _userService;

    public String getContentType() {
        return MessageBoardMessage.class.getSimpleName();
    }

    public MessageBoardMessage toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final MBMessage mbMessage = this._mbMessageService.getMessage(dtoConverterContext.getResourcePrimKey());
        return new MessageBoardMessage(){
            {
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(MessageBoardMessageDTOConverter.this._ratingsStatsLocalService.fetchStats(MBMessage.class.getName(), mbMessage.getMessageId()));
                this.anonymous = mbMessage.isAnonymous();
                this.articleBody = mbMessage.getBody();
                this.customFields = CustomFieldsUtil.toCustomFields(MBMessage.class.getName(), mbMessage.getMessageId(), mbMessage.getCompanyId(), dtoConverterContext.getLocale());
                this.dateCreated = mbMessage.getCreateDate();
                this.dateModified = mbMessage.getModifiedDate();
                this.encodingFormat = mbMessage.getFormat();
                this.headline = mbMessage.getSubject();
                this.id = mbMessage.getMessageId();
                this.keywords = (String[])ListUtil.toArray((List)MessageBoardMessageDTOConverter.this._assetTagLocalService.getTags(MBMessage.class.getName(), mbMessage.getMessageId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.relatedContents = RelatedContentUtil.toRelatedContents(MessageBoardMessageDTOConverter.this._assetEntryLocalService, MessageBoardMessageDTOConverter.this._assetLinkLocalService, mbMessage.getModelClassName(), mbMessage.getMessageId(), dtoConverterContext.getLocale());
                this.numberOfMessageBoardAttachments = mbMessage.getAttachmentsFileEntriesCount();
                this.numberOfMessageBoardMessages = MessageBoardMessageDTOConverter.this._mbMessageLocalService.getChildMessagesCount(mbMessage.getMessageId(), 0);
                this.showAsAnswer = mbMessage.isAnswer();
                this.siteId = mbMessage.getGroupId();
                this.setCreator(() -> {
                    if (mbMessage.isAnonymous()) {
                        return null;
                    }
                    return CreatorUtil.toCreator(MessageBoardMessageDTOConverter.this._portal, MessageBoardMessageDTOConverter.this._userService.getUserById(mbMessage.getUserId()));
                });
            }
        };
    }
}

