/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.headless.delivery.dto.v1_0.DocumentFolder;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"asset.entry.class.name=com.liferay.document.library.kernel.model.DLFolder"}, service={DocumentFolderDTOConverter.class, DTOConverter.class})
public class DocumentFolderDTOConverter
implements DTOConverter {
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return DocumentFolder.class.getSimpleName();
    }

    public DocumentFolder toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final Folder folder = this._dlAppService.getFolder(dtoConverterContext.getResourcePrimKey());
        return new DocumentFolder(){
            {
                this.creator = CreatorUtil.toCreator(DocumentFolderDTOConverter.this._portal, DocumentFolderDTOConverter.this._userLocalService.getUser(folder.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields(DLFolder.class.getName(), folder.getFolderId(), folder.getCompanyId(), dtoConverterContext.getLocale());
                this.dateCreated = folder.getCreateDate();
                this.dateModified = folder.getModifiedDate();
                this.description = folder.getDescription();
                this.id = folder.getFolderId();
                this.name = folder.getName();
                this.numberOfDocumentFolders = DocumentFolderDTOConverter.this._dlAppService.getFoldersCount(folder.getRepositoryId(), folder.getFolderId());
                this.numberOfDocuments = DocumentFolderDTOConverter.this._dlAppService.getFileEntriesCount(folder.getRepositoryId(), folder.getFolderId());
                this.siteId = folder.getGroupId();
            }
        };
    }
}

