/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.delivery.dto.v1_0.AggregateRating;
import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.ParentKnowledgeBaseFolder;
import com.liferay.headless.delivery.dto.v1_0.RelatedContent;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategory;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="KnowledgeBaseArticle")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"articleBody", "title"})
@XmlRootElement(name="KnowledgeBaseArticle")
public class KnowledgeBaseArticle {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected AggregateRating aggregateRating;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String articleBody;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Creator creator;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected CustomField[] customFields;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Date dateCreated;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Date dateModified;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String description;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String encodingFormat;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String friendlyUrlPath;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long id;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String[] keywords;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Integer numberOfAttachments;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Integer numberOfKnowledgeBaseArticles;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected ParentKnowledgeBaseFolder parentKnowledgeBaseFolder;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected Long parentKnowledgeBaseFolderId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected RelatedContent[] relatedContents;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long siteId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected TaxonomyCategory[] taxonomyCategories;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected Long[] taxonomyCategoryIds;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String title;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected ViewableBy viewableBy;

    @Schema(description="The article's average rating.")
    public AggregateRating getAggregateRating() {
        return this.aggregateRating;
    }

    public void setAggregateRating(AggregateRating aggregateRating) {
        this.aggregateRating = aggregateRating;
    }

    @JsonIgnore
    public void setAggregateRating(UnsafeSupplier<AggregateRating, Exception> aggregateRatingUnsafeSupplier) {
        try {
            this.aggregateRating = (AggregateRating)aggregateRatingUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The article's main content.")
    public String getArticleBody() {
        return this.articleBody;
    }

    public void setArticleBody(String articleBody) {
        this.articleBody = articleBody;
    }

    @JsonIgnore
    public void setArticleBody(UnsafeSupplier<String, Exception> articleBodyUnsafeSupplier) {
        try {
            this.articleBody = (String)articleBodyUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The article's author.")
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        try {
            this.creator = (Creator)creatorUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        try {
            this.customFields = (CustomField[])customFieldsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The date the article was created.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The last time the article's content or metadata changed.")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        try {
            this.dateModified = (Date)dateModifiedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The article's description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<String, Exception> descriptionUnsafeSupplier) {
        try {
            this.description = (String)descriptionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The article's media type (e.g., HTML, BBCode, etc.).")
    public String getEncodingFormat() {
        return this.encodingFormat;
    }

    public void setEncodingFormat(String encodingFormat) {
        this.encodingFormat = encodingFormat;
    }

    @JsonIgnore
    public void setEncodingFormat(UnsafeSupplier<String, Exception> encodingFormatUnsafeSupplier) {
        try {
            this.encodingFormat = (String)encodingFormatUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The article's relative URL.")
    public String getFriendlyUrlPath() {
        return this.friendlyUrlPath;
    }

    public void setFriendlyUrlPath(String friendlyUrlPath) {
        this.friendlyUrlPath = friendlyUrlPath;
    }

    @JsonIgnore
    public void setFriendlyUrlPath(UnsafeSupplier<String, Exception> friendlyUrlPathUnsafeSupplier) {
        try {
            this.friendlyUrlPath = (String)friendlyUrlPathUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The article's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of keywords describing the article.")
    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    @JsonIgnore
    public void setKeywords(UnsafeSupplier<String[], Exception> keywordsUnsafeSupplier) {
        try {
            this.keywords = (String[])keywordsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The article's number attachments.")
    public Integer getNumberOfAttachments() {
        return this.numberOfAttachments;
    }

    public void setNumberOfAttachments(Integer numberOfAttachments) {
        this.numberOfAttachments = numberOfAttachments;
    }

    @JsonIgnore
    public void setNumberOfAttachments(UnsafeSupplier<Integer, Exception> numberOfAttachmentsUnsafeSupplier) {
        try {
            this.numberOfAttachments = (Integer)numberOfAttachmentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of this article's child articles.")
    public Integer getNumberOfKnowledgeBaseArticles() {
        return this.numberOfKnowledgeBaseArticles;
    }

    public void setNumberOfKnowledgeBaseArticles(Integer numberOfKnowledgeBaseArticles) {
        this.numberOfKnowledgeBaseArticles = numberOfKnowledgeBaseArticles;
    }

    @JsonIgnore
    public void setNumberOfKnowledgeBaseArticles(UnsafeSupplier<Integer, Exception> numberOfKnowledgeBaseArticlesUnsafeSupplier) {
        try {
            this.numberOfKnowledgeBaseArticles = (Integer)numberOfKnowledgeBaseArticlesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The article's parent folder, if it exists.")
    public ParentKnowledgeBaseFolder getParentKnowledgeBaseFolder() {
        return this.parentKnowledgeBaseFolder;
    }

    public void setParentKnowledgeBaseFolder(ParentKnowledgeBaseFolder parentKnowledgeBaseFolder) {
        this.parentKnowledgeBaseFolder = parentKnowledgeBaseFolder;
    }

    @JsonIgnore
    public void setParentKnowledgeBaseFolder(UnsafeSupplier<ParentKnowledgeBaseFolder, Exception> parentKnowledgeBaseFolderUnsafeSupplier) {
        try {
            this.parentKnowledgeBaseFolder = (ParentKnowledgeBaseFolder)parentKnowledgeBaseFolderUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the article's parent folder, if that folder exists.")
    public Long getParentKnowledgeBaseFolderId() {
        return this.parentKnowledgeBaseFolderId;
    }

    public void setParentKnowledgeBaseFolderId(Long parentKnowledgeBaseFolderId) {
        this.parentKnowledgeBaseFolderId = parentKnowledgeBaseFolderId;
    }

    @JsonIgnore
    public void setParentKnowledgeBaseFolderId(UnsafeSupplier<Long, Exception> parentKnowledgeBaseFolderIdUnsafeSupplier) {
        try {
            this.parentKnowledgeBaseFolderId = (Long)parentKnowledgeBaseFolderIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public RelatedContent[] getRelatedContents() {
        return this.relatedContents;
    }

    public void setRelatedContents(RelatedContent[] relatedContents) {
        this.relatedContents = relatedContents;
    }

    @JsonIgnore
    public void setRelatedContents(UnsafeSupplier<RelatedContent[], Exception> relatedContentsUnsafeSupplier) {
        try {
            this.relatedContents = (RelatedContent[])relatedContentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the site to which this article is scoped.")
    public Long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    @JsonIgnore
    public void setSiteId(UnsafeSupplier<Long, Exception> siteIdUnsafeSupplier) {
        try {
            this.siteId = (Long)siteIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The categories associated with this article.")
    public TaxonomyCategory[] getTaxonomyCategories() {
        return this.taxonomyCategories;
    }

    public void setTaxonomyCategories(TaxonomyCategory[] taxonomyCategories) {
        this.taxonomyCategories = taxonomyCategories;
    }

    @JsonIgnore
    public void setTaxonomyCategories(UnsafeSupplier<TaxonomyCategory[], Exception> taxonomyCategoriesUnsafeSupplier) {
        try {
            this.taxonomyCategories = (TaxonomyCategory[])taxonomyCategoriesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A write-only field that adds taxonomy categories to this article.")
    public Long[] getTaxonomyCategoryIds() {
        return this.taxonomyCategoryIds;
    }

    public void setTaxonomyCategoryIds(Long[] taxonomyCategoryIds) {
        this.taxonomyCategoryIds = taxonomyCategoryIds;
    }

    @JsonIgnore
    public void setTaxonomyCategoryIds(UnsafeSupplier<Long[], Exception> taxonomyCategoryIdsUnsafeSupplier) {
        try {
            this.taxonomyCategoryIds = (Long[])taxonomyCategoryIdsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The article's main title.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonIgnore
    public void setTitle(UnsafeSupplier<String, Exception> titleUnsafeSupplier) {
        try {
            this.title = (String)titleUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A write-only property that specifies the article's default permissions.")
    public ViewableBy getViewableBy() {
        return this.viewableBy;
    }

    @JsonIgnore
    public String getViewableByAsString() {
        if (this.viewableBy == null) {
            return null;
        }
        return this.viewableBy.toString();
    }

    public void setViewableBy(ViewableBy viewableBy) {
        this.viewableBy = viewableBy;
    }

    @JsonIgnore
    public void setViewableBy(UnsafeSupplier<ViewableBy, Exception> viewableByUnsafeSupplier) {
        try {
            this.viewableBy = (ViewableBy)((Object)viewableByUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KnowledgeBaseArticle)) {
            return false;
        }
        KnowledgeBaseArticle knowledgeBaseArticle = (KnowledgeBaseArticle)object;
        return Objects.equals(this.toString(), knowledgeBaseArticle.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.aggregateRating != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"aggregateRating\": ");
            sb.append(String.valueOf(this.aggregateRating));
        }
        if (this.articleBody != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"articleBody\": ");
            sb.append("\"");
            sb.append(KnowledgeBaseArticle._escape(this.articleBody));
            sb.append("\"");
        }
        if (this.creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(this.creator));
        }
        if (this.customFields != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (i = 0; i < this.customFields.length; ++i) {
                sb.append(String.valueOf(this.customFields[i]));
                if (i + 1 >= this.customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateModified != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateModified));
            sb.append("\"");
        }
        if (this.description != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(KnowledgeBaseArticle._escape(this.description));
            sb.append("\"");
        }
        if (this.encodingFormat != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"encodingFormat\": ");
            sb.append("\"");
            sb.append(KnowledgeBaseArticle._escape(this.encodingFormat));
            sb.append("\"");
        }
        if (this.friendlyUrlPath != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"friendlyUrlPath\": ");
            sb.append("\"");
            sb.append(KnowledgeBaseArticle._escape(this.friendlyUrlPath));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.keywords != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywords\": ");
            sb.append("[");
            for (i = 0; i < this.keywords.length; ++i) {
                sb.append("\"");
                sb.append(KnowledgeBaseArticle._escape(this.keywords[i]));
                sb.append("\"");
                if (i + 1 >= this.keywords.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.numberOfAttachments != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfAttachments\": ");
            sb.append((Object)this.numberOfAttachments);
        }
        if (this.numberOfKnowledgeBaseArticles != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfKnowledgeBaseArticles\": ");
            sb.append((Object)this.numberOfKnowledgeBaseArticles);
        }
        if (this.parentKnowledgeBaseFolder != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentKnowledgeBaseFolder\": ");
            sb.append(String.valueOf(this.parentKnowledgeBaseFolder));
        }
        if (this.parentKnowledgeBaseFolderId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentKnowledgeBaseFolderId\": ");
            sb.append((Object)this.parentKnowledgeBaseFolderId);
        }
        if (this.relatedContents != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"relatedContents\": ");
            sb.append("[");
            for (i = 0; i < this.relatedContents.length; ++i) {
                sb.append(String.valueOf(this.relatedContents[i]));
                if (i + 1 >= this.relatedContents.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.siteId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append((Object)this.siteId);
        }
        if (this.taxonomyCategories != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategories\": ");
            sb.append("[");
            for (i = 0; i < this.taxonomyCategories.length; ++i) {
                sb.append(String.valueOf(this.taxonomyCategories[i]));
                if (i + 1 >= this.taxonomyCategories.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.taxonomyCategoryIds != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategoryIds\": ");
            sb.append("[");
            for (i = 0; i < this.taxonomyCategoryIds.length; ++i) {
                sb.append((Object)this.taxonomyCategoryIds[i]);
                if (i + 1 >= this.taxonomyCategoryIds.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.title != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"title\": ");
            sb.append("\"");
            sb.append(KnowledgeBaseArticle._escape(this.title));
            sb.append("\"");
        }
        if (this.viewableBy != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewableBy\": ");
            sb.append("\"");
            sb.append((Object)this.viewableBy);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":");
            sb.append("\"");
            sb.append(entry.getValue());
            sb.append("\"");
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static enum ViewableBy {
        ANYONE("Anyone"),
        MEMBERS("Members"),
        OWNER("Owner");

        private final String _value;

        @JsonCreator
        public static ViewableBy create(String value) {
            for (ViewableBy viewableBy : ViewableBy.values()) {
                if (!Objects.equals(viewableBy.getValue(), value)) continue;
                return viewableBy;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ViewableBy(String value) {
            this._value = value;
        }
    }
}

