/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0.util;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.model.ExpandoColumnConstants;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.CustomValue;
import com.liferay.headless.delivery.dto.v1_0.Geo;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;

public class CustomFieldsUtil {
    public static CustomField[] toCustomFields(boolean acceptAllLanguages, String className, long classPK, long companyId, Locale locale) {
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)companyId, (String)className, (long)classPK);
        Map attributes = expandoBridge.getAttributes();
        return (CustomField[])TransformUtil.transformToArray(attributes.entrySet(), entry -> {
            UnicodeProperties unicodeProperties = expandoBridge.getAttributeProperties((String)entry.getKey());
            if (GetterUtil.getBoolean((String)unicodeProperties.getProperty("hidden"))) {
                return null;
            }
            return CustomFieldsUtil._toCustomField(acceptAllLanguages, entry, expandoBridge, locale);
        }, CustomField.class);
    }

    public static Map<String, Serializable> toMap(String className, long companyId, CustomField[] customFields, Locale locale) {
        if (customFields == null) {
            return null;
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)companyId, (String)className);
        for (CustomField customField : customFields) {
            String fieldName = customField.getName();
            int attributeType = expandoBridge.getAttributeType(fieldName);
            CustomValue customValue = customField.getCustomValue();
            Object data = customValue.getData();
            if (3 == attributeType) {
                map.put(fieldName, CustomFieldsUtil._parseDate(String.valueOf(data)));
                continue;
            }
            if (6 == attributeType) {
                map.put(fieldName, CustomFieldsUtil._toArray(data, ArrayUtil::toDoubleArray));
                continue;
            }
            if (8 == attributeType) {
                map.put(fieldName, CustomFieldsUtil._toArray(data, ArrayUtil::toFloatArray));
                continue;
            }
            if (21 == attributeType) {
                Geo geo = customValue.getGeo();
                map.put(fieldName, (Serializable)((Object)JSONUtil.put((String)"latitude", (Object)geo.getLatitude()).put("longitude", (Object)geo.getLongitude()).toString()));
                continue;
            }
            if (10 == attributeType) {
                map.put(fieldName, CustomFieldsUtil._toArray(data, ArrayUtil::toIntArray));
                continue;
            }
            if (12 == attributeType) {
                map.put(fieldName, CustomFieldsUtil._toArray(data, ArrayUtil::toLongArray));
                continue;
            }
            if (16 == attributeType) {
                map.put(fieldName, CustomFieldsUtil._toArray(data, ArrayUtil::toStringArray));
                continue;
            }
            if (20 == attributeType) {
                map.put(fieldName, (Serializable)((Object)LocalizedMapUtil.getLocalizedMap((Locale)locale, (String)((String)data), customValue.getData_i18n())));
                continue;
            }
            map.put(fieldName, (Serializable)data);
        }
        return map;
    }

    private static Map<String, String> _getLocalizedValues(boolean acceptAllLanguages, int attributeType, Object value) {
        if (20 == attributeType) {
            Map map = (Map)value;
            return LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)map);
        }
        return null;
    }

    private static Object _getValue(int attributeType, Locale locale, Object value) {
        if (20 == attributeType) {
            Map map = (Map)value;
            return map.get(locale);
        }
        if (3 == attributeType) {
            return DateUtil.getDate((Date)((Date)value), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (Locale)locale, (TimeZone)TimeZone.getTimeZone("UTC"));
        }
        return value;
    }

    private static Object _getValue(Map.Entry<String, Serializable> entry, ExpandoBridge expandoBridge, String key) {
        Serializable value = entry.getValue();
        if (CustomFieldsUtil._isEmpty(entry.getValue())) {
            value = expandoBridge.getAttributeDefault(key);
        }
        return value;
    }

    private static boolean _isEmpty(Object value) {
        Map map;
        if (value == null) {
            return true;
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray() && Array.getLength(value) == 0) {
            return true;
        }
        return value instanceof Map && (map = (Map)value).isEmpty();
    }

    private static Serializable _parseDate(String data) {
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
        try {
            return dateFormat.parse(data);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Unable to parse date from " + data, parseException);
        }
    }

    private static <T> Serializable _toArray(Object data, Function<Collection<T>, Serializable> function) {
        if (data instanceof Collection) {
            return function.apply((Collection)data);
        }
        return (Serializable)data;
    }

    private static CustomField _toCustomField(final boolean acceptAllLanguages, final Map.Entry<String, Serializable> entry, final ExpandoBridge expandoBridge, final Locale locale) {
        final String key = entry.getKey();
        final int attributeType = expandoBridge.getAttributeType(key);
        if (21 == attributeType) {
            return new CustomField(){
                {
                    this.dataType = "Geolocation";
                    this.name = (String)entry.getKey();
                    this.setCustomValue((UnsafeSupplier<CustomValue, Exception>)((UnsafeSupplier)() -> {
                        final JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)String.valueOf(entry.getValue()));
                        return new CustomValue(){
                            {
                                this.geo = new Geo(){
                                    {
                                        this.latitude = jsonObject.getDouble("latitude");
                                        this.longitude = jsonObject.getDouble("longitude");
                                    }
                                };
                            }
                        };
                    }));
                }
            };
        }
        return new CustomField(){
            {
                this.customValue = new CustomValue(){
                    {
                        this.data = CustomFieldsUtil._getValue(attributeType, locale, CustomFieldsUtil._getValue(entry, expandoBridge, key));
                        this.data_i18n = CustomFieldsUtil._getLocalizedValues(acceptAllLanguages, attributeType, CustomFieldsUtil._getValue(entry, expandoBridge, key));
                    }
                };
                this.dataType = ExpandoColumnConstants.getDataType((int)attributeType);
                this.name = (String)entry.getKey();
            }
        };
    }
}

