/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents settings related with the site map.", value="SiteMapSettings")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="SiteMapSettings")
public class SiteMapSettings
implements Serializable {
    @GraphQLField(description="Indicates how often a page is updated.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Indicates how often a page is updated.") ChangeFrequency changeFrequency;
    @GraphQLField(description="Whether search engines should crawl and index the page.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Whether search engines should crawl and index the page.") Boolean include;
    @GraphQLField(description="How the page should be prioritized relative to other pages.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="How the page should be prioritized relative to other pages.") Double pagePriority;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.delivery.dto.v1_0.SiteMapSettings", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static SiteMapSettings toDTO(String json) {
        return (SiteMapSettings)ObjectMapperUtil.readValue(SiteMapSettings.class, (String)json);
    }

    public static SiteMapSettings unsafeToDTO(String json) {
        return (SiteMapSettings)ObjectMapperUtil.unsafeReadValue(SiteMapSettings.class, (String)json);
    }

    @Schema(description="Indicates how often a page is updated.")
    @Valid
    public ChangeFrequency getChangeFrequency() {
        return this.changeFrequency;
    }

    @JsonIgnore
    public String getChangeFrequencyAsString() {
        if (this.changeFrequency == null) {
            return null;
        }
        return this.changeFrequency.toString();
    }

    public void setChangeFrequency(ChangeFrequency changeFrequency) {
        this.changeFrequency = changeFrequency;
    }

    @JsonIgnore
    public void setChangeFrequency(UnsafeSupplier<ChangeFrequency, Exception> changeFrequencyUnsafeSupplier) {
        try {
            this.changeFrequency = (ChangeFrequency)((Object)changeFrequencyUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="Whether search engines should crawl and index the page.")
    public Boolean getInclude() {
        return this.include;
    }

    public void setInclude(Boolean include) {
        this.include = include;
    }

    @JsonIgnore
    public void setInclude(UnsafeSupplier<Boolean, Exception> includeUnsafeSupplier) {
        try {
            this.include = (Boolean)includeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMax(value="1")
    @DecimalMin(value="0")
    @Schema(description="How the page should be prioritized relative to other pages.")
    public @DecimalMax(value="1") @DecimalMin(value="0") Double getPagePriority() {
        return this.pagePriority;
    }

    public void setPagePriority(Double pagePriority) {
        this.pagePriority = pagePriority;
    }

    @JsonIgnore
    public void setPagePriority(UnsafeSupplier<Double, Exception> pagePriorityUnsafeSupplier) {
        try {
            this.pagePriority = (Double)pagePriorityUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SiteMapSettings)) {
            return false;
        }
        SiteMapSettings siteMapSettings = (SiteMapSettings)object;
        return Objects.equals(this.toString(), siteMapSettings.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.changeFrequency != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"changeFrequency\": ");
            sb.append("\"");
            sb.append((Object)this.changeFrequency);
            sb.append("\"");
        }
        if (this.include != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"include\": ");
            sb.append((Object)this.include);
        }
        if (this.pagePriority != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"pagePriority\": ");
            sb.append((Object)this.pagePriority);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(SiteMapSettings._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (SiteMapSettings._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(SiteMapSettings._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(SiteMapSettings._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="ChangeFrequency")
    public static enum ChangeFrequency {
        ALWAYS("Always"),
        HOURLY("Hourly"),
        DAILY("Daily"),
        WEEKLY("Weekly"),
        MONTHLY("Monthly"),
        YEARLY("Yearly"),
        NEVER("Never");

        private final String _value;

        @JsonCreator
        public static ChangeFrequency create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (ChangeFrequency changeFrequency : ChangeFrequency.values()) {
                if (!Objects.equals(changeFrequency.getValue(), value)) continue;
                return changeFrequency;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ChangeFrequency(String value) {
            this._value = value;
        }
    }
}

