/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.delivery.dto.v1_0.AggregateRating;
import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.headless.delivery.dto.v1_0.CreatorStatistics;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.RelatedContent;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents a discussion thread in a message board.", value="MessageBoardThread")
@JsonFilter(value="Liferay.Vulcan")
@Schema(description="Represents a discussion thread in a message board.", requiredProperties={"headline"})
@XmlRootElement(name="MessageBoardThread")
public class MessageBoardThread
implements Serializable {
    @GraphQLField(description="Block of actions allowed by the user making the request.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="Block of actions allowed by the user making the request.") Map<String, Map<String, String>> actions;
    @GraphQLField(description="The thread's average rating.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The thread's average rating.") AggregateRating aggregateRating;
    @GraphQLField(description="The thread's main body content (the message written as the thread's description).")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The thread's main body content (the message written as the thread's description).") String articleBody;
    @GraphQLField(description="The thread's creator.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The thread's creator.") Creator creator;
    @GraphQLField(description="The thread's creator statistics (rank, join date, number of posts, ...)")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The thread's creator statistics (rank, join date, number of posts, ...)") CreatorStatistics creatorStatistics;
    @GraphQLField(description="A list of the custom fields associated with the thread.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of the custom fields associated with the thread.") CustomField[] customFields;
    @GraphQLField(description="The date the thread was created.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The date the thread was created.") Date dateCreated;
    @GraphQLField(description="The last time any field of the thread changed.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The last time any field of the thread changed.") Date dateModified;
    @GraphQLField(description="The media format of the thread's content (e.g., HTML, BBCode, etc.).")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The media format of the thread's content (e.g., HTML, BBCode, etc.).") String encodingFormat;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String friendlyUrlPath;
    @GraphQLField(description="A flag that indicates whether this thread has a message considered as valid")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A flag that indicates whether this thread has a message considered as valid") Boolean hasValidAnswer;
    @GraphQLField(description="The thread's main title.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected @GraphQLField(description="The thread's main title.") @NotEmpty String headline;
    @GraphQLField(description="The thread's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The thread's ID.") Long id;
    @GraphQLField(description="A list of keywords describing the thread.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of keywords describing the thread.") String[] keywords;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Date lastPostDate;
    @GraphQLField(description="A flag that indicates whether this thread is locked.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A flag that indicates whether this thread is locked.") Boolean locked;
    @GraphQLField(description="The ID of the thread's message.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The ID of the thread's message.") Long messageBoardRootMessageId;
    @GraphQLField(description="The ID of the Message Board Section to which this message is scoped.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The ID of the Message Board Section to which this message is scoped.") Long messageBoardSectionId;
    @GraphQLField(description="The number of the thread's attachments.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of the thread's attachments.") Integer numberOfMessageBoardAttachments;
    @GraphQLField(description="The number of the thread's messages.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of the thread's messages.") Integer numberOfMessageBoardMessages;
    @GraphQLField(description="A list of related contents to this thread.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A list of related contents to this thread.") RelatedContent[] relatedContents;
    @GraphQLField(description="A flag that indicates whether this thread has been seen.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A flag that indicates whether this thread has been seen.") Boolean seen;
    @GraphQLField(description="A flag that indicates whether this thread was posted as a question that can receive approved answers.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A flag that indicates whether this thread was posted as a question that can receive approved answers.") Boolean showAsQuestion;
    @GraphQLField(description="The ID of the site to which this thread is scoped.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The ID of the site to which this thread is scoped.") Long siteId;
    @GraphQLField(description="The thread's status.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The thread's status.") String status;
    @GraphQLField(description="A flag that indicates whether the user making the requests is subscribed to this thread.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A flag that indicates whether the user making the requests is subscribed to this thread.") Boolean subscribed;
    @GraphQLField(description="The categories associated with this thread.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The categories associated with this thread.") TaxonomyCategoryBrief[] taxonomyCategoryBriefs;
    @GraphQLField(description="A write-only field that adds `TaxonomyCategory` instances to the thread.")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected @GraphQLField(description="A write-only field that adds `TaxonomyCategory` instances to the thread.") Long[] taxonomyCategoryIds;
    @GraphQLField(description="The thread's type.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The thread's type.") String threadType;
    @GraphQLField(description="The number of views of this thread.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of views of this thread.") Long viewCount;
    @GraphQLField(description="A write-only property that specifies the thread's default permissions.")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected @GraphQLField(description="A write-only property that specifies the thread's default permissions.") ViewableBy viewableBy;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.delivery.dto.v1_0.MessageBoardThread", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static MessageBoardThread toDTO(String json) {
        return (MessageBoardThread)ObjectMapperUtil.readValue(MessageBoardThread.class, (String)json);
    }

    public static MessageBoardThread unsafeToDTO(String json) {
        return (MessageBoardThread)ObjectMapperUtil.unsafeReadValue(MessageBoardThread.class, (String)json);
    }

    @Schema(description="Block of actions allowed by the user making the request.")
    @Valid
    public Map<String, Map<String, String>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        try {
            this.actions = (Map)actionsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The thread's average rating.")
    @Valid
    public AggregateRating getAggregateRating() {
        return this.aggregateRating;
    }

    public void setAggregateRating(AggregateRating aggregateRating) {
        this.aggregateRating = aggregateRating;
    }

    @JsonIgnore
    public void setAggregateRating(UnsafeSupplier<AggregateRating, Exception> aggregateRatingUnsafeSupplier) {
        try {
            this.aggregateRating = (AggregateRating)aggregateRatingUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The thread's main body content (the message written as the thread's description).")
    public String getArticleBody() {
        return this.articleBody;
    }

    public void setArticleBody(String articleBody) {
        this.articleBody = articleBody;
    }

    @JsonIgnore
    public void setArticleBody(UnsafeSupplier<String, Exception> articleBodyUnsafeSupplier) {
        try {
            this.articleBody = (String)articleBodyUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The thread's creator.")
    @Valid
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        try {
            this.creator = (Creator)creatorUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The thread's creator statistics (rank, join date, number of posts, ...)")
    @Valid
    public CreatorStatistics getCreatorStatistics() {
        return this.creatorStatistics;
    }

    public void setCreatorStatistics(CreatorStatistics creatorStatistics) {
        this.creatorStatistics = creatorStatistics;
    }

    @JsonIgnore
    public void setCreatorStatistics(UnsafeSupplier<CreatorStatistics, Exception> creatorStatisticsUnsafeSupplier) {
        try {
            this.creatorStatistics = (CreatorStatistics)creatorStatisticsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of the custom fields associated with the thread.")
    @Valid
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        try {
            this.customFields = (CustomField[])customFieldsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The date the thread was created.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The last time any field of the thread changed.")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        try {
            this.dateModified = (Date)dateModifiedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The media format of the thread's content (e.g., HTML, BBCode, etc.).")
    public String getEncodingFormat() {
        return this.encodingFormat;
    }

    public void setEncodingFormat(String encodingFormat) {
        this.encodingFormat = encodingFormat;
    }

    @JsonIgnore
    public void setEncodingFormat(UnsafeSupplier<String, Exception> encodingFormatUnsafeSupplier) {
        try {
            this.encodingFormat = (String)encodingFormatUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getFriendlyUrlPath() {
        return this.friendlyUrlPath;
    }

    public void setFriendlyUrlPath(String friendlyUrlPath) {
        this.friendlyUrlPath = friendlyUrlPath;
    }

    @JsonIgnore
    public void setFriendlyUrlPath(UnsafeSupplier<String, Exception> friendlyUrlPathUnsafeSupplier) {
        try {
            this.friendlyUrlPath = (String)friendlyUrlPathUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A flag that indicates whether this thread has a message considered as valid")
    public Boolean getHasValidAnswer() {
        return this.hasValidAnswer;
    }

    public void setHasValidAnswer(Boolean hasValidAnswer) {
        this.hasValidAnswer = hasValidAnswer;
    }

    @JsonIgnore
    public void setHasValidAnswer(UnsafeSupplier<Boolean, Exception> hasValidAnswerUnsafeSupplier) {
        try {
            this.hasValidAnswer = (Boolean)hasValidAnswerUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The thread's main title.")
    public String getHeadline() {
        return this.headline;
    }

    public void setHeadline(String headline) {
        this.headline = headline;
    }

    @JsonIgnore
    public void setHeadline(UnsafeSupplier<String, Exception> headlineUnsafeSupplier) {
        try {
            this.headline = (String)headlineUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The thread's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of keywords describing the thread.")
    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    @JsonIgnore
    public void setKeywords(UnsafeSupplier<String[], Exception> keywordsUnsafeSupplier) {
        try {
            this.keywords = (String[])keywordsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public Date getLastPostDate() {
        return this.lastPostDate;
    }

    public void setLastPostDate(Date lastPostDate) {
        this.lastPostDate = lastPostDate;
    }

    @JsonIgnore
    public void setLastPostDate(UnsafeSupplier<Date, Exception> lastPostDateUnsafeSupplier) {
        try {
            this.lastPostDate = (Date)lastPostDateUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A flag that indicates whether this thread is locked.")
    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    @JsonIgnore
    public void setLocked(UnsafeSupplier<Boolean, Exception> lockedUnsafeSupplier) {
        try {
            this.locked = (Boolean)lockedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the thread's message.")
    public Long getMessageBoardRootMessageId() {
        return this.messageBoardRootMessageId;
    }

    public void setMessageBoardRootMessageId(Long messageBoardRootMessageId) {
        this.messageBoardRootMessageId = messageBoardRootMessageId;
    }

    @JsonIgnore
    public void setMessageBoardRootMessageId(UnsafeSupplier<Long, Exception> messageBoardRootMessageIdUnsafeSupplier) {
        try {
            this.messageBoardRootMessageId = (Long)messageBoardRootMessageIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the Message Board Section to which this message is scoped.")
    public Long getMessageBoardSectionId() {
        return this.messageBoardSectionId;
    }

    public void setMessageBoardSectionId(Long messageBoardSectionId) {
        this.messageBoardSectionId = messageBoardSectionId;
    }

    @JsonIgnore
    public void setMessageBoardSectionId(UnsafeSupplier<Long, Exception> messageBoardSectionIdUnsafeSupplier) {
        try {
            this.messageBoardSectionId = (Long)messageBoardSectionIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of the thread's attachments.")
    public Integer getNumberOfMessageBoardAttachments() {
        return this.numberOfMessageBoardAttachments;
    }

    public void setNumberOfMessageBoardAttachments(Integer numberOfMessageBoardAttachments) {
        this.numberOfMessageBoardAttachments = numberOfMessageBoardAttachments;
    }

    @JsonIgnore
    public void setNumberOfMessageBoardAttachments(UnsafeSupplier<Integer, Exception> numberOfMessageBoardAttachmentsUnsafeSupplier) {
        try {
            this.numberOfMessageBoardAttachments = (Integer)numberOfMessageBoardAttachmentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of the thread's messages.")
    public Integer getNumberOfMessageBoardMessages() {
        return this.numberOfMessageBoardMessages;
    }

    public void setNumberOfMessageBoardMessages(Integer numberOfMessageBoardMessages) {
        this.numberOfMessageBoardMessages = numberOfMessageBoardMessages;
    }

    @JsonIgnore
    public void setNumberOfMessageBoardMessages(UnsafeSupplier<Integer, Exception> numberOfMessageBoardMessagesUnsafeSupplier) {
        try {
            this.numberOfMessageBoardMessages = (Integer)numberOfMessageBoardMessagesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of related contents to this thread.")
    @Valid
    public RelatedContent[] getRelatedContents() {
        return this.relatedContents;
    }

    public void setRelatedContents(RelatedContent[] relatedContents) {
        this.relatedContents = relatedContents;
    }

    @JsonIgnore
    public void setRelatedContents(UnsafeSupplier<RelatedContent[], Exception> relatedContentsUnsafeSupplier) {
        try {
            this.relatedContents = (RelatedContent[])relatedContentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A flag that indicates whether this thread has been seen.")
    public Boolean getSeen() {
        return this.seen;
    }

    public void setSeen(Boolean seen) {
        this.seen = seen;
    }

    @JsonIgnore
    public void setSeen(UnsafeSupplier<Boolean, Exception> seenUnsafeSupplier) {
        try {
            this.seen = (Boolean)seenUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A flag that indicates whether this thread was posted as a question that can receive approved answers.")
    public Boolean getShowAsQuestion() {
        return this.showAsQuestion;
    }

    public void setShowAsQuestion(Boolean showAsQuestion) {
        this.showAsQuestion = showAsQuestion;
    }

    @JsonIgnore
    public void setShowAsQuestion(UnsafeSupplier<Boolean, Exception> showAsQuestionUnsafeSupplier) {
        try {
            this.showAsQuestion = (Boolean)showAsQuestionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the site to which this thread is scoped.")
    public Long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    @JsonIgnore
    public void setSiteId(UnsafeSupplier<Long, Exception> siteIdUnsafeSupplier) {
        try {
            this.siteId = (Long)siteIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The thread's status.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonIgnore
    public void setStatus(UnsafeSupplier<String, Exception> statusUnsafeSupplier) {
        try {
            this.status = (String)statusUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A flag that indicates whether the user making the requests is subscribed to this thread.")
    public Boolean getSubscribed() {
        return this.subscribed;
    }

    public void setSubscribed(Boolean subscribed) {
        this.subscribed = subscribed;
    }

    @JsonIgnore
    public void setSubscribed(UnsafeSupplier<Boolean, Exception> subscribedUnsafeSupplier) {
        try {
            this.subscribed = (Boolean)subscribedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The categories associated with this thread.")
    @Valid
    public TaxonomyCategoryBrief[] getTaxonomyCategoryBriefs() {
        return this.taxonomyCategoryBriefs;
    }

    public void setTaxonomyCategoryBriefs(TaxonomyCategoryBrief[] taxonomyCategoryBriefs) {
        this.taxonomyCategoryBriefs = taxonomyCategoryBriefs;
    }

    @JsonIgnore
    public void setTaxonomyCategoryBriefs(UnsafeSupplier<TaxonomyCategoryBrief[], Exception> taxonomyCategoryBriefsUnsafeSupplier) {
        try {
            this.taxonomyCategoryBriefs = (TaxonomyCategoryBrief[])taxonomyCategoryBriefsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A write-only field that adds `TaxonomyCategory` instances to the thread.")
    public Long[] getTaxonomyCategoryIds() {
        return this.taxonomyCategoryIds;
    }

    public void setTaxonomyCategoryIds(Long[] taxonomyCategoryIds) {
        this.taxonomyCategoryIds = taxonomyCategoryIds;
    }

    @JsonIgnore
    public void setTaxonomyCategoryIds(UnsafeSupplier<Long[], Exception> taxonomyCategoryIdsUnsafeSupplier) {
        try {
            this.taxonomyCategoryIds = (Long[])taxonomyCategoryIdsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The thread's type.")
    public String getThreadType() {
        return this.threadType;
    }

    public void setThreadType(String threadType) {
        this.threadType = threadType;
    }

    @JsonIgnore
    public void setThreadType(UnsafeSupplier<String, Exception> threadTypeUnsafeSupplier) {
        try {
            this.threadType = (String)threadTypeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of views of this thread.")
    public Long getViewCount() {
        return this.viewCount;
    }

    public void setViewCount(Long viewCount) {
        this.viewCount = viewCount;
    }

    @JsonIgnore
    public void setViewCount(UnsafeSupplier<Long, Exception> viewCountUnsafeSupplier) {
        try {
            this.viewCount = (Long)viewCountUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A write-only property that specifies the thread's default permissions.")
    @Valid
    public ViewableBy getViewableBy() {
        return this.viewableBy;
    }

    @JsonIgnore
    public String getViewableByAsString() {
        if (this.viewableBy == null) {
            return null;
        }
        return this.viewableBy.toString();
    }

    public void setViewableBy(ViewableBy viewableBy) {
        this.viewableBy = viewableBy;
    }

    @JsonIgnore
    public void setViewableBy(UnsafeSupplier<ViewableBy, Exception> viewableByUnsafeSupplier) {
        try {
            this.viewableBy = (ViewableBy)((Object)viewableByUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageBoardThread)) {
            return false;
        }
        MessageBoardThread messageBoardThread = (MessageBoardThread)object;
        return Objects.equals(this.toString(), messageBoardThread.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(MessageBoardThread._toJSON(this.actions));
        }
        if (this.aggregateRating != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"aggregateRating\": ");
            sb.append(String.valueOf(this.aggregateRating));
        }
        if (this.articleBody != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"articleBody\": ");
            sb.append("\"");
            sb.append(MessageBoardThread._escape(this.articleBody));
            sb.append("\"");
        }
        if (this.creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(this.creator));
        }
        if (this.creatorStatistics != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creatorStatistics\": ");
            sb.append(String.valueOf(this.creatorStatistics));
        }
        if (this.customFields != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (i = 0; i < this.customFields.length; ++i) {
                sb.append(String.valueOf(this.customFields[i]));
                if (i + 1 >= this.customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateModified != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateModified));
            sb.append("\"");
        }
        if (this.encodingFormat != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"encodingFormat\": ");
            sb.append("\"");
            sb.append(MessageBoardThread._escape(this.encodingFormat));
            sb.append("\"");
        }
        if (this.friendlyUrlPath != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"friendlyUrlPath\": ");
            sb.append("\"");
            sb.append(MessageBoardThread._escape(this.friendlyUrlPath));
            sb.append("\"");
        }
        if (this.hasValidAnswer != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"hasValidAnswer\": ");
            sb.append((Object)this.hasValidAnswer);
        }
        if (this.headline != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"headline\": ");
            sb.append("\"");
            sb.append(MessageBoardThread._escape(this.headline));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.keywords != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywords\": ");
            sb.append("[");
            for (i = 0; i < this.keywords.length; ++i) {
                sb.append("\"");
                sb.append(MessageBoardThread._escape(this.keywords[i]));
                sb.append("\"");
                if (i + 1 >= this.keywords.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.lastPostDate != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"lastPostDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.lastPostDate));
            sb.append("\"");
        }
        if (this.locked != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"locked\": ");
            sb.append((Object)this.locked);
        }
        if (this.messageBoardRootMessageId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"messageBoardRootMessageId\": ");
            sb.append((Object)this.messageBoardRootMessageId);
        }
        if (this.messageBoardSectionId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"messageBoardSectionId\": ");
            sb.append((Object)this.messageBoardSectionId);
        }
        if (this.numberOfMessageBoardAttachments != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfMessageBoardAttachments\": ");
            sb.append((Object)this.numberOfMessageBoardAttachments);
        }
        if (this.numberOfMessageBoardMessages != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfMessageBoardMessages\": ");
            sb.append((Object)this.numberOfMessageBoardMessages);
        }
        if (this.relatedContents != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"relatedContents\": ");
            sb.append("[");
            for (i = 0; i < this.relatedContents.length; ++i) {
                sb.append(String.valueOf(this.relatedContents[i]));
                if (i + 1 >= this.relatedContents.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.seen != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"seen\": ");
            sb.append((Object)this.seen);
        }
        if (this.showAsQuestion != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"showAsQuestion\": ");
            sb.append((Object)this.showAsQuestion);
        }
        if (this.siteId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append((Object)this.siteId);
        }
        if (this.status != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"status\": ");
            sb.append("\"");
            sb.append(MessageBoardThread._escape(this.status));
            sb.append("\"");
        }
        if (this.subscribed != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"subscribed\": ");
            sb.append((Object)this.subscribed);
        }
        if (this.taxonomyCategoryBriefs != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategoryBriefs\": ");
            sb.append("[");
            for (i = 0; i < this.taxonomyCategoryBriefs.length; ++i) {
                sb.append(String.valueOf(this.taxonomyCategoryBriefs[i]));
                if (i + 1 >= this.taxonomyCategoryBriefs.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.taxonomyCategoryIds != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategoryIds\": ");
            sb.append("[");
            for (i = 0; i < this.taxonomyCategoryIds.length; ++i) {
                sb.append((Object)this.taxonomyCategoryIds[i]);
                if (i + 1 >= this.taxonomyCategoryIds.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.threadType != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"threadType\": ");
            sb.append("\"");
            sb.append(MessageBoardThread._escape(this.threadType));
            sb.append("\"");
        }
        if (this.viewCount != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewCount\": ");
            sb.append((Object)this.viewCount);
        }
        if (this.viewableBy != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewableBy\": ");
            sb.append("\"");
            sb.append((Object)this.viewableBy);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(MessageBoardThread._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (MessageBoardThread._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(MessageBoardThread._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(MessageBoardThread._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="ViewableBy")
    public static enum ViewableBy {
        ANYONE("Anyone"),
        MEMBERS("Members"),
        OWNER("Owner");

        private final String _value;

        @JsonCreator
        public static ViewableBy create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (ViewableBy viewableBy : ViewableBy.values()) {
                if (!Objects.equals(viewableBy.getValue(), value)) continue;
                return viewableBy;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ViewableBy(String value) {
            this._value = value;
        }
    }
}

