/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.delivery.dto.v1_0.ContentSubtype;
import com.liferay.headless.delivery.dto.v1_0.ContentType;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents a Display Page template.", value="DisplayPageTemplate")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="DisplayPageTemplate")
public class DisplayPageTemplate
implements Serializable {
    @GraphQLField(description="The display page template's content subtype.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The display page template's content subtype.") ContentSubtype contentSubtype;
    @GraphQLField(description="The type of content.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The type of content.") ContentType contentType;
    @GraphQLField(description="Specifies if the page template should be the default for the given content type/subtype.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Specifies if the page template should be the default for the given content type/subtype.") Boolean defaultTemplate;
    @GraphQLField(description="The display page template's key.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The display page template's key.") String key;
    @GraphQLField(description="The display page template's name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The display page template's name.") String name;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.delivery.dto.v1_0.DisplayPageTemplate", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static DisplayPageTemplate toDTO(String json) {
        return (DisplayPageTemplate)ObjectMapperUtil.readValue(DisplayPageTemplate.class, (String)json);
    }

    public static DisplayPageTemplate unsafeToDTO(String json) {
        return (DisplayPageTemplate)ObjectMapperUtil.unsafeReadValue(DisplayPageTemplate.class, (String)json);
    }

    @Schema(description="The display page template's content subtype.")
    @Valid
    public ContentSubtype getContentSubtype() {
        return this.contentSubtype;
    }

    public void setContentSubtype(ContentSubtype contentSubtype) {
        this.contentSubtype = contentSubtype;
    }

    @JsonIgnore
    public void setContentSubtype(UnsafeSupplier<ContentSubtype, Exception> contentSubtypeUnsafeSupplier) {
        try {
            this.contentSubtype = (ContentSubtype)contentSubtypeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The type of content.")
    @Valid
    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    @JsonIgnore
    public void setContentType(UnsafeSupplier<ContentType, Exception> contentTypeUnsafeSupplier) {
        try {
            this.contentType = (ContentType)contentTypeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="Specifies if the page template should be the default for the given content type/subtype.")
    public Boolean getDefaultTemplate() {
        return this.defaultTemplate;
    }

    public void setDefaultTemplate(Boolean defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
    }

    @JsonIgnore
    public void setDefaultTemplate(UnsafeSupplier<Boolean, Exception> defaultTemplateUnsafeSupplier) {
        try {
            this.defaultTemplate = (Boolean)defaultTemplateUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The display page template's key.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @JsonIgnore
    public void setKey(UnsafeSupplier<String, Exception> keyUnsafeSupplier) {
        try {
            this.key = (String)keyUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The display page template's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        try {
            this.name = (String)nameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DisplayPageTemplate)) {
            return false;
        }
        DisplayPageTemplate displayPageTemplate = (DisplayPageTemplate)object;
        return Objects.equals(this.toString(), displayPageTemplate.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.contentSubtype != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"contentSubtype\": ");
            sb.append(String.valueOf(this.contentSubtype));
        }
        if (this.contentType != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"contentType\": ");
            sb.append(String.valueOf(this.contentType));
        }
        if (this.defaultTemplate != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"defaultTemplate\": ");
            sb.append((Object)this.defaultTemplate);
        }
        if (this.key != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"key\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(this.key));
            sb.append("\"");
        }
        if (this.name != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(this.name));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(DisplayPageTemplate._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (DisplayPageTemplate._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(DisplayPageTemplate._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(DisplayPageTemplate._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

