/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dynamic.data.mapping;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.List;

public class DDMFormFieldUtil {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormFieldUtil.class);

    public static DDMFormField getDDMFormField(DDMStructureService ddmStructureService, DDMStructure ddmStructure, String name) {
        block5: {
            DDMFormField ddmFormField = DDMFormFieldUtil._getDDMFormField(ddmStructure.getDDMFormFields(true), name);
            if (ddmFormField != null) {
                return ddmFormField;
            }
            if (ddmStructure.getParentStructureId() != -1L) {
                try {
                    DDMStructure parentDDMStructure = ddmStructureService.getStructure(ddmStructure.getParentStructureId());
                    ddmFormField = DDMFormFieldUtil._getDDMFormField(parentDDMStructure.getDDMFormFields(true), name);
                    if (ddmFormField != null) {
                        return ddmFormField;
                    }
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Throwable)portalException);
                }
            }
        }
        return null;
    }

    private static DDMFormField _getDDMFormField(List<DDMFormField> ddmFormFields, String name) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            if (name.equals(ddmFormField.getName())) {
                return ddmFormField;
            }
            if (name.equals(ddmFormField.getFieldReference())) {
                return ddmFormField;
            }
            DDMFormField nestedDDMFormField = DDMFormFieldUtil._getDDMFormField(ddmFormField.getNestedDDMFormFields(), name);
            if (nestedDDMFormField == null) continue;
            return nestedDDMFormField;
        }
        return null;
    }
}

