/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0.util;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.headless.delivery.dto.v1_0.ContentStructure;
import com.liferay.headless.delivery.dto.v1_0.ContentStructureField;
import com.liferay.headless.delivery.dto.v1_0.Option;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.util.GroupUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class ContentStructureUtil {
    public static ContentStructure toContentStructure(final boolean acceptAllLanguages, GroupLocalService groupLocalService, final Locale locale, final Portal portal, final UserLocalService userLocalService, final DDMStructure ddmStructure) {
        if (ddmStructure == null) {
            return null;
        }
        final Group group = groupLocalService.fetchGroup(ddmStructure.getGroupId());
        return new ContentStructure(){
            {
                this.assetLibraryKey = GroupUtil.getAssetLibraryKey((Group)group);
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])ddmStructure.getAvailableLanguageIds());
                this.contentStructureFields = (ContentStructureField[])TransformUtil.transformToArray((Collection)ddmStructure.getRootFieldNames(), fieldName -> ContentStructureUtil._toContentStructureField(acceptAllLanguages, ddmStructure.getDDMFormField(fieldName), locale), ContentStructureField.class);
                this.creator = CreatorUtil.toCreator(portal, Optional.empty(), userLocalService.fetchUser(ddmStructure.getUserId()));
                this.dateCreated = ddmStructure.getCreateDate();
                this.dateModified = ddmStructure.getModifiedDate();
                this.description = ddmStructure.getDescription(locale);
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)ddmStructure.getDescriptionMap());
                this.id = ddmStructure.getStructureId();
                this.name = ddmStructure.getName(locale);
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)ddmStructure.getDescriptionMap());
                this.siteId = GroupUtil.getSiteId((Group)group);
            }
        };
    }

    public static String toDataType(DDMFormField ddmFormField) {
        String type = ddmFormField.getType();
        if ("ddm-documentlibrary".equals(type) || Objects.equals("document_library", type)) {
            return "document";
        }
        if ("ddm-journal-article".equals(type) || Objects.equals("journal_article", type)) {
            return "structuredContent";
        }
        if ("ddm-link-to-page".equals(type) || Objects.equals("link_to_layout", type)) {
            return "url";
        }
        if ("radio".equals(type)) {
            return "string";
        }
        return ddmFormField.getDataType();
    }

    public static String toInputControl(DDMFormField ddmFormField) {
        String type = ddmFormField.getType();
        if ("checkbox".equals(type) || "radio".equals(type) || "select".equals(type) || "text".equals(type) || "textarea".equals(type)) {
            return type;
        }
        return null;
    }

    private static ContentStructureField _toContentStructureField(final boolean acceptAllLanguage, final DDMFormField ddmFormField, final Locale locale) {
        final LocalizedValue labelLocalizedValue = ddmFormField.getLabel();
        final LocalizedValue predefinedLocalizedValue = ddmFormField.getPredefinedValue();
        return new ContentStructureField(){
            {
                this.dataType = ContentStructureUtil.toDataType(ddmFormField);
                this.inputControl = ContentStructureUtil.toInputControl(ddmFormField);
                this.label = ContentStructureUtil._toString(labelLocalizedValue, locale);
                this.label_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguage, (Map)labelLocalizedValue.getValues());
                this.localizable = ddmFormField.isLocalizable();
                this.multiple = ddmFormField.isMultiple();
                this.name = ddmFormField.getFieldReference();
                this.nestedContentStructureFields = (ContentStructureField[])TransformUtil.transformToArray((Collection)ddmFormField.getNestedDDMFormFields(), ddmFormField -> ContentStructureUtil._toContentStructureField(acceptAllLanguage, ddmFormField, locale), ContentStructureField.class);
                this.predefinedValue = ContentStructureUtil._toString(predefinedLocalizedValue, locale);
                this.predefinedValue_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguage, (Map)predefinedLocalizedValue.getValues());
                this.repeatable = ddmFormField.isRepeatable();
                this.required = ddmFormField.isRequired();
                this.showLabel = ddmFormField.isShowLabel();
                this.setOptions((UnsafeSupplier<Option[], Exception>)((UnsafeSupplier)() -> (Option[])Optional.ofNullable(ddmFormField.getDDMFormFieldOptions()).map(DDMFormFieldOptions::getOptions).map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty).map(entry -> new Option((Map.Entry)entry, locale, acceptAllLanguage){
                    final /* synthetic */ Map.Entry val$entry;
                    final /* synthetic */ Locale val$locale;
                    final /* synthetic */ boolean val$acceptAllLanguage;
                    {
                        this.val$entry = entry;
                        this.val$locale = locale;
                        this.val$acceptAllLanguage = bl;
                        LocalizedValue localizedValue = (LocalizedValue)this.val$entry.getValue();
                        this.setLabel(ContentStructureUtil._toString(localizedValue, this.val$locale));
                        this.setLabel_i18n(LocalizedMapUtil.getI18nMap((boolean)this.val$acceptAllLanguage, (Map)localizedValue.getValues()));
                        this.setValue((String)this.val$entry.getKey());
                    }
                }).toArray(Option[]::new)));
            }
        };
    }

    private static String _toString(LocalizedValue localizedValue, Locale locale) {
        if (localizedValue == null) {
            return null;
        }
        return localizedValue.getString(locale);
    }
}

