/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0.util;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.headless.delivery.dto.v1_0.ContentField;
import com.liferay.headless.delivery.dto.v1_0.ContentFieldValue;
import com.liferay.headless.delivery.dto.v1_0.Geo;
import com.liferay.headless.delivery.dto.v1_0.StructuredContent;
import com.liferay.headless.delivery.dto.v1_0.StructuredContentLink;
import com.liferay.headless.delivery.dto.v1_0.util.ContentDocumentUtil;
import com.liferay.headless.delivery.dto.v1_0.util.ContentStructureUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.UriInfo;

public class ContentFieldUtil {
    private static final Log _log = LogFactoryUtil.getLog(ContentFieldUtil.class);

    public static ContentField toContentField(final DDMFormFieldValue ddmFormFieldValue, final DLAppService dlAppService, final DLURLHelper dlURLHelper, final DTOConverterContext dtoConverterContext, final JournalArticleService journalArticleService, final LayoutLocalService layoutLocalService) {
        final DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
        if (ddmFormField == null) {
            return null;
        }
        final LocalizedValue localizedValue = ddmFormField.getLabel();
        return new ContentField(){
            {
                this.contentFieldValue = ContentFieldUtil._toContentFieldValue(ddmFormField, dlAppService, dlURLHelper, dtoConverterContext, journalArticleService, layoutLocalService, dtoConverterContext.getLocale(), ddmFormFieldValue.getValue());
                this.dataType = ContentStructureUtil.toDataType(ddmFormField);
                this.inputControl = ContentStructureUtil.toInputControl(ddmFormField);
                this.label = localizedValue.getString(dtoConverterContext.getLocale());
                this.label_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)localizedValue.getValues());
                this.name = ddmFormField.getFieldReference();
                this.nestedContentFields = (ContentField[])TransformUtil.transformToArray((Collection)ddmFormFieldValue.getNestedDDMFormFieldValues(), value -> ContentFieldUtil.toContentField(value, dlAppService, dlURLHelper, dtoConverterContext, journalArticleService, layoutLocalService), ContentField.class);
                this.repeatable = ddmFormField.isRepeatable();
                this.setContentFieldValue_i18n((UnsafeSupplier<Map<String, ContentFieldValue>, Exception>)((UnsafeSupplier)() -> {
                    if (!dtoConverterContext.isAcceptAllLanguages()) {
                        return null;
                    }
                    HashMap<String, ContentFieldValue> map = new HashMap<String, ContentFieldValue>();
                    Map valueValues = Optional.ofNullable(ddmFormFieldValue.getValue()).map(Value::getValues).orElse(Collections.emptyMap());
                    for (Map.Entry entry : valueValues.entrySet()) {
                        Locale locale = (Locale)entry.getKey();
                        map.put(LocaleUtil.toBCP47LanguageId((Locale)locale), ContentFieldUtil._getContentFieldValue(ddmFormField, dlAppService, dlURLHelper, dtoConverterContext, journalArticleService, layoutLocalService, locale, (String)entry.getValue()));
                    }
                    return map;
                }));
            }
        };
    }

    private static ContentFieldValue _getContentFieldValue(final DDMFormField ddmFormField, final DLAppService dlAppService, final DLURLHelper dlURLHelper, final DTOConverterContext dtoConverterContext, JournalArticleService journalArticleService, LayoutLocalService layoutLocalService, final Locale locale, final String valueString) {
        try {
            final Optional uriInfoOptional = dtoConverterContext.getUriInfoOptional();
            if (Objects.equals("ddm-date", ddmFormField.getType()) || Objects.equals("date", ddmFormField.getType())) {
                return new ContentFieldValue(){
                    {
                        this.data = ContentFieldUtil._toDateString(locale, valueString);
                    }
                };
            }
            if (Objects.equals("ddm-documentlibrary", ddmFormField.getType()) || Objects.equals(ddmFormField.getType(), "document_library")) {
                final FileEntry fileEntry = ContentFieldUtil._getFileEntry(dlAppService, valueString);
                if (fileEntry == null) {
                    return new ContentFieldValue();
                }
                return new ContentFieldValue(){
                    {
                        this.document = ContentDocumentUtil.toContentDocument(dlURLHelper, "contentFields.contentFieldValue.document", fileEntry, uriInfoOptional);
                    }
                };
            }
            if (Objects.equals("geolocation", ddmFormField.getType())) {
                final JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
                return new ContentFieldValue(){
                    {
                        this.geo = new Geo(){
                            {
                                this.latitude = jsonObject.getDouble("lat");
                                this.longitude = jsonObject.getDouble("lng");
                            }
                        };
                    }
                };
            }
            if (Objects.equals("ddm-geolocation", ddmFormField.getType())) {
                final JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
                return new ContentFieldValue(){
                    {
                        this.geo = new Geo(){
                            {
                                this.latitude = jsonObject.getDouble("latitude");
                                this.longitude = jsonObject.getDouble("longitude");
                            }
                        };
                    }
                };
            }
            if (Objects.equals("ddm-image", ddmFormField.getType()) || Objects.equals("image", ddmFormField.getType())) {
                final JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
                final long fileEntryId = jsonObject.getLong("fileEntryId");
                if (fileEntryId == 0L) {
                    return new ContentFieldValue();
                }
                return new ContentFieldValue(){
                    {
                        this.image = ContentDocumentUtil.toContentDocument(dlURLHelper, "contentFields.contentFieldValue.image", dlAppService.getFileEntry(fileEntryId), uriInfoOptional);
                        String alt = jsonObject.getString("alt");
                        if (Validator.isNotNull((String)alt) && JSONUtil.isValid((String)alt)) {
                            JSONObject altJSONObject = jsonObject.getJSONObject("alt");
                            alt = altJSONObject.getString(LocaleUtil.toLanguageId((Locale)locale));
                        }
                        this.image.setDescription(alt);
                    }
                };
            }
            if (Objects.equals("ddm-journal-article", ddmFormField.getType()) || Objects.equals(ddmFormField.getType(), "journal_article")) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
                final long classPK = jsonObject.getLong("classPK");
                if (classPK == 0L) {
                    return new ContentFieldValue();
                }
                final JournalArticle journalArticle = journalArticleService.getLatestArticle(classPK);
                return new ContentFieldValue(){
                    {
                        this.structuredContentLink = new StructuredContentLink(){
                            {
                                this.contentType = "StructuredContent";
                                this.embeddedStructuredContent = ContentFieldUtil._toStructuredContent(classPK, dtoConverterContext);
                                this.id = journalArticle.getResourcePrimKey();
                                this.title = journalArticle.getTitle();
                            }
                        };
                    }
                };
            }
            if (Objects.equals("ddm-link-to-page", ddmFormField.getType()) || Objects.equals("link_to_layout", ddmFormField.getType())) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
                long layoutId = jsonObject.getLong("layoutId");
                if (layoutId == 0L) {
                    return new ContentFieldValue();
                }
                long groupId = jsonObject.getLong("groupId");
                boolean privateLayout = jsonObject.getBoolean("privateLayout");
                final Layout layoutByUuidAndGroupId = layoutLocalService.getLayout(groupId, privateLayout, layoutId);
                return new ContentFieldValue(){
                    {
                        this.link = layoutByUuidAndGroupId.getFriendlyURL();
                    }
                };
            }
            if (Objects.equals("select", ddmFormField.getType()) || Objects.equals(ddmFormField.getType(), "checkbox_multiple")) {
                List list = JSONUtil.toStringList((JSONArray)JSONFactoryUtil.createJSONArray((String)valueString));
                DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
                Stream stream = list.stream();
                final List values = stream.map(arg_0 -> ((DDMFormFieldOptions)ddmFormFieldOptions).getOptionLabels(arg_0)).map(localizedValue -> localizedValue.getString(locale)).collect(Collectors.toList());
                return new ContentFieldValue(){
                    {
                        this.setData((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> {
                            if (!ddmFormField.isMultiple() && values.size() == 1) {
                                return (String)values.get(0);
                            }
                            return String.valueOf(JSONFactoryUtil.createJSONArray((Collection)values));
                        }));
                    }
                };
            }
            if (Objects.equals("radio", ddmFormField.getType())) {
                DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
                final LocalizedValue selectedOptionLabelLocalizedValue = ddmFormFieldOptions.getOptionLabels(valueString);
                return new ContentFieldValue(){
                    {
                        this.data = selectedOptionLabelLocalizedValue.getString(locale);
                    }
                };
            }
            return new ContentFieldValue(){
                {
                    this.data = valueString;
                }
            };
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            return new ContentFieldValue();
        }
    }

    private static FileEntry _getFileEntry(DLAppService dlAppService, String valueString) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
        long classPK = jsonObject.getLong("classPK");
        if (classPK != 0L) {
            return dlAppService.getFileEntry(classPK);
        }
        long groupId = jsonObject.getLong("groupId");
        if (groupId == 0L) {
            return null;
        }
        return dlAppService.getFileEntryByUuidAndGroupId(jsonObject.getString("uuid"), groupId);
    }

    private static ContentFieldValue _toContentFieldValue(DDMFormField ddmFormField, DLAppService dlAppService, DLURLHelper dlURLHelper, DTOConverterContext dtoConverterContext, JournalArticleService journalArticleService, LayoutLocalService layoutLocalService, Locale locale, Value value) {
        if (value == null) {
            return new ContentFieldValue();
        }
        String valueString = String.valueOf(value.getString(locale));
        return ContentFieldUtil._getContentFieldValue(ddmFormField, dlAppService, dlURLHelper, dtoConverterContext, journalArticleService, layoutLocalService, locale, valueString);
    }

    private static String _toDateString(Locale locale, String valueString) {
        if (Validator.isNull((String)valueString)) {
            return "";
        }
        try {
            return DateUtil.getDate((Date)DateUtil.parseDate((String)"yyyy-MM-dd", (String)valueString, (Locale)locale), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (Locale)locale, (TimeZone)TimeZone.getTimeZone("UTC"));
        }
        catch (ParseException parseException) {
            throw new BadRequestException("Unable to parse date that does not conform to ISO-8601", (Throwable)parseException);
        }
    }

    private static StructuredContent _toStructuredContent(long classPK, DTOConverterContext dtoConverterContext) throws Exception {
        Optional uriInfoOptional = dtoConverterContext.getUriInfoOptional();
        if (uriInfoOptional.map(UriInfo::getQueryParameters).map(queryParameters -> (String)queryParameters.getFirst((Object)"nestedFields")).map(nestedFields -> nestedFields.contains("embeddedStructuredContent")).orElse(false).booleanValue()) {
            DTOConverterRegistry dtoConverterRegistry = dtoConverterContext.getDTOConverterRegistry();
            DTOConverter dtoConverter = dtoConverterRegistry.getDTOConverter(JournalArticle.class.getName());
            if (dtoConverter == null) {
                return null;
            }
            return (StructuredContent)dtoConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.isAcceptAllLanguages(), Collections.emptyMap(), dtoConverterRegistry, dtoConverterContext.getHttpServletRequest(), (Object)classPK, dtoConverterContext.getLocale(), (UriInfo)uriInfoOptional.orElse(null), dtoConverterContext.getUser()));
        }
        return null;
    }
}

