/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="CollectionConfig")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"collectionReference", "collectionType"})
@XmlRootElement(name="CollectionConfig")
public class CollectionConfig
implements Serializable {
    @GraphQLField(description="The page collection's reference.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected @GraphQLField(description="The page collection's reference.") @NotNull Object collectionReference;
    @GraphQLField(description="The page collection's type (Collection, CollectionProvider).")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected @GraphQLField(description="The page collection's type (Collection, CollectionProvider).") @NotNull CollectionType collectionType;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.delivery.dto.v1_0.CollectionConfig", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};

    public static CollectionConfig toDTO(String json) {
        return (CollectionConfig)ObjectMapperUtil.readValue(CollectionConfig.class, (String)json);
    }

    public static CollectionConfig unsafeToDTO(String json) {
        return (CollectionConfig)ObjectMapperUtil.unsafeReadValue(CollectionConfig.class, (String)json);
    }

    @Schema(description="The page collection's reference.")
    @Valid
    public Object getCollectionReference() {
        return this.collectionReference;
    }

    public void setCollectionReference(Object collectionReference) {
        this.collectionReference = collectionReference;
    }

    @JsonIgnore
    public void setCollectionReference(UnsafeSupplier<Object, Exception> collectionReferenceUnsafeSupplier) {
        try {
            this.collectionReference = collectionReferenceUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The page collection's type (Collection, CollectionProvider).")
    @Valid
    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    @JsonIgnore
    public String getCollectionTypeAsString() {
        if (this.collectionType == null) {
            return null;
        }
        return this.collectionType.toString();
    }

    public void setCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    @JsonIgnore
    public void setCollectionType(UnsafeSupplier<CollectionType, Exception> collectionTypeUnsafeSupplier) {
        try {
            this.collectionType = (CollectionType)((Object)collectionTypeUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CollectionConfig)) {
            return false;
        }
        CollectionConfig collectionConfig = (CollectionConfig)object;
        return Objects.equals(this.toString(), collectionConfig.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.collectionReference != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"collectionReference\": ");
            if (this.collectionReference instanceof Map) {
                sb.append((Object)JSONFactoryUtil.createJSONObject((Map)((Map)this.collectionReference)));
            } else if (this.collectionReference instanceof String) {
                sb.append("\"");
                sb.append(CollectionConfig._escape((String)this.collectionReference));
                sb.append("\"");
            } else {
                sb.append(this.collectionReference);
            }
        }
        if (this.collectionType != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"collectionType\": ");
            sb.append("\"");
            sb.append((Object)this.collectionType);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(CollectionConfig._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (CollectionConfig._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(CollectionConfig._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(CollectionConfig._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="CollectionType")
    public static enum CollectionType {
        COLLECTION("Collection"),
        COLLECTION_PROVIDER("CollectionProvider");

        private final String _value;

        @JsonCreator
        public static CollectionType create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (CollectionType collectionType : CollectionType.values()) {
                if (!Objects.equals(collectionType.getValue(), value)) continue;
                return collectionType;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private CollectionType(String value) {
            this._value = value;
        }
    }
}

