/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dynamic.data.mapping;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Locale;

public class DDMStructureField {
    private final String _ddmStructureId;
    private final String _fieldReference;
    private final String _indexType;
    private final String _locale;
    private final String _type;

    public static DDMStructureField from(String ddmStructureField) {
        String[] ddmStructureParts = StringUtil.split((String)ddmStructureField, (String)"__");
        String fieldReference = StringUtil.removeSubstring((String)ddmStructureParts[3], (String)"_sortable");
        String type = fieldReference.substring(fieldReference.lastIndexOf("_") + 1);
        String locale = DDMStructureField._getSuffixLocale(fieldReference = fieldReference.substring(0, fieldReference.lastIndexOf("_")));
        if (locale != null) {
            fieldReference = StringUtil.removeSubstring((String)fieldReference, (String)("_" + locale));
        }
        return new DDMStructureField(ddmStructureParts[2], fieldReference, ddmStructureParts[1], locale, type);
    }

    public static String getNestedFieldName() {
        return StringBundler.concat((String[])new String[]{"ddmFieldArray", ".", "ddmFieldName"});
    }

    public String getDDMStructureFieldName() {
        return StringBundler.concat((String[])new String[]{"ddm__", this._indexType, "__", this._ddmStructureId, "__", this._fieldReference, this._getLocaleSuffix()});
    }

    public String getDDMStructureNestedFieldName() {
        return StringBundler.concat((String[])new String[]{"ddmFieldArray", ".", "ddmFieldValue", StringUtil.upperCaseFirstLetter((String)this._indexType), this._getLocaleSuffix()});
    }

    public String getDDMStructureNestedTypeSortableFieldName() {
        return StringBundler.concat((String[])new String[]{"ddmFieldArray", ".", "ddmFieldValue", StringUtil.upperCaseFirstLetter((String)this._indexType), this._getLocaleSuffix(), "_", this._type, "_", "sortable"});
    }

    public String getLocale() {
        return this._locale;
    }

    private static String _getSuffixLocale(String string) {
        for (Locale availableLocale : LanguageUtil.getAvailableLocales()) {
            String availableLanguageId = LocaleUtil.toLanguageId((Locale)availableLocale);
            if (!string.endsWith(availableLanguageId)) continue;
            return availableLanguageId;
        }
        return null;
    }

    private DDMStructureField(String ddmStructureId, String fieldReference, String indexType, String locale, String type) {
        this._ddmStructureId = ddmStructureId;
        this._fieldReference = fieldReference;
        this._indexType = indexType;
        this._locale = locale;
        this._type = type;
    }

    private String _getLocaleSuffix() {
        if (this._locale == null) {
            return "";
        }
        return "_".concat(this._locale);
    }
}

