/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0.util;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.headless.delivery.dto.v1_0.ContentDocument;
import com.liferay.headless.delivery.dto.v1_0.ContentField;
import com.liferay.headless.delivery.dto.v1_0.ContentFieldValue;
import com.liferay.headless.delivery.dto.v1_0.Geo;
import com.liferay.headless.delivery.dto.v1_0.StructuredContentLink;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;

public class DDMValueUtil {
    public static Value toDDMValue(ContentField contentField, DDMFormField ddmFormField, DLAppService dlAppService, long groupId, JournalArticleService journalArticleService, LayoutLocalService layoutLocalService, Locale preferredLocale) {
        ContentFieldValue contentFieldValue = contentField.getContentFieldValue();
        if (contentFieldValue == null) {
            if (Validator.isNull((String)ddmFormField.getDataType())) {
                return null;
            }
            throw new BadRequestException("No value is specified for field " + ddmFormField.getFieldReference());
        }
        if (ddmFormField.isLocalizable()) {
            Map<String, ContentFieldValue> localizedContentFieldValues = contentField.getContentFieldValue_i18n();
            if (Objects.equals("ddm-date", ddmFormField.getType()) || Objects.equals("date", ddmFormField.getType())) {
                return DDMValueUtil._toLocalizedValue(contentFieldValue, localizedContentFieldValues, DDMValueUtil::_toLocalizedDateString, preferredLocale);
            }
            if (Objects.equals("ddm-documentlibrary", ddmFormField.getType()) || Objects.equals(ddmFormField.getType(), "document_library")) {
                return DDMValueUtil._toLocalizedValue(contentFieldValue, localizedContentFieldValues, (localizedContentFieldValue, locale) -> DDMValueUtil._toLocalizedDocument(localizedContentFieldValue, dlAppService), preferredLocale);
            }
            if (Objects.equals("ddm-image", ddmFormField.getType()) || Objects.equals("image", ddmFormField.getType())) {
                return DDMValueUtil._toLocalizedValue(contentFieldValue, localizedContentFieldValues, (localizedContentFieldValue, locale) -> DDMValueUtil._toLocalizedImage(localizedContentFieldValue, dlAppService), preferredLocale);
            }
            if (Objects.equals("ddm-journal-article", ddmFormField.getType()) || Objects.equals(ddmFormField.getType(), "journal_article")) {
                return DDMValueUtil._toLocalizedValue(contentFieldValue, localizedContentFieldValues, (localizedContentFieldValue, locale) -> DDMValueUtil._toLocalizedJournalArticle(localizedContentFieldValue, journalArticleService, locale), preferredLocale);
            }
            if (Objects.equals("radio", ddmFormField.getType()) || Objects.equals("select", ddmFormField.getType()) || Objects.equals("checkbox_multiple", ddmFormField.getType())) {
                return DDMValueUtil._toLocalizedValue(contentFieldValue, localizedContentFieldValues, (localizedContentFieldValue, locale) -> {
                    try {
                        String data = localizedContentFieldValue.getData();
                        ArrayList<String> values = new ArrayList<String>();
                        if (!ddmFormField.isMultiple() && !Objects.equals("checkbox_multiple", ddmFormField.getType())) {
                            values.add(data);
                        } else {
                            values.addAll(JSONUtil.toStringList((JSONArray)JSONFactoryUtil.createJSONArray((String)data)));
                        }
                        List<String> collect = DDMValueUtil._transformValuesToKeys(ddmFormField, locale, values);
                        if (collect.size() == 1 && "radio".equals(ddmFormField.getType())) {
                            return collect.get(0);
                        }
                        return JSONUtil.toString((JSONArray)JSONFactoryUtil.createJSONArray(collect));
                    }
                    catch (JSONException jsonException) {
                        return null;
                    }
                }, preferredLocale);
            }
            if (Objects.equals("ddm-link-to-page", ddmFormField.getType()) || Objects.equals("link_to_layout", ddmFormField.getType())) {
                return DDMValueUtil._toLocalizedValue(contentFieldValue, localizedContentFieldValues, (localizedContentFieldValue, locale) -> DDMValueUtil._toLocalizedLinkToPage(localizedContentFieldValue, groupId, layoutLocalService, locale), preferredLocale);
            }
            if (Objects.equals("ddm-geolocation", ddmFormField.getType()) || Objects.equals("geolocation", ddmFormField.getType())) {
                Geo geo = contentFieldValue.getGeo();
                if (Objects.isNull(geo) || Objects.isNull(geo.getLatitude()) || Objects.isNull(geo.getLongitude())) {
                    throw new BadRequestException("Invalid geo " + geo);
                }
                return DDMValueUtil._toLocalizedValue(contentFieldValue, localizedContentFieldValues, (localizedContentFieldValue, locale) -> JSONUtil.put((String)"lat", (Object)geo.getLatitude()).put("lng", (Object)geo.getLongitude()).toString(), preferredLocale);
            }
            return DDMValueUtil._toLocalizedValue(contentFieldValue, localizedContentFieldValues, (localizedContentFieldValue, locale) -> GetterUtil.getString((String)localizedContentFieldValue.getData()), preferredLocale);
        }
        return new UnlocalizedValue(GetterUtil.getString((String)contentFieldValue.getData()));
    }

    private static Layout _getLayout(long groupId, LayoutLocalService layoutLocalService, String link) {
        Layout layout = layoutLocalService.fetchLayoutByFriendlyURL(groupId, false, link);
        if (layout == null) {
            layout = layoutLocalService.fetchLayoutByFriendlyURL(groupId, true, link);
        }
        if (layout == null) {
            throw new BadRequestException("No page found with friendly URL " + link);
        }
        try {
            LayoutPermissionUtil.check((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        }
        catch (PortalException portalException) {
            throw new BadRequestException("No page found with friendly URL " + link, (Throwable)portalException);
        }
        return layout;
    }

    private static String _getLayoutBreadcrumb(Layout layout, Locale locale) {
        try {
            List ancestors = layout.getAncestors();
            StringBundler sb = new StringBundler(4 * ancestors.size() + 5);
            if (layout.isPrivateLayout()) {
                sb.append(LanguageUtil.get((Locale)locale, (String)"private-pages"));
            } else {
                sb.append(LanguageUtil.get((Locale)locale, (String)"public-pages"));
            }
            sb.append(" ");
            sb.append(">");
            sb.append(" ");
            Collections.reverse(ancestors);
            for (Layout ancestor : ancestors) {
                sb.append(HtmlUtil.escape((String)ancestor.getName(locale)));
                sb.append(" ");
                sb.append(">");
                sb.append(" ");
            }
            sb.append(HtmlUtil.escape((String)layout.getName(locale)));
            return sb.toString();
        }
        catch (PortalException portalException) {
            throw new BadRequestException("No page found with friendly URL " + layout.getName(), (Throwable)portalException);
        }
    }

    private static String _toJSON(String description, DLAppService dlAppService, long fileEntryId) {
        FileEntry fileEntry = null;
        try {
            fileEntry = dlAppService.getFileEntry(fileEntryId);
        }
        catch (Exception exception) {
            throw new BadRequestException("No document exists with ID " + fileEntryId, (Throwable)exception);
        }
        return JSONUtil.put((String)"alt", (Object)description).put("classPK", fileEntry.getFileEntryId()).put("fileEntryId", fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("name", fileEntry.getFileName()).put("resourcePrimKey", fileEntry.getPrimaryKey()).put("title", fileEntry.getFileName()).put("type", "document").put("uuid", fileEntry.getUuid()).toString();
    }

    private static String _toLocalizedDateString(ContentFieldValue contentFieldValue, Locale locale) {
        if (Validator.isNull((String)contentFieldValue.getData())) {
            return "";
        }
        try {
            return DateUtil.getDate((Date)DateUtil.parseDate((String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (String)contentFieldValue.getData(), (Locale)locale), (String)"yyyy-MM-dd", (Locale)locale);
        }
        catch (ParseException parseException) {
            throw new BadRequestException("Unable to parse date that does not conform to ISO-8601", (Throwable)parseException);
        }
    }

    private static String _toLocalizedDocument(ContentFieldValue contentFieldValue, DLAppService dlAppService) {
        String valueString = "";
        ContentDocument contentDocument = contentFieldValue.getDocument();
        if (contentDocument != null && contentDocument.getId() != null) {
            valueString = DDMValueUtil._toJSON("", dlAppService, contentDocument.getId());
        }
        return valueString;
    }

    private static String _toLocalizedImage(ContentFieldValue contentFieldValue, DLAppService dlAppService) {
        String valueString = "";
        ContentDocument contentDocument = contentFieldValue.getImage();
        if (contentDocument != null && contentDocument.getId() != null) {
            valueString = DDMValueUtil._toJSON(contentDocument.getDescription(), dlAppService, contentDocument.getId());
        }
        return valueString;
    }

    private static String _toLocalizedJournalArticle(ContentFieldValue contentFieldValue, JournalArticleService journalArticleService, Locale locale) {
        String valueString = "";
        StructuredContentLink structuredContentLink = contentFieldValue.getStructuredContentLink();
        if (structuredContentLink != null && structuredContentLink.getId() != null) {
            JournalArticle journalArticle = null;
            try {
                journalArticle = journalArticleService.getLatestArticle(structuredContentLink.getId().longValue());
            }
            catch (Exception exception) {
                throw new BadRequestException("No structured content exists with ID " + structuredContentLink.getId(), (Throwable)exception);
            }
            valueString = JSONUtil.put((String)"className", (Object)JournalArticle.class.getName()).put("classPK", journalArticle.getResourcePrimKey()).put("title", journalArticle.getTitle(locale)).toString();
        }
        return valueString;
    }

    private static String _toLocalizedLinkToPage(ContentFieldValue contentFieldValue, long groupId, LayoutLocalService layoutLocalService, Locale locale) {
        String valueString = "";
        if (contentFieldValue.getLink() != null) {
            Layout layout = DDMValueUtil._getLayout(groupId, layoutLocalService, contentFieldValue.getLink());
            valueString = JSONUtil.put((String)"groupId", (Object)String.valueOf(layout.getGroupId())).put("id", layout.getUuid()).put("label", layout.getFriendlyURL()).put("layoutId", layout.getLayoutId()).put("name", DDMValueUtil._getLayoutBreadcrumb(layout, locale)).put("privateLayout", layout.isPrivateLayout()).toString();
        }
        return valueString;
    }

    private static LocalizedValue _toLocalizedValue(ContentFieldValue contentFieldValue, Map<String, ContentFieldValue> localizedContentFieldValues, BiFunction<ContentFieldValue, Locale, String> localizedValueBiFunction, Locale preferredLocale) {
        LocalizedValue localizedValue = new LocalizedValue(preferredLocale);
        localizedValue.addString(preferredLocale, localizedValueBiFunction.apply(contentFieldValue, preferredLocale));
        Optional.ofNullable(localizedContentFieldValues).orElse(Collections.emptyMap()).forEach((languageId, localizedContentFieldValue) -> {
            Locale locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)true, (boolean)false);
            if (locale != null) {
                localizedValue.addString(locale, (String)localizedValueBiFunction.apply((ContentFieldValue)localizedContentFieldValue, locale));
            }
        });
        return localizedValue;
    }

    private static List<String> _transformValuesToKeys(DDMFormField ddmFormField, Locale locale, List<String> values) {
        Stream stream = values.stream();
        return stream.map(value -> {
            DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
            Map options = ddmFormFieldOptions.getOptions();
            Set set = options.entrySet();
            Stream setStream = set.stream();
            return setStream.filter(entry -> {
                LocalizedValue localizedValue = (LocalizedValue)entry.getValue();
                return Objects.equals(localizedValue.getString(locale), value);
            }).map(Map.Entry::getKey).findFirst().orElse("");
        }).collect(Collectors.toList());
    }
}

