/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.delivery.dto.v1_0.Fragment;
import com.liferay.headless.delivery.dto.v1_0.FragmentField;
import com.liferay.headless.delivery.dto.v1_0.FragmentStyle;
import com.liferay.headless.delivery.dto.v1_0.FragmentViewport;
import com.liferay.headless.delivery.dto.v1_0.WidgetInstance;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents a definition of a Page Fragment Instance.", value="PageFragmentInstanceDefinition")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="PageFragmentInstanceDefinition")
public class PageFragmentInstanceDefinition
implements Serializable {
    @GraphQLField(description="The fragment of the page fragment instance.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The fragment of the page fragment instance.") Fragment fragment;
    @GraphQLField(description="The page fragment instance's configuration.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The page fragment instance's configuration.") Map<String, Object> fragmentConfig;
    @GraphQLField(description="The fragment fields of the page fragment instance.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The fragment fields of the page fragment instance.") FragmentField[] fragmentFields;
    @GraphQLField(description="The fragment style of the page fragment instance.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The fragment style of the page fragment instance.") FragmentStyle fragmentStyle;
    @GraphQLField(description="A list of fragment viewports of the page fragment instance.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of fragment viewports of the page fragment instance.") FragmentViewport[] fragmentViewports;
    @GraphQLField(description="A list of widget instances of the page fragment instance.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of widget instances of the page fragment instance.") WidgetInstance[] widgetInstances;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.delivery.dto.v1_0.PageFragmentInstanceDefinition", name="x-class-name")
    public String xClassName;

    public static PageFragmentInstanceDefinition toDTO(String json) {
        return (PageFragmentInstanceDefinition)ObjectMapperUtil.readValue(PageFragmentInstanceDefinition.class, (String)json);
    }

    public static PageFragmentInstanceDefinition unsafeToDTO(String json) {
        return (PageFragmentInstanceDefinition)ObjectMapperUtil.unsafeReadValue(PageFragmentInstanceDefinition.class, (String)json);
    }

    @Schema(description="The fragment of the page fragment instance.")
    @Valid
    public Fragment getFragment() {
        return this.fragment;
    }

    public void setFragment(Fragment fragment) {
        this.fragment = fragment;
    }

    @JsonIgnore
    public void setFragment(UnsafeSupplier<Fragment, Exception> fragmentUnsafeSupplier) {
        try {
            this.fragment = (Fragment)fragmentUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The page fragment instance's configuration.")
    @Valid
    public Map<String, Object> getFragmentConfig() {
        return this.fragmentConfig;
    }

    public void setFragmentConfig(Map<String, Object> fragmentConfig) {
        this.fragmentConfig = fragmentConfig;
    }

    @JsonIgnore
    public void setFragmentConfig(UnsafeSupplier<Map<String, Object>, Exception> fragmentConfigUnsafeSupplier) {
        try {
            this.fragmentConfig = (Map)fragmentConfigUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The fragment fields of the page fragment instance.")
    @Valid
    public FragmentField[] getFragmentFields() {
        return this.fragmentFields;
    }

    public void setFragmentFields(FragmentField[] fragmentFields) {
        this.fragmentFields = fragmentFields;
    }

    @JsonIgnore
    public void setFragmentFields(UnsafeSupplier<FragmentField[], Exception> fragmentFieldsUnsafeSupplier) {
        try {
            this.fragmentFields = (FragmentField[])fragmentFieldsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The fragment style of the page fragment instance.")
    @Valid
    public FragmentStyle getFragmentStyle() {
        return this.fragmentStyle;
    }

    public void setFragmentStyle(FragmentStyle fragmentStyle) {
        this.fragmentStyle = fragmentStyle;
    }

    @JsonIgnore
    public void setFragmentStyle(UnsafeSupplier<FragmentStyle, Exception> fragmentStyleUnsafeSupplier) {
        try {
            this.fragmentStyle = (FragmentStyle)fragmentStyleUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of fragment viewports of the page fragment instance.")
    @Valid
    public FragmentViewport[] getFragmentViewports() {
        return this.fragmentViewports;
    }

    public void setFragmentViewports(FragmentViewport[] fragmentViewports) {
        this.fragmentViewports = fragmentViewports;
    }

    @JsonIgnore
    public void setFragmentViewports(UnsafeSupplier<FragmentViewport[], Exception> fragmentViewportsUnsafeSupplier) {
        try {
            this.fragmentViewports = (FragmentViewport[])fragmentViewportsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of widget instances of the page fragment instance.")
    @Valid
    public WidgetInstance[] getWidgetInstances() {
        return this.widgetInstances;
    }

    public void setWidgetInstances(WidgetInstance[] widgetInstances) {
        this.widgetInstances = widgetInstances;
    }

    @JsonIgnore
    public void setWidgetInstances(UnsafeSupplier<WidgetInstance[], Exception> widgetInstancesUnsafeSupplier) {
        try {
            this.widgetInstances = (WidgetInstance[])widgetInstancesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PageFragmentInstanceDefinition)) {
            return false;
        }
        PageFragmentInstanceDefinition pageFragmentInstanceDefinition = (PageFragmentInstanceDefinition)object;
        return Objects.equals(this.toString(), pageFragmentInstanceDefinition.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.fragment != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fragment\": ");
            sb.append(String.valueOf(this.fragment));
        }
        if (this.fragmentConfig != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fragmentConfig\": ");
            sb.append(PageFragmentInstanceDefinition._toJSON(this.fragmentConfig));
        }
        if (this.fragmentFields != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fragmentFields\": ");
            sb.append("[");
            for (i = 0; i < this.fragmentFields.length; ++i) {
                sb.append(String.valueOf(this.fragmentFields[i]));
                if (i + 1 >= this.fragmentFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.fragmentStyle != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fragmentStyle\": ");
            sb.append(String.valueOf(this.fragmentStyle));
        }
        if (this.fragmentViewports != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fragmentViewports\": ");
            sb.append("[");
            for (i = 0; i < this.fragmentViewports.length; ++i) {
                sb.append(String.valueOf(this.fragmentViewports[i]));
                if (i + 1 >= this.fragmentViewports.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.widgetInstances != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"widgetInstances\": ");
            sb.append("[");
            for (i = 0; i < this.widgetInstances.length; ++i) {
                sb.append(String.valueOf(this.widgetInstances[i]));
                if (i + 1 >= this.widgetInstances.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            if (PageFragmentInstanceDefinition._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(PageFragmentInstanceDefinition._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(value);
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

