/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.delivery.dto.v1_0.AdaptedImage;
import com.liferay.headless.delivery.dto.v1_0.AggregateRating;
import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.DocumentType;
import com.liferay.headless.delivery.dto.v1_0.RelatedContent;
import com.liferay.headless.delivery.dto.v1_0.RenderedContent;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents a Document Library file, storing binary and metadata information. Properties follow the [MediaObject](https://schema.org/MediaObject) specification.", value="Document")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="Document")
public class Document
implements Serializable {
    @GraphQLField(description="Block of actions allowed by the user making the request.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="Block of actions allowed by the user making the request.") Map<String, Map<String, String>> actions;
    @GraphQLField(description="An array of images in several resolutions and sizes, created by the Adaptive Media framework.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="An array of images in several resolutions and sizes, created by the Adaptive Media framework.") AdaptedImage[] adaptedImages;
    @GraphQLField(description="The document's average rating.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The document's average rating.") AggregateRating aggregateRating;
    @GraphQLField(description="The key of the asset library to which the document is scoped.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The key of the asset library to which the document is scoped.") String assetLibraryKey;
    @GraphQLField(description="The document's relative URL.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The document's relative URL.") String contentUrl;
    @GraphQLField(description="The optional field with the content of the document in Base64, can be embedded with nestedFields.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The optional field with the content of the document in Base64, can be embedded with nestedFields.") String contentValue;
    @GraphQLField(description="The document's creator.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The document's creator.") Creator creator;
    @GraphQLField(description="A list of the custom fields associated with the document.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of the custom fields associated with the document.") CustomField[] customFields;
    @GraphQLField(description="The document's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The document's creation date.") Date dateCreated;
    @GraphQLField(description="The last time a field of the document changed.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The last time a field of the document changed.") Date dateModified;
    @GraphQLField(description="The document's description.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The document's description.") String description;
    @GraphQLField(description="The ID of the `DocumentFolder` where this document is stored.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The ID of the `DocumentFolder` where this document is stored.") Long documentFolderId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected DocumentType documentType;
    @GraphQLField(description="The document's content type (e.g., `application/pdf`, etc.).")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The document's content type (e.g., `application/pdf`, etc.).") String encodingFormat;
    @GraphQLField(description="The document's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The document's external reference code.") String externalReferenceCode;
    @GraphQLField(description="The document's file extension.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The document's file extension.") String fileExtension;
    @GraphQLField(description="The document's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The document's ID.") Long id;
    @GraphQLField(description="A list of keywords describing the document.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of keywords describing the document.") String[] keywords;
    @GraphQLField(description="The number of comments on the document.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of comments on the document.") Integer numberOfComments;
    @GraphQLField(description="A list of related contents to this document.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A list of related contents to this document.") RelatedContent[] relatedContents;
    @GraphQLField(description="A list of rendered documents, which results from using a display page to process the document and return HTML.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A list of rendered documents, which results from using a display page to process the document and return HTML.") RenderedContent[] renderedContents;
    @GraphQLField(description="The ID of the site to which this document is scoped.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The ID of the site to which this document is scoped.") Long siteId;
    @GraphQLField(description="The document's size in bytes.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The document's size in bytes.") Long sizeInBytes;
    @GraphQLField(description="The categories associated with this document.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The categories associated with this document.") TaxonomyCategoryBrief[] taxonomyCategoryBriefs;
    @GraphQLField(description="A write-only field that adds `TaxonomyCategory` instances to the document.")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected @GraphQLField(description="A write-only field that adds `TaxonomyCategory` instances to the document.") Long[] taxonomyCategoryIds;
    @GraphQLField(description="The document's main title/name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The document's main title/name.") String title;
    @GraphQLField(description="A write-only property that specifies the document's default permissions.")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected @GraphQLField(description="A write-only property that specifies the document's default permissions.") ViewableBy viewableBy;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.delivery.dto.v1_0.Document", name="x-class-name")
    public String xClassName;

    public static Document toDTO(String json) {
        return (Document)ObjectMapperUtil.readValue(Document.class, (String)json);
    }

    public static Document unsafeToDTO(String json) {
        return (Document)ObjectMapperUtil.unsafeReadValue(Document.class, (String)json);
    }

    @Schema(description="Block of actions allowed by the user making the request.")
    @Valid
    public Map<String, Map<String, String>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        try {
            this.actions = (Map)actionsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="An array of images in several resolutions and sizes, created by the Adaptive Media framework.")
    @Valid
    public AdaptedImage[] getAdaptedImages() {
        return this.adaptedImages;
    }

    public void setAdaptedImages(AdaptedImage[] adaptedImages) {
        this.adaptedImages = adaptedImages;
    }

    @JsonIgnore
    public void setAdaptedImages(UnsafeSupplier<AdaptedImage[], Exception> adaptedImagesUnsafeSupplier) {
        try {
            this.adaptedImages = (AdaptedImage[])adaptedImagesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's average rating.")
    @Valid
    public AggregateRating getAggregateRating() {
        return this.aggregateRating;
    }

    public void setAggregateRating(AggregateRating aggregateRating) {
        this.aggregateRating = aggregateRating;
    }

    @JsonIgnore
    public void setAggregateRating(UnsafeSupplier<AggregateRating, Exception> aggregateRatingUnsafeSupplier) {
        try {
            this.aggregateRating = (AggregateRating)aggregateRatingUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The key of the asset library to which the document is scoped.")
    public String getAssetLibraryKey() {
        return this.assetLibraryKey;
    }

    public void setAssetLibraryKey(String assetLibraryKey) {
        this.assetLibraryKey = assetLibraryKey;
    }

    @JsonIgnore
    public void setAssetLibraryKey(UnsafeSupplier<String, Exception> assetLibraryKeyUnsafeSupplier) {
        try {
            this.assetLibraryKey = (String)assetLibraryKeyUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's relative URL.")
    public String getContentUrl() {
        return this.contentUrl;
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    @JsonIgnore
    public void setContentUrl(UnsafeSupplier<String, Exception> contentUrlUnsafeSupplier) {
        try {
            this.contentUrl = (String)contentUrlUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The optional field with the content of the document in Base64, can be embedded with nestedFields.")
    public String getContentValue() {
        return this.contentValue;
    }

    public void setContentValue(String contentValue) {
        this.contentValue = contentValue;
    }

    @JsonIgnore
    public void setContentValue(UnsafeSupplier<String, Exception> contentValueUnsafeSupplier) {
        try {
            this.contentValue = (String)contentValueUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's creator.")
    @Valid
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        try {
            this.creator = (Creator)creatorUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of the custom fields associated with the document.")
    @Valid
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        try {
            this.customFields = (CustomField[])customFieldsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's creation date.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The last time a field of the document changed.")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        try {
            this.dateModified = (Date)dateModifiedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<String, Exception> descriptionUnsafeSupplier) {
        try {
            this.description = (String)descriptionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the `DocumentFolder` where this document is stored.")
    public Long getDocumentFolderId() {
        return this.documentFolderId;
    }

    public void setDocumentFolderId(Long documentFolderId) {
        this.documentFolderId = documentFolderId;
    }

    @JsonIgnore
    public void setDocumentFolderId(UnsafeSupplier<Long, Exception> documentFolderIdUnsafeSupplier) {
        try {
            this.documentFolderId = (Long)documentFolderIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    @JsonIgnore
    public void setDocumentType(UnsafeSupplier<DocumentType, Exception> documentTypeUnsafeSupplier) {
        try {
            this.documentType = (DocumentType)documentTypeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's content type (e.g., `application/pdf`, etc.).")
    public String getEncodingFormat() {
        return this.encodingFormat;
    }

    public void setEncodingFormat(String encodingFormat) {
        this.encodingFormat = encodingFormat;
    }

    @JsonIgnore
    public void setEncodingFormat(UnsafeSupplier<String, Exception> encodingFormatUnsafeSupplier) {
        try {
            this.encodingFormat = (String)encodingFormatUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's external reference code.")
    public String getExternalReferenceCode() {
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        try {
            this.externalReferenceCode = (String)externalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's file extension.")
    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @JsonIgnore
    public void setFileExtension(UnsafeSupplier<String, Exception> fileExtensionUnsafeSupplier) {
        try {
            this.fileExtension = (String)fileExtensionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of keywords describing the document.")
    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    @JsonIgnore
    public void setKeywords(UnsafeSupplier<String[], Exception> keywordsUnsafeSupplier) {
        try {
            this.keywords = (String[])keywordsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of comments on the document.")
    public Integer getNumberOfComments() {
        return this.numberOfComments;
    }

    public void setNumberOfComments(Integer numberOfComments) {
        this.numberOfComments = numberOfComments;
    }

    @JsonIgnore
    public void setNumberOfComments(UnsafeSupplier<Integer, Exception> numberOfCommentsUnsafeSupplier) {
        try {
            this.numberOfComments = (Integer)numberOfCommentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of related contents to this document.")
    @Valid
    public RelatedContent[] getRelatedContents() {
        return this.relatedContents;
    }

    public void setRelatedContents(RelatedContent[] relatedContents) {
        this.relatedContents = relatedContents;
    }

    @JsonIgnore
    public void setRelatedContents(UnsafeSupplier<RelatedContent[], Exception> relatedContentsUnsafeSupplier) {
        try {
            this.relatedContents = (RelatedContent[])relatedContentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of rendered documents, which results from using a display page to process the document and return HTML.")
    @Valid
    public RenderedContent[] getRenderedContents() {
        return this.renderedContents;
    }

    public void setRenderedContents(RenderedContent[] renderedContents) {
        this.renderedContents = renderedContents;
    }

    @JsonIgnore
    public void setRenderedContents(UnsafeSupplier<RenderedContent[], Exception> renderedContentsUnsafeSupplier) {
        try {
            this.renderedContents = (RenderedContent[])renderedContentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the site to which this document is scoped.")
    public Long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    @JsonIgnore
    public void setSiteId(UnsafeSupplier<Long, Exception> siteIdUnsafeSupplier) {
        try {
            this.siteId = (Long)siteIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's size in bytes.")
    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    @JsonIgnore
    public void setSizeInBytes(UnsafeSupplier<Long, Exception> sizeInBytesUnsafeSupplier) {
        try {
            this.sizeInBytes = (Long)sizeInBytesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The categories associated with this document.")
    @Valid
    public TaxonomyCategoryBrief[] getTaxonomyCategoryBriefs() {
        return this.taxonomyCategoryBriefs;
    }

    public void setTaxonomyCategoryBriefs(TaxonomyCategoryBrief[] taxonomyCategoryBriefs) {
        this.taxonomyCategoryBriefs = taxonomyCategoryBriefs;
    }

    @JsonIgnore
    public void setTaxonomyCategoryBriefs(UnsafeSupplier<TaxonomyCategoryBrief[], Exception> taxonomyCategoryBriefsUnsafeSupplier) {
        try {
            this.taxonomyCategoryBriefs = (TaxonomyCategoryBrief[])taxonomyCategoryBriefsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A write-only field that adds `TaxonomyCategory` instances to the document.")
    public Long[] getTaxonomyCategoryIds() {
        return this.taxonomyCategoryIds;
    }

    public void setTaxonomyCategoryIds(Long[] taxonomyCategoryIds) {
        this.taxonomyCategoryIds = taxonomyCategoryIds;
    }

    @JsonIgnore
    public void setTaxonomyCategoryIds(UnsafeSupplier<Long[], Exception> taxonomyCategoryIdsUnsafeSupplier) {
        try {
            this.taxonomyCategoryIds = (Long[])taxonomyCategoryIdsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's main title/name.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonIgnore
    public void setTitle(UnsafeSupplier<String, Exception> titleUnsafeSupplier) {
        try {
            this.title = (String)titleUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A write-only property that specifies the document's default permissions.")
    @Valid
    public ViewableBy getViewableBy() {
        return this.viewableBy;
    }

    @JsonIgnore
    public String getViewableByAsString() {
        if (this.viewableBy == null) {
            return null;
        }
        return this.viewableBy.toString();
    }

    public void setViewableBy(ViewableBy viewableBy) {
        this.viewableBy = viewableBy;
    }

    @JsonIgnore
    public void setViewableBy(UnsafeSupplier<ViewableBy, Exception> viewableByUnsafeSupplier) {
        try {
            this.viewableBy = (ViewableBy)((Object)viewableByUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Document)) {
            return false;
        }
        Document document = (Document)object;
        return Objects.equals(this.toString(), document.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(Document._toJSON(this.actions));
        }
        if (this.adaptedImages != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"adaptedImages\": ");
            sb.append("[");
            for (i = 0; i < this.adaptedImages.length; ++i) {
                sb.append(String.valueOf(this.adaptedImages[i]));
                if (i + 1 >= this.adaptedImages.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.aggregateRating != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"aggregateRating\": ");
            sb.append(String.valueOf(this.aggregateRating));
        }
        if (this.assetLibraryKey != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"assetLibraryKey\": ");
            sb.append("\"");
            sb.append(Document._escape(this.assetLibraryKey));
            sb.append("\"");
        }
        if (this.contentUrl != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"contentUrl\": ");
            sb.append("\"");
            sb.append(Document._escape(this.contentUrl));
            sb.append("\"");
        }
        if (this.contentValue != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"contentValue\": ");
            sb.append("\"");
            sb.append(Document._escape(this.contentValue));
            sb.append("\"");
        }
        if (this.creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(this.creator));
        }
        if (this.customFields != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (i = 0; i < this.customFields.length; ++i) {
                sb.append(String.valueOf(this.customFields[i]));
                if (i + 1 >= this.customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateModified != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateModified));
            sb.append("\"");
        }
        if (this.description != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(Document._escape(this.description));
            sb.append("\"");
        }
        if (this.documentFolderId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"documentFolderId\": ");
            sb.append((Object)this.documentFolderId);
        }
        if (this.documentType != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"documentType\": ");
            sb.append(String.valueOf(this.documentType));
        }
        if (this.encodingFormat != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"encodingFormat\": ");
            sb.append("\"");
            sb.append(Document._escape(this.encodingFormat));
            sb.append("\"");
        }
        if (this.externalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Document._escape(this.externalReferenceCode));
            sb.append("\"");
        }
        if (this.fileExtension != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fileExtension\": ");
            sb.append("\"");
            sb.append(Document._escape(this.fileExtension));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.keywords != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywords\": ");
            sb.append("[");
            for (i = 0; i < this.keywords.length; ++i) {
                sb.append("\"");
                sb.append(Document._escape(this.keywords[i]));
                sb.append("\"");
                if (i + 1 >= this.keywords.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.numberOfComments != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfComments\": ");
            sb.append((Object)this.numberOfComments);
        }
        if (this.relatedContents != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"relatedContents\": ");
            sb.append("[");
            for (i = 0; i < this.relatedContents.length; ++i) {
                sb.append(String.valueOf(this.relatedContents[i]));
                if (i + 1 >= this.relatedContents.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.renderedContents != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"renderedContents\": ");
            sb.append("[");
            for (i = 0; i < this.renderedContents.length; ++i) {
                sb.append(String.valueOf(this.renderedContents[i]));
                if (i + 1 >= this.renderedContents.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.siteId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append((Object)this.siteId);
        }
        if (this.sizeInBytes != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"sizeInBytes\": ");
            sb.append((Object)this.sizeInBytes);
        }
        if (this.taxonomyCategoryBriefs != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategoryBriefs\": ");
            sb.append("[");
            for (i = 0; i < this.taxonomyCategoryBriefs.length; ++i) {
                sb.append(String.valueOf(this.taxonomyCategoryBriefs[i]));
                if (i + 1 >= this.taxonomyCategoryBriefs.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.taxonomyCategoryIds != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategoryIds\": ");
            sb.append("[");
            for (i = 0; i < this.taxonomyCategoryIds.length; ++i) {
                sb.append((Object)this.taxonomyCategoryIds[i]);
                if (i + 1 >= this.taxonomyCategoryIds.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.title != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"title\": ");
            sb.append("\"");
            sb.append(Document._escape(this.title));
            sb.append("\"");
        }
        if (this.viewableBy != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewableBy\": ");
            sb.append("\"");
            sb.append((Object)this.viewableBy);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            if (Document._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Document._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(value);
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="ViewableBy")
    public static enum ViewableBy {
        ANYONE("Anyone"),
        MEMBERS("Members"),
        OWNER("Owner");

        private final String _value;

        @JsonCreator
        public static ViewableBy create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (ViewableBy viewableBy : ViewableBy.values()) {
                if (!Objects.equals(viewableBy.getValue(), value)) continue;
                return viewableBy;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ViewableBy(String value) {
            this._value = value;
        }
    }
}

