/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="An array of images in several resolutions and sizes, created by the Adaptive Media framework.", value="AdaptedImage")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="AdaptedImage")
public class AdaptedImage
implements Serializable {
    @GraphQLField(description="The image's relative URL.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The image's relative URL.") String contentUrl;
    @GraphQLField(description="optional field with the content of the image in Base64, can be embedded with nestedFields")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="optional field with the content of the image in Base64, can be embedded with nestedFields") String contentValue;
    @GraphQLField(description="The image's height in pixels.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The image's height in pixels.") Integer height;
    @GraphQLField(description="The name of the image's Adaptive Media image resolution.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The name of the image's Adaptive Media image resolution.") String resolutionName;
    @GraphQLField(description="The image's size in bytes.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The image's size in bytes.") Long sizeInBytes;
    @GraphQLField(description="The image's width in pixels.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The image's width in pixels.") Integer width;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.delivery.dto.v1_0.AdaptedImage", name="x-class-name")
    public String xClassName;

    public static AdaptedImage toDTO(String json) {
        return (AdaptedImage)ObjectMapperUtil.readValue(AdaptedImage.class, (String)json);
    }

    public static AdaptedImage unsafeToDTO(String json) {
        return (AdaptedImage)ObjectMapperUtil.unsafeReadValue(AdaptedImage.class, (String)json);
    }

    @Schema(description="The image's relative URL.")
    public String getContentUrl() {
        return this.contentUrl;
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    @JsonIgnore
    public void setContentUrl(UnsafeSupplier<String, Exception> contentUrlUnsafeSupplier) {
        try {
            this.contentUrl = (String)contentUrlUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="optional field with the content of the image in Base64, can be embedded with nestedFields")
    public String getContentValue() {
        return this.contentValue;
    }

    public void setContentValue(String contentValue) {
        this.contentValue = contentValue;
    }

    @JsonIgnore
    public void setContentValue(UnsafeSupplier<String, Exception> contentValueUnsafeSupplier) {
        try {
            this.contentValue = (String)contentValueUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The image's height in pixels.")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    @JsonIgnore
    public void setHeight(UnsafeSupplier<Integer, Exception> heightUnsafeSupplier) {
        try {
            this.height = (Integer)heightUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The name of the image's Adaptive Media image resolution.")
    public String getResolutionName() {
        return this.resolutionName;
    }

    public void setResolutionName(String resolutionName) {
        this.resolutionName = resolutionName;
    }

    @JsonIgnore
    public void setResolutionName(UnsafeSupplier<String, Exception> resolutionNameUnsafeSupplier) {
        try {
            this.resolutionName = (String)resolutionNameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The image's size in bytes.")
    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    @JsonIgnore
    public void setSizeInBytes(UnsafeSupplier<Long, Exception> sizeInBytesUnsafeSupplier) {
        try {
            this.sizeInBytes = (Long)sizeInBytesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The image's width in pixels.")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    @JsonIgnore
    public void setWidth(UnsafeSupplier<Integer, Exception> widthUnsafeSupplier) {
        try {
            this.width = (Integer)widthUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AdaptedImage)) {
            return false;
        }
        AdaptedImage adaptedImage = (AdaptedImage)object;
        return Objects.equals(this.toString(), adaptedImage.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.contentUrl != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"contentUrl\": ");
            sb.append("\"");
            sb.append(AdaptedImage._escape(this.contentUrl));
            sb.append("\"");
        }
        if (this.contentValue != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"contentValue\": ");
            sb.append("\"");
            sb.append(AdaptedImage._escape(this.contentValue));
            sb.append("\"");
        }
        if (this.height != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"height\": ");
            sb.append((Object)this.height);
        }
        if (this.resolutionName != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"resolutionName\": ");
            sb.append("\"");
            sb.append(AdaptedImage._escape(this.resolutionName));
            sb.append("\"");
        }
        if (this.sizeInBytes != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"sizeInBytes\": ");
            sb.append((Object)this.sizeInBytes);
        }
        if (this.width != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"width\": ");
            sb.append((Object)this.width);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            if (AdaptedImage._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(AdaptedImage._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(value);
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

