/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.batch.engine.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.batch.engine.dto.v1_0.FailedItem;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="ImportTask")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="ImportTask")
public class ImportTask
implements Serializable {
    @GraphQLField(description="The item class name for which data will be processed in batch.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The item class name for which data will be processed in batch.") String className;
    @GraphQLField(description="The file content type.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The file content type.") String contentType;
    @GraphQLField(description="The end time of import task operation.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The end time of import task operation.") Date endTime;
    @GraphQLField(description="The error message in case of import task's failed execution.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The error message in case of import task's failed execution.") String errorMessage;
    @GraphQLField(description="The status of import task's execution.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The status of import task's execution.") ExecuteStatus executeStatus;
    @GraphQLField(description="The optional external key of this account.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The optional external key of this account.") String externalReferenceCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected FailedItem[] failedItems;
    @GraphQLField(description="The task's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The task's ID.") Long id;
    @GraphQLField(description="Defines if import task will fail when error occurs or continue importing rest of the items.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Defines if import task will fail when error occurs or continue importing rest of the items.") ImportStrategy importStrategy;
    @GraphQLField(description="The operation of import task.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The operation of import task.") Operation operation;
    @GraphQLField(description="Number of items processed by import task opeartion.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Number of items processed by import task opeartion.") Integer processedItemsCount;
    @GraphQLField(description="The start time of import task operation.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The start time of import task operation.") Date startTime;
    @GraphQLField(description="Total number of items that will be processed by import task operation.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="Total number of items that will be processed by import task operation.") Integer totalItemsCount;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.batch.engine.dto.v1_0.ImportTask", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};

    public static ImportTask toDTO(String json) {
        return (ImportTask)ObjectMapperUtil.readValue(ImportTask.class, (String)json);
    }

    public static ImportTask unsafeToDTO(String json) {
        return (ImportTask)ObjectMapperUtil.unsafeReadValue(ImportTask.class, (String)json);
    }

    @Schema(description="The item class name for which data will be processed in batch.", example="com.liferay.headless.delivery.dto.v1_0.BlogPosting")
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @JsonIgnore
    public void setClassName(UnsafeSupplier<String, Exception> classNameUnsafeSupplier) {
        try {
            this.className = (String)classNameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The file content type.", example="JSON")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonIgnore
    public void setContentType(UnsafeSupplier<String, Exception> contentTypeUnsafeSupplier) {
        try {
            this.contentType = (String)contentTypeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The end time of import task operation.", example="2019-27-09'T'08:33:33'Z'")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @JsonIgnore
    public void setEndTime(UnsafeSupplier<Date, Exception> endTimeUnsafeSupplier) {
        try {
            this.endTime = (Date)endTimeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The error message in case of import task's failed execution.", example="File import failed")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @JsonIgnore
    public void setErrorMessage(UnsafeSupplier<String, Exception> errorMessageUnsafeSupplier) {
        try {
            this.errorMessage = (String)errorMessageUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The status of import task's execution.", example="INITIALIZED")
    @Valid
    public ExecuteStatus getExecuteStatus() {
        return this.executeStatus;
    }

    @JsonIgnore
    public String getExecuteStatusAsString() {
        if (this.executeStatus == null) {
            return null;
        }
        return this.executeStatus.toString();
    }

    public void setExecuteStatus(ExecuteStatus executeStatus) {
        this.executeStatus = executeStatus;
    }

    @JsonIgnore
    public void setExecuteStatus(UnsafeSupplier<ExecuteStatus, Exception> executeStatusUnsafeSupplier) {
        try {
            this.executeStatus = (ExecuteStatus)((Object)executeStatusUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The optional external key of this account.")
    public String getExternalReferenceCode() {
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        try {
            this.externalReferenceCode = (String)externalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public FailedItem[] getFailedItems() {
        return this.failedItems;
    }

    public void setFailedItems(FailedItem[] failedItems) {
        this.failedItems = failedItems;
    }

    @JsonIgnore
    public void setFailedItems(UnsafeSupplier<FailedItem[], Exception> failedItemsUnsafeSupplier) {
        try {
            this.failedItems = (FailedItem[])failedItemsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(description="The task's ID.", example="30130")
    public @DecimalMin(value="0") Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="Defines if import task will fail when error occurs or continue importing rest of the items.")
    @Valid
    public ImportStrategy getImportStrategy() {
        return this.importStrategy;
    }

    @JsonIgnore
    public String getImportStrategyAsString() {
        if (this.importStrategy == null) {
            return null;
        }
        return this.importStrategy.toString();
    }

    public void setImportStrategy(ImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
    }

    @JsonIgnore
    public void setImportStrategy(UnsafeSupplier<ImportStrategy, Exception> importStrategyUnsafeSupplier) {
        try {
            this.importStrategy = (ImportStrategy)((Object)importStrategyUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The operation of import task.", example="CREATE")
    @Valid
    public Operation getOperation() {
        return this.operation;
    }

    @JsonIgnore
    public String getOperationAsString() {
        if (this.operation == null) {
            return null;
        }
        return this.operation.toString();
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    @JsonIgnore
    public void setOperation(UnsafeSupplier<Operation, Exception> operationUnsafeSupplier) {
        try {
            this.operation = (Operation)((Object)operationUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(description="Number of items processed by import task opeartion.", example="100")
    public @DecimalMin(value="0") Integer getProcessedItemsCount() {
        return this.processedItemsCount;
    }

    public void setProcessedItemsCount(Integer processedItemsCount) {
        this.processedItemsCount = processedItemsCount;
    }

    @JsonIgnore
    public void setProcessedItemsCount(UnsafeSupplier<Integer, Exception> processedItemsCountUnsafeSupplier) {
        try {
            this.processedItemsCount = (Integer)processedItemsCountUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The start time of import task operation.", example="2019-27-09'T'08:23:33'Z'")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @JsonIgnore
    public void setStartTime(UnsafeSupplier<Date, Exception> startTimeUnsafeSupplier) {
        try {
            this.startTime = (Date)startTimeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(description="Total number of items that will be processed by import task operation.", example="1000")
    public @DecimalMin(value="0") Integer getTotalItemsCount() {
        return this.totalItemsCount;
    }

    public void setTotalItemsCount(Integer totalItemsCount) {
        this.totalItemsCount = totalItemsCount;
    }

    @JsonIgnore
    public void setTotalItemsCount(UnsafeSupplier<Integer, Exception> totalItemsCountUnsafeSupplier) {
        try {
            this.totalItemsCount = (Integer)totalItemsCountUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ImportTask)) {
            return false;
        }
        ImportTask importTask = (ImportTask)object;
        return Objects.equals(this.toString(), importTask.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.className != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"className\": ");
            sb.append("\"");
            sb.append(ImportTask._escape(this.className));
            sb.append("\"");
        }
        if (this.contentType != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"contentType\": ");
            sb.append("\"");
            sb.append(ImportTask._escape(this.contentType));
            sb.append("\"");
        }
        if (this.endTime != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"endTime\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.endTime));
            sb.append("\"");
        }
        if (this.errorMessage != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"errorMessage\": ");
            sb.append("\"");
            sb.append(ImportTask._escape(this.errorMessage));
            sb.append("\"");
        }
        if (this.executeStatus != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"executeStatus\": ");
            sb.append("\"");
            sb.append((Object)this.executeStatus);
            sb.append("\"");
        }
        if (this.externalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(ImportTask._escape(this.externalReferenceCode));
            sb.append("\"");
        }
        if (this.failedItems != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"failedItems\": ");
            sb.append("[");
            for (int i = 0; i < this.failedItems.length; ++i) {
                sb.append(String.valueOf(this.failedItems[i]));
                if (i + 1 >= this.failedItems.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.importStrategy != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"importStrategy\": ");
            sb.append("\"");
            sb.append((Object)this.importStrategy);
            sb.append("\"");
        }
        if (this.operation != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"operation\": ");
            sb.append("\"");
            sb.append((Object)this.operation);
            sb.append("\"");
        }
        if (this.processedItemsCount != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"processedItemsCount\": ");
            sb.append((Object)this.processedItemsCount);
        }
        if (this.startTime != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"startTime\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.startTime));
            sb.append("\"");
        }
        if (this.totalItemsCount != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"totalItemsCount\": ");
            sb.append((Object)this.totalItemsCount);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(ImportTask._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (ImportTask._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(ImportTask._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(ImportTask._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="Operation")
    public static enum Operation {
        CREATE("CREATE"),
        DELETE("DELETE"),
        UPDATE("UPDATE");

        private final String _value;

        @JsonCreator
        public static Operation create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Operation operation : Operation.values()) {
                if (!Objects.equals(operation.getValue(), value)) continue;
                return operation;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Operation(String value) {
            this._value = value;
        }
    }

    @GraphQLName(value="ImportStrategy")
    public static enum ImportStrategy {
        ON_ERROR_CONTINUE("ON_ERROR_CONTINUE"),
        ON_ERROR_FAIL("ON_ERROR_FAIL");

        private final String _value;

        @JsonCreator
        public static ImportStrategy create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (ImportStrategy importStrategy : ImportStrategy.values()) {
                if (!Objects.equals(importStrategy.getValue(), value)) continue;
                return importStrategy;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ImportStrategy(String value) {
            this._value = value;
        }
    }

    @GraphQLName(value="ExecuteStatus")
    public static enum ExecuteStatus {
        COMPLETED("COMPLETED"),
        FAILED("FAILED"),
        INITIAL("INITIAL"),
        STARTED("STARTED");

        private final String _value;

        @JsonCreator
        public static ExecuteStatus create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (ExecuteStatus executeStatus : ExecuteStatus.values()) {
                if (!Objects.equals(executeStatus.getValue(), value)) continue;
                return executeStatus;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ExecuteStatus(String value) {
            this._value = value;
        }
    }
}

