/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.internal.resource.v1_0;

import com.liferay.headless.admin.workflow.dto.v1_0.ChangeTransition;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowInstance;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowInstanceSubmit;
import com.liferay.headless.admin.workflow.internal.dto.v1_0.util.ObjectReviewedUtil;
import com.liferay.headless.admin.workflow.internal.resource.v1_0.BaseWorkflowInstanceResourceImpl;
import com.liferay.headless.admin.workflow.resource.v1_0.WorkflowInstanceResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManager;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/workflow-instance.properties"}, scope=ServiceScope.PROTOTYPE, service={WorkflowInstanceResource.class})
public class WorkflowInstanceResourceImpl
extends BaseWorkflowInstanceResourceImpl {
    @Reference
    private WorkflowInstanceManager _workflowInstanceManager;

    @Override
    public void deleteWorkflowInstance(Long workflowInstanceId) throws Exception {
        this._workflowInstanceManager.deleteWorkflowInstance(this.contextCompany.getCompanyId(), workflowInstanceId.longValue());
    }

    @Override
    public WorkflowInstance getWorkflowInstance(Long workflowInstanceId) throws Exception {
        return this._toWorkflowInstance(this._workflowInstanceManager.getWorkflowInstance(this.contextCompany.getCompanyId(), workflowInstanceId.longValue()));
    }

    @Override
    public Page<WorkflowInstance> getWorkflowInstancesPage(String[] assetClassNames, Long[] assetPrimaryKeys, Boolean completed, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._workflowInstanceManager.getWorkflowInstances(this.contextCompany.getCompanyId(), Long.valueOf(this.contextUser.getUserId()), assetClassNames, completed, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toWorkflowInstance), (Pagination)pagination, (long)this._workflowInstanceManager.getWorkflowInstanceCount(this.contextCompany.getCompanyId(), Long.valueOf(this.contextUser.getUserId()), assetClassNames, completed));
    }

    @Override
    public WorkflowInstance postWorkflowInstanceChangeTransition(Long workflowInstanceId, ChangeTransition changeTransition) throws Exception {
        return this._toWorkflowInstance(this._workflowInstanceManager.signalWorkflowInstance(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), workflowInstanceId.longValue(), changeTransition.getTransitionName(), null));
    }

    @Override
    public WorkflowInstance postWorkflowInstanceSubmit(WorkflowInstanceSubmit workflowInstanceSubmit) throws Exception {
        return this._toWorkflowInstance(this._workflowInstanceManager.startWorkflowInstance(this.contextCompany.getCompanyId(), workflowInstanceSubmit.getSiteId().longValue(), this.contextUser.getUserId(), workflowInstanceSubmit.getWorkflowDefinitionName(), Integer.valueOf(GetterUtil.getInteger((String)workflowInstanceSubmit.getWorkflowDefinitionVersion())), workflowInstanceSubmit.getTransitionName(), this._toWorkflowContext(workflowInstanceSubmit.getContext())));
    }

    private Map<String, Serializable> _toWorkflowContext(Map<String, ?> context) {
        return Stream.of(context.entrySet()).flatMap(Collection::parallelStream).filter(entry -> entry.getValue() instanceof Serializable).collect(Collectors.toMap(Map.Entry::getKey, entry -> (Serializable)entry.getValue()));
    }

    private WorkflowInstance _toWorkflowInstance(final com.liferay.portal.kernel.workflow.WorkflowInstance workflowInstance) throws Exception {
        return new WorkflowInstance(){
            {
                this.completed = workflowInstance.isComplete();
                this.dateCompletion = workflowInstance.getEndDate();
                this.dateCreated = workflowInstance.getStartDate();
                this.id = workflowInstance.getWorkflowInstanceId();
                this.objectReviewed = ObjectReviewedUtil.toObjectReviewed(WorkflowInstanceResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), workflowInstance.getWorkflowContext());
                this.workflowDefinitionName = workflowInstance.getWorkflowDefinitionName();
                this.workflowDefinitionVersion = String.valueOf(workflowInstance.getWorkflowDefinitionVersion());
            }
        };
    }
}

