/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.headless.admin.workflow.client.dto.v1_0;

import com.liferay.headless.admin.workflow.client.function.UnsafeSupplier;
import com.liferay.headless.admin.workflow.client.serdes.v1_0.WorkflowTaskAssignableUserSerDes;

import java.io.Serializable;

import java.util.Objects;

import javax.annotation.Generated;

/**
 * @author Javier Gamarra
 * @generated
 */
@Generated("")
public class WorkflowTaskAssignableUser implements Cloneable, Serializable {

	public static WorkflowTaskAssignableUser toDTO(String json) {
		return WorkflowTaskAssignableUserSerDes.toDTO(json);
	}

	public Assignee[] getAssignableUsers() {
		return assignableUsers;
	}

	public void setAssignableUsers(Assignee[] assignableUsers) {
		this.assignableUsers = assignableUsers;
	}

	public void setAssignableUsers(
		UnsafeSupplier<Assignee[], Exception> assignableUsersUnsafeSupplier) {

		try {
			assignableUsers = assignableUsersUnsafeSupplier.get();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected Assignee[] assignableUsers;

	public Long getWorkflowTaskId() {
		return workflowTaskId;
	}

	public void setWorkflowTaskId(Long workflowTaskId) {
		this.workflowTaskId = workflowTaskId;
	}

	public void setWorkflowTaskId(
		UnsafeSupplier<Long, Exception> workflowTaskIdUnsafeSupplier) {

		try {
			workflowTaskId = workflowTaskIdUnsafeSupplier.get();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected Long workflowTaskId;

	@Override
	public WorkflowTaskAssignableUser clone()
		throws CloneNotSupportedException {

		return (WorkflowTaskAssignableUser)super.clone();
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof WorkflowTaskAssignableUser)) {
			return false;
		}

		WorkflowTaskAssignableUser workflowTaskAssignableUser =
			(WorkflowTaskAssignableUser)object;

		return Objects.equals(
			toString(), workflowTaskAssignableUser.toString());
	}

	@Override
	public int hashCode() {
		String string = toString();

		return string.hashCode();
	}

	public String toString() {
		return WorkflowTaskAssignableUserSerDes.toJSON(this);
	}

}