/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.client.serdes.v1_0;

import com.liferay.headless.admin.workflow.client.dto.v1_0.Role;
import com.liferay.headless.admin.workflow.client.json.BaseJSONParser;
import com.liferay.headless.admin.workflow.client.serdes.v1_0.CreatorSerDes;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class RoleSerDes {
    public static Role toDTO(String json) {
        RoleJSONParser roleJSONParser = new RoleJSONParser();
        return (Role)roleJSONParser.parseToDTO(json);
    }

    public static Role[] toDTOs(String json) {
        RoleJSONParser roleJSONParser = new RoleJSONParser();
        return (Role[])roleJSONParser.parseToDTOs(json);
    }

    public static String toJSON(Role role) {
        if (role == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (role.getAvailableLanguages() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"availableLanguages\": ");
            sb.append("[");
            for (int i = 0; i < role.getAvailableLanguages().length; ++i) {
                sb.append("\"");
                sb.append(RoleSerDes._escape(role.getAvailableLanguages()[i]));
                sb.append("\"");
                if (i + 1 >= role.getAvailableLanguages().length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (role.getCreator() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(role.getCreator()));
        }
        if (role.getDateCreated() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(role.getDateCreated()));
            sb.append("\"");
        }
        if (role.getDateModified() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(role.getDateModified()));
            sb.append("\"");
        }
        if (role.getDescription() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(RoleSerDes._escape(role.getDescription()));
            sb.append("\"");
        }
        if (role.getDescription_i18n() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description_i18n\": ");
            sb.append(RoleSerDes._toJSON(role.getDescription_i18n()));
        }
        if (role.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(role.getId());
        }
        if (role.getName() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(RoleSerDes._escape(role.getName()));
            sb.append("\"");
        }
        if (role.getName_i18n() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name_i18n\": ");
            sb.append(RoleSerDes._toJSON(role.getName_i18n()));
        }
        if (role.getRoleType() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"roleType\": ");
            sb.append("\"");
            sb.append(RoleSerDes._escape(role.getRoleType()));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        RoleJSONParser roleJSONParser = new RoleJSONParser();
        return roleJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(Role role) {
        if (role == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (role.getAvailableLanguages() == null) {
            map.put("availableLanguages", null);
        } else {
            map.put("availableLanguages", String.valueOf(role.getAvailableLanguages()));
        }
        if (role.getCreator() == null) {
            map.put("creator", null);
        } else {
            map.put("creator", String.valueOf(role.getCreator()));
        }
        if (role.getDateCreated() == null) {
            map.put("dateCreated", null);
        } else {
            map.put("dateCreated", liferayToJSONDateFormat.format(role.getDateCreated()));
        }
        if (role.getDateModified() == null) {
            map.put("dateModified", null);
        } else {
            map.put("dateModified", liferayToJSONDateFormat.format(role.getDateModified()));
        }
        if (role.getDescription() == null) {
            map.put("description", null);
        } else {
            map.put("description", String.valueOf(role.getDescription()));
        }
        if (role.getDescription_i18n() == null) {
            map.put("description_i18n", null);
        } else {
            map.put("description_i18n", String.valueOf(role.getDescription_i18n()));
        }
        if (role.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(role.getId()));
        }
        if (role.getName() == null) {
            map.put("name", null);
        } else {
            map.put("name", String.valueOf(role.getName()));
        }
        if (role.getName_i18n() == null) {
            map.put("name_i18n", null);
        } else {
            map.put("name_i18n", String.valueOf(role.getName_i18n()));
        }
        if (role.getRoleType() == null) {
            map.put("roleType", null);
        } else {
            map.put("roleType", String.valueOf(role.getRoleType()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":");
            Object value = entry.getValue();
            Class<?> valueClass = value.getClass();
            if (value instanceof Map) {
                sb.append(RoleSerDes._toJSON((Map)value));
            } else if (valueClass.isArray()) {
                Object[] values = (Object[])value;
                sb.append("[");
                for (int i = 0; i < values.length; ++i) {
                    sb.append("\"");
                    sb.append(RoleSerDes._escape(values[i]));
                    sb.append("\"");
                    if (i + 1 >= values.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(RoleSerDes._escape(entry.getValue()));
                sb.append("\"");
            } else {
                sb.append(String.valueOf(entry.getValue()));
            }
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class RoleJSONParser
    extends BaseJSONParser<Role> {
        @Override
        protected Role createDTO() {
            return new Role();
        }

        protected Role[] createDTOArray(int size) {
            return new Role[size];
        }

        @Override
        protected void setField(Role role, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "availableLanguages")) {
                if (jsonParserFieldValue != null) {
                    role.setAvailableLanguages(this.toStrings((Object[])jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "creator")) {
                if (jsonParserFieldValue != null) {
                    role.setCreator(CreatorSerDes.toDTO((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateCreated")) {
                if (jsonParserFieldValue != null) {
                    role.setDateCreated(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateModified")) {
                if (jsonParserFieldValue != null) {
                    role.setDateModified(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "description")) {
                if (jsonParserFieldValue != null) {
                    role.setDescription((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "description_i18n")) {
                if (jsonParserFieldValue != null) {
                    role.setDescription_i18n(RoleSerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    role.setId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "name")) {
                if (jsonParserFieldValue != null) {
                    role.setName((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "name_i18n")) {
                if (jsonParserFieldValue != null) {
                    role.setName_i18n(RoleSerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "roleType")) {
                if (jsonParserFieldValue != null) {
                    role.setRoleType((String)jsonParserFieldValue);
                }
            } else if (jsonParserFieldName.equals("status")) {
                throw new IllegalArgumentException();
            }
        }
    }
}

