/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.client.resource.v1_0;

import com.liferay.headless.admin.workflow.client.dto.v1_0.WorkflowDefinition;
import com.liferay.headless.admin.workflow.client.http.HttpInvoker;
import com.liferay.headless.admin.workflow.client.pagination.Page;
import com.liferay.headless.admin.workflow.client.pagination.Pagination;
import com.liferay.headless.admin.workflow.client.problem.Problem;
import com.liferay.headless.admin.workflow.client.serdes.v1_0.WorkflowDefinitionSerDes;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface WorkflowDefinitionResource {
    public static Builder builder() {
        return new Builder();
    }

    public Page<WorkflowDefinition> getWorkflowDefinitionsPage(Pagination var1) throws Exception;

    public HttpInvoker.HttpResponse getWorkflowDefinitionsPageHttpResponse(Pagination var1) throws Exception;

    public WorkflowDefinition getWorkflowDefinitionByName(String var1) throws Exception;

    public HttpInvoker.HttpResponse getWorkflowDefinitionByNameHttpResponse(String var1) throws Exception;

    public WorkflowDefinition postWorkflowDefinitionDeploy(WorkflowDefinition var1) throws Exception;

    public HttpInvoker.HttpResponse postWorkflowDefinitionDeployHttpResponse(WorkflowDefinition var1) throws Exception;

    public WorkflowDefinition postWorkflowDefinitionSave(WorkflowDefinition var1) throws Exception;

    public HttpInvoker.HttpResponse postWorkflowDefinitionSaveHttpResponse(WorkflowDefinition var1) throws Exception;

    public void deleteWorkflowDefinitionUndeploy(String var1, String var2) throws Exception;

    public HttpInvoker.HttpResponse deleteWorkflowDefinitionUndeployHttpResponse(String var1, String var2) throws Exception;

    public WorkflowDefinition postWorkflowDefinitionUpdateActive(Boolean var1, String var2, String var3) throws Exception;

    public HttpInvoker.HttpResponse postWorkflowDefinitionUpdateActiveHttpResponse(Boolean var1, String var2, String var3) throws Exception;

    public static class WorkflowDefinitionResourceImpl
    implements WorkflowDefinitionResource {
        private static final Logger _logger = Logger.getLogger(WorkflowDefinitionResource.class.getName());
        private Builder _builder;

        @Override
        public Page<WorkflowDefinition> getWorkflowDefinitionsPage(Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getWorkflowDefinitionsPageHttpResponse(pagination);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, WorkflowDefinitionSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getWorkflowDefinitionsPageHttpResponse(Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-admin-workflow/v1.0/workflow-definitions", new Object[0]);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public WorkflowDefinition getWorkflowDefinitionByName(String name) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getWorkflowDefinitionByNameHttpResponse(name);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return WorkflowDefinitionSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getWorkflowDefinitionByNameHttpResponse(String name) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-admin-workflow/v1.0/workflow-definitions/by-name/{name}", name);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public WorkflowDefinition postWorkflowDefinitionDeploy(WorkflowDefinition workflowDefinition) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postWorkflowDefinitionDeployHttpResponse(workflowDefinition);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return WorkflowDefinitionSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postWorkflowDefinitionDeployHttpResponse(WorkflowDefinition workflowDefinition) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(workflowDefinition.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-admin-workflow/v1.0/workflow-definitions/deploy", new Object[0]);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public WorkflowDefinition postWorkflowDefinitionSave(WorkflowDefinition workflowDefinition) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postWorkflowDefinitionSaveHttpResponse(workflowDefinition);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return WorkflowDefinitionSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postWorkflowDefinitionSaveHttpResponse(WorkflowDefinition workflowDefinition) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(workflowDefinition.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-admin-workflow/v1.0/workflow-definitions/save", new Object[0]);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteWorkflowDefinitionUndeploy(String name, String version) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteWorkflowDefinitionUndeployHttpResponse(name, version);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteWorkflowDefinitionUndeployHttpResponse(String name, String version) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            if (name != null) {
                httpInvoker.parameter("name", String.valueOf(name));
            }
            if (version != null) {
                httpInvoker.parameter("version", String.valueOf(version));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-admin-workflow/v1.0/workflow-definitions/undeploy", new Object[0]);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public WorkflowDefinition postWorkflowDefinitionUpdateActive(Boolean active, String name, String version) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postWorkflowDefinitionUpdateActiveHttpResponse(active, name, version);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return WorkflowDefinitionSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postWorkflowDefinitionUpdateActiveHttpResponse(Boolean active, String name, String version) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(version.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (active != null) {
                httpInvoker.parameter("active", String.valueOf(active));
            }
            if (name != null) {
                httpInvoker.parameter("name", String.valueOf(name));
            }
            if (version != null) {
                httpInvoker.parameter("version", String.valueOf(version));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-admin-workflow/v1.0/workflow-definitions/update-active", new Object[0]);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private WorkflowDefinitionResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public WorkflowDefinitionResource build() {
            return new WorkflowDefinitionResourceImpl(this);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        private Builder() {
        }
    }
}

