/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.admin.workflow.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents the log containing the workflow's activity history (e.g., transitions, assignees, etc.).", value="WorkflowLog")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="WorkflowLog")
public class WorkflowLog
implements Serializable {
    @GraphQLField(description="The user account of the person auditing the workflow.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The user account of the person auditing the workflow.") Creator auditPerson;
    @GraphQLField(description="The log's comments.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The log's comments.") String commentLog;
    @GraphQLField(description="The log's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The log's creation date.") Date dateCreated;
    @GraphQLField(description="The log's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The log's ID.") Long id;
    @GraphQLField(description="The person assigned to the workflow.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The person assigned to the workflow.") Creator person;
    @GraphQLField(description="The previous person assigned to the workflow.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The previous person assigned to the workflow.") Creator previousPerson;
    @GraphQLField(description="The workflow's previous state.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The workflow's previous state.") String previousState;
    @GraphQLField(description="The workflow's current state.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The workflow's current state.") String state;
    @GraphQLField(description="The task asociated with this workflow log.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The task asociated with this workflow log.") Long taskId;
    @GraphQLField(description="The workflow log's type.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The workflow log's type.") String type;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.admin.workflow.dto.v1_0.WorkflowLog", name="x-class-name")
    public String xClassName;

    public static WorkflowLog toDTO(String json) {
        return (WorkflowLog)ObjectMapperUtil.readValue(WorkflowLog.class, (String)json);
    }

    public static WorkflowLog unsafeToDTO(String json) {
        return (WorkflowLog)ObjectMapperUtil.unsafeReadValue(WorkflowLog.class, (String)json);
    }

    @Schema(description="The user account of the person auditing the workflow.")
    @Valid
    public Creator getAuditPerson() {
        return this.auditPerson;
    }

    public void setAuditPerson(Creator auditPerson) {
        this.auditPerson = auditPerson;
    }

    @JsonIgnore
    public void setAuditPerson(UnsafeSupplier<Creator, Exception> auditPersonUnsafeSupplier) {
        try {
            this.auditPerson = (Creator)auditPersonUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The log's comments.")
    public String getCommentLog() {
        return this.commentLog;
    }

    public void setCommentLog(String commentLog) {
        this.commentLog = commentLog;
    }

    @JsonIgnore
    public void setCommentLog(UnsafeSupplier<String, Exception> commentLogUnsafeSupplier) {
        try {
            this.commentLog = (String)commentLogUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The log's creation date.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The log's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The person assigned to the workflow.")
    @Valid
    public Creator getPerson() {
        return this.person;
    }

    public void setPerson(Creator person) {
        this.person = person;
    }

    @JsonIgnore
    public void setPerson(UnsafeSupplier<Creator, Exception> personUnsafeSupplier) {
        try {
            this.person = (Creator)personUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The previous person assigned to the workflow.")
    @Valid
    public Creator getPreviousPerson() {
        return this.previousPerson;
    }

    public void setPreviousPerson(Creator previousPerson) {
        this.previousPerson = previousPerson;
    }

    @JsonIgnore
    public void setPreviousPerson(UnsafeSupplier<Creator, Exception> previousPersonUnsafeSupplier) {
        try {
            this.previousPerson = (Creator)previousPersonUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The workflow's previous state.")
    public String getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(String previousState) {
        this.previousState = previousState;
    }

    @JsonIgnore
    public void setPreviousState(UnsafeSupplier<String, Exception> previousStateUnsafeSupplier) {
        try {
            this.previousState = (String)previousStateUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The workflow's current state.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @JsonIgnore
    public void setState(UnsafeSupplier<String, Exception> stateUnsafeSupplier) {
        try {
            this.state = (String)stateUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The task asociated with this workflow log.")
    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    @JsonIgnore
    public void setTaskId(UnsafeSupplier<Long, Exception> taskIdUnsafeSupplier) {
        try {
            this.taskId = (Long)taskIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The workflow log's type.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<String, Exception> typeUnsafeSupplier) {
        try {
            this.type = (String)typeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WorkflowLog)) {
            return false;
        }
        WorkflowLog workflowLog = (WorkflowLog)object;
        return Objects.equals(this.toString(), workflowLog.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.auditPerson != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"auditPerson\": ");
            sb.append(String.valueOf(this.auditPerson));
        }
        if (this.commentLog != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"commentLog\": ");
            sb.append("\"");
            sb.append(WorkflowLog._escape(this.commentLog));
            sb.append("\"");
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.person != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"person\": ");
            sb.append(String.valueOf(this.person));
        }
        if (this.previousPerson != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"previousPerson\": ");
            sb.append(String.valueOf(this.previousPerson));
        }
        if (this.previousState != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"previousState\": ");
            sb.append("\"");
            sb.append(WorkflowLog._escape(this.previousState));
            sb.append("\"");
        }
        if (this.state != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"state\": ");
            sb.append("\"");
            sb.append(WorkflowLog._escape(this.state));
            sb.append("\"");
        }
        if (this.taskId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taskId\": ");
            sb.append((Object)this.taskId);
        }
        if (this.type != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append(WorkflowLog._escape(this.type));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            if (WorkflowLog._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(WorkflowLog._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(value);
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

