/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.internal.dto.v1_0.converter.UserGroupResourceDTOConverter;
import com.liferay.headless.admin.user.internal.odata.entity.v1_0.UserGroupEntityModel;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseUserGroupResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.UserGroupResource;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.UserGroupService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/user-group.properties"}, scope=ServiceScope.PROTOTYPE, service={UserGroupResource.class})
public class UserGroupResourceImpl
extends BaseUserGroupResourceImpl {
    private final EntityModel _entityModel = new UserGroupEntityModel();
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.UserGroup)")
    private ModelResourcePermission<UserGroup> _userGroupModelResourcePermission;
    @Reference
    private UserGroupResourceDTOConverter _userGroupResourceDTOConverter;
    @Reference
    private UserGroupService _userGroupService;
    @Reference
    private UserService _userService;

    @Override
    public void deleteUserGroup(Long userGroupId) throws PortalException {
        this._userGroupService.deleteUserGroup(userGroupId.longValue());
    }

    @Override
    public void deleteUserGroupByExternalReferenceCode(String externalReferenceCode) throws Exception {
        this.deleteUserGroup(this._userGroupResourceDTOConverter.getUserGroupId(externalReferenceCode));
    }

    @Override
    public void deleteUserGroupUsers(Long userGroupId, Long[] userIds) throws Exception {
        this._userService.unsetUserGroupUsers(userGroupId.longValue(), ArrayUtil.toArray((Long[])userIds));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return this._entityModel;
    }

    @Override
    public com.liferay.headless.admin.user.dto.v1_0.UserGroup getUserGroup(Long userGroupId) throws Exception {
        return this._toUserGroup(this._userGroupService.getUserGroup(userGroupId.longValue()));
    }

    @Override
    public com.liferay.headless.admin.user.dto.v1_0.UserGroup getUserGroupByExternalReferenceCode(String externalReferenceCode) throws Exception {
        return this._toUserGroup(this._userGroupResourceDTOConverter.getObject(externalReferenceCode));
    }

    @Override
    public Page<com.liferay.headless.admin.user.dto.v1_0.UserGroup> getUserGroupsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_USER_GROUP", "postUserGroup", "90", 0L)).put((Object)"get", this.addAction("VIEW", 0L, "getUserGroupsPage", this._userGroupModelResourcePermission)).build(), booleanQuery -> {}, (Filter)filter, (String)UserGroup.class.getName(), (String)search, (Pagination)pagination, queryConfig -> {}, searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            if (Validator.isNotNull((String)search)) {
                searchContext.setKeywords(search);
            }
        }, (Sort[])sorts, document -> this._toUserGroup(this._userGroupService.getUserGroup(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public Page<com.liferay.headless.admin.user.dto.v1_0.UserGroup> getUserUserGroups(Long userAccountId) throws Exception {
        return Page.of(this.transform(this._userGroupService.getUserUserGroups(userAccountId.longValue()), this::_toUserGroup));
    }

    @Override
    public com.liferay.headless.admin.user.dto.v1_0.UserGroup postUserGroup(com.liferay.headless.admin.user.dto.v1_0.UserGroup userGroup) throws Exception {
        return this._toUserGroup(this._userGroupService.updateExternalReferenceCode(this._userGroupService.addUserGroup(userGroup.getName(), userGroup.getDescription(), null), userGroup.getExternalReferenceCode()));
    }

    @Override
    public void postUserGroupUsers(Long userGroupId, Long[] userIds) throws Exception {
        this._userService.addUserGroupUsers(userGroupId.longValue(), ArrayUtil.toArray((Long[])userIds));
    }

    @Override
    public com.liferay.headless.admin.user.dto.v1_0.UserGroup putUserGroup(Long userGroupId, com.liferay.headless.admin.user.dto.v1_0.UserGroup userGroup) throws Exception {
        return this._toUserGroup(this._userGroupService.updateExternalReferenceCode(this._userGroupService.updateUserGroup(userGroupId.longValue(), userGroup.getName(), userGroup.getDescription(), null), userGroup.getExternalReferenceCode()));
    }

    @Override
    public com.liferay.headless.admin.user.dto.v1_0.UserGroup putUserGroupByExternalReferenceCode(String externalReferenceCode, com.liferay.headless.admin.user.dto.v1_0.UserGroup userGroup) throws Exception {
        return this._toUserGroup(this._userGroupService.addOrUpdateUserGroup(externalReferenceCode, userGroup.getName(), userGroup.getDescription(), null));
    }

    private DTOConverterContext _getDTOConverterContext(long userGroupId) {
        return new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", userGroupId, "deleteUserGroup", this._userGroupModelResourcePermission)).put((Object)"delete-by-external-reference-code", this.addAction("DELETE", userGroupId, "deleteUserGroupByExternalReferenceCode", this._userGroupModelResourcePermission)).put((Object)"delete-user-group-users", this.addAction("ASSIGN_MEMBERS", userGroupId, "deleteUserGroupUsers", this._userGroupModelResourcePermission)).put((Object)"get", this.addAction("VIEW", userGroupId, "getUserGroup", this._userGroupModelResourcePermission)).put((Object)"get-by-external-reference-code", this.addAction("VIEW", userGroupId, "getUserGroupByExternalReferenceCode", this._userGroupModelResourcePermission)).put((Object)"patch", this.addAction("UPDATE", userGroupId, "patchUserGroup", this._userGroupModelResourcePermission)).put((Object)"patch-by-external-reference-code", this.addAction("UPDATE", userGroupId, "patchUserGroupByExternalReferenceCode", this._userGroupModelResourcePermission)).put((Object)"post-user-group-users", this.addAction("ASSIGN_MEMBERS", userGroupId, "postUserGroupUsers", this._userGroupModelResourcePermission)).put((Object)"put", this.addAction("UPDATE", userGroupId, "putUserGroup", this._userGroupModelResourcePermission)).put((Object)"put-by-external-reference-code", this.addAction("UPDATE", userGroupId, "putUserGroupByExternalReferenceCode", this._userGroupModelResourcePermission)).build(), null, this.contextHttpServletRequest, (Object)userGroupId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser);
    }

    private com.liferay.headless.admin.user.dto.v1_0.UserGroup _toUserGroup(UserGroup userGroup) throws Exception {
        return this._userGroupResourceDTOConverter.toDTO(this._getDTOConverterContext(userGroup.getUserGroupId()), userGroup);
    }
}

