/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.account.service.AccountEntryUserRelService;
import com.liferay.announcements.kernel.service.AnnouncementsDeliveryLocalService;
import com.liferay.captcha.util.CaptchaUtil;
import com.liferay.headless.admin.user.dto.v1_0.Account;
import com.liferay.headless.admin.user.dto.v1_0.AccountBrief;
import com.liferay.headless.admin.user.dto.v1_0.Organization;
import com.liferay.headless.admin.user.dto.v1_0.OrganizationBrief;
import com.liferay.headless.admin.user.dto.v1_0.UserAccount;
import com.liferay.headless.admin.user.dto.v1_0.UserAccountContactInformation;
import com.liferay.headless.admin.user.internal.dto.v1_0.converter.AccountResourceDTOConverter;
import com.liferay.headless.admin.user.internal.dto.v1_0.converter.OrganizationResourceDTOConverter;
import com.liferay.headless.admin.user.internal.dto.v1_0.converter.UserResourceDTOConverter;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderEmailAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderListTypeUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderPhoneUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderWebsiteUtil;
import com.liferay.headless.admin.user.internal.odata.entity.v1_0.UserAccountEntityModel;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseUserAccountResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.AccountRoleResource;
import com.liferay.headless.admin.user.resource.v1_0.UserAccountResource;
import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.captcha.CaptchaSettings;
import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.exception.UserLockoutException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManager;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManagerUtil;
import com.liferay.portal.kernel.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ContactLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.users.admin.kernel.util.UsersAdmin;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/user-account.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, UserAccountResource.class})
public class UserAccountResourceImpl
extends BaseUserAccountResourceImpl
implements NestedFieldSupport {
    private static final EntityModel _entityModel = new UserAccountEntityModel();
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    @Reference
    private AccountEntryUserRelService _accountEntryUserRelService;
    @Reference
    private AccountResourceDTOConverter _accountResourceDTOConverter;
    @Reference
    private AccountRoleResource _accountRoleResource;
    @Reference
    private AnnouncementsDeliveryLocalService _announcementsDeliveryLocalService;
    @Reference
    private AuthenticatedSessionManager _authenticatedSessionManager;
    @Reference
    private CaptchaSettings _captchaSettings;
    @Reference
    private ContactLocalService _contactLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.Organization)")
    private ModelResourcePermission<com.liferay.portal.kernel.model.Organization> _organizationModelResourcePermission;
    @Reference
    private OrganizationResourceDTOConverter _organizationResourceDTOConverter;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private Portal _portal;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.User)")
    private ModelResourcePermission<User> _userModelResourcePermission;
    @Reference
    private UserResourceDTOConverter _userResourceDTOConverter;
    @Reference
    private UsersAdmin _usersAdmin;
    @Reference
    private UserService _userService;

    @Override
    public void deleteAccountByExternalReferenceCodeUserAccountByExternalReferenceCode(String accountExternalReferenceCode, String userAccountExternalReferenceCode) throws Exception {
        User user = this._userLocalService.getUserByExternalReferenceCode(userAccountExternalReferenceCode, this.contextCompany.getCompanyId());
        this._accountEntryUserRelService.deleteAccountEntryUserRelByEmailAddress(this._accountResourceDTOConverter.getAccountEntryId(accountExternalReferenceCode), user.getEmailAddress());
    }

    @Override
    public void deleteAccountUserAccountByEmailAddress(Long accountId, String emailAddress) throws Exception {
        this._accountEntryUserRelService.deleteAccountEntryUserRelByEmailAddress(accountId.longValue(), emailAddress);
    }

    @Override
    public void deleteAccountUserAccountByExternalReferenceCodeByEmailAddress(String externalReferenceCode, String emailAddress) throws Exception {
        this.deleteAccountUserAccountByEmailAddress(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), emailAddress);
    }

    @Override
    public void deleteAccountUserAccountsByEmailAddress(Long accountId, String[] emailAddresses) throws Exception {
        for (String emailAddress : emailAddresses) {
            this.deleteAccountUserAccountByEmailAddress(accountId, emailAddress);
        }
    }

    @Override
    public void deleteAccountUserAccountsByExternalReferenceCodeByEmailAddress(String externalReferenceCode, String[] emailAddresses) throws Exception {
        for (String emailAddress : emailAddresses) {
            this.deleteAccountUserAccountByExternalReferenceCodeByEmailAddress(externalReferenceCode, emailAddress);
        }
    }

    @Override
    public void deleteUserAccount(Long userAccountId) throws Exception {
        this._userService.deleteUser(userAccountId.longValue());
    }

    @Override
    public void deleteUserAccountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        User user = this._userLocalService.getUserByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        this.deleteUserAccount(user.getUserId());
    }

    @Override
    public Page<UserAccount> getAccountUserAccountsByExternalReferenceCodePage(String externalReferenceCode, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this.getAccountUserAccountsPage(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), search, filter, pagination, sorts);
    }

    @Override
    @NestedField(parentClass=Account.class, value="accountUserAccounts")
    public Page<UserAccount> getAccountUserAccountsPage(Long accountId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(this._getModelActions(Collections.singletonMap("MANAGE_USERS", new String[]{"deleteAccountUserAccountByEmailAddress", "deleteAccountUserAccountByExternalReferenceCodeByEmailAddress", "deleteAccountUserAccountsByEmailAddress", "deleteAccountUserAccountsByExternalReferenceCodeByEmailAddress", "getAccountUserAccountsByExternalReferenceCodePage", "getAccountUserAccountsPage", "postAccountUserAccount", "postAccountUserAccountByEmailAddress", "postAccountUserAccountByExternalReferenceCode", "postAccountUserAccountByExternalReferenceCodeByEmailAddress", "postAccountUserAccountsByEmailAddress", "postAccountUserAccountsByExternalReferenceCodeByEmailAddress"}), accountId, this._accountEntryModelResourcePermission), booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("accountEntryIds", String.valueOf(accountId)), BooleanClauseOccur.MUST);
        }, (Filter)filter, (String)User.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toUserAccount(Collections.emptyMap(), GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public UserAccount getMyUserAccount() throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        return this._toUserAccount(this._userService.getUserById(permissionChecker.getUserId()));
    }

    @Override
    @NestedField(parentClass=Organization.class, value="userAccounts")
    public Page<UserAccount> getOrganizationUserAccountsPage(String organizationId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        com.liferay.portal.kernel.model.Organization organization = this._organizationResourceDTOConverter.getObject(organizationId);
        return this._getUserAccountsPage(this._getModelActions(Collections.singletonMap("MANAGE_USERS", new String[]{"getOrganizationUserAccountsPage"}), organization.getOrganizationId(), this._organizationModelResourcePermission), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("organizationIds", String.valueOf(organization.getOrganizationId())), BooleanClauseOccur.MUST);
        }), filter, search, pagination, sorts);
    }

    @Override
    public Page<UserAccount> getSiteUserAccountsPage(Long siteId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getUserAccountsPage(Collections.singletonMap(this._formatActionMapKey("getSiteUserAccountsPage"), this.addAction(this._formatActionMapKey("getSiteUserAccountsPage"), "getSiteUserAccountsPage", User.class.getName(), siteId)), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("groupId", String.valueOf(siteId)), BooleanClauseOccur.MUST);
        }), filter, search, pagination, sorts);
    }

    @Override
    public UserAccount getUserAccount(Long userAccountId) throws Exception {
        return this._toUserAccount(this._userService.getUserById(userAccountId.longValue()));
    }

    @Override
    public UserAccount getUserAccountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        return this._toUserAccount(this._userService.getUserByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode));
    }

    @Override
    public Page<UserAccount> getUserAccountsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(this.contextCompany.getCompanyId())) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker);
        }
        return this._getUserAccountsPage(HashMapBuilder.putAll(this._getCompanyScopeActions("VIEW", new String[]{"getUserAccountsPage"}, User.class.getName())).putAll(this._getCompanyScopeActions("ADD_USER", new String[]{"postUserAccount", "putUserAccountByExternalReferenceCode"}, "90")).build(), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("userName", ""), BooleanClauseOccur.MUST_NOT);
        }), filter, search, pagination, sorts);
    }

    @Override
    public void postAccountByExternalReferenceCodeUserAccountByExternalReferenceCode(String accountExternalReferenceCode, String userAccountExternalReferenceCode) throws Exception {
        User user = this._userLocalService.getUserByExternalReferenceCode(userAccountExternalReferenceCode, this.contextCompany.getCompanyId());
        this._accountEntryUserRelService.addAccountEntryUserRelByEmailAddress(this._accountResourceDTOConverter.getAccountEntryId(accountExternalReferenceCode), user.getEmailAddress(), new long[0], null, new ServiceContext(){
            {
                this.setCompanyId(UserAccountResourceImpl.this.contextCompany.getCompanyId());
                this.setLanguageId(UserAccountResourceImpl.this.contextAcceptLanguage.getPreferredLanguageId());
                this.setUserId(UserAccountResourceImpl.this.contextUser.getUserId());
            }
        });
    }

    @Override
    public UserAccount postAccountUserAccount(Long accountId, UserAccount userAccount) throws Exception {
        AccountEntryUserRel accountEntryUserRel = this._accountEntryUserRelService.addAccountEntryUserRel(accountId.longValue(), this.contextUser.getUserId(), userAccount.getAlternateName(), userAccount.getEmailAddress(), this.contextAcceptLanguage.getPreferredLocale(), userAccount.getGivenName(), userAccount.getAdditionalName(), userAccount.getFamilyName(), this._getPrefixId(userAccount), this._getSuffixId(userAccount), userAccount.getJobTitle(), ServiceContextFactory.getInstance((HttpServletRequest)this.contextHttpServletRequest));
        User user = accountEntryUserRel.getUser();
        this._usersAdmin.updateAddresses(Contact.class.getName(), user.getContactId(), this._getAddresses(userAccount));
        this._usersAdmin.updateEmailAddresses(Contact.class.getName(), user.getContactId(), this._getServiceBuilderEmailAddresses(userAccount));
        this._usersAdmin.updatePhones(Contact.class.getName(), user.getContactId(), this._getServiceBuilderPhones(userAccount));
        this._usersAdmin.updateWebsites(Contact.class.getName(), user.getContactId(), this._getWebsites(userAccount));
        Contact contact = user.getContact();
        String sms = null;
        String facebook = null;
        String jabber = null;
        String skype = null;
        String twitter = null;
        UserAccountContactInformation userAccountContactInformation = userAccount.getUserAccountContactInformation();
        if (userAccountContactInformation != null) {
            sms = userAccountContactInformation.getSms();
            facebook = userAccountContactInformation.getFacebook();
            jabber = userAccountContactInformation.getJabber();
            skype = userAccountContactInformation.getSkype();
            twitter = userAccountContactInformation.getTwitter();
        }
        return this._toUserAccount(this._userLocalService.updateUser(user.getUserId(), null, null, null, false, user.getReminderQueryQuestion(), user.getReminderQueryAnswer(), user.getScreenName(), user.getEmailAddress(), false, null, user.getLanguageId(), user.getTimeZoneId(), user.getGreeting(), user.getComments(), user.getFirstName(), user.getMiddleName(), user.getLastName(), contact.getPrefixListTypeId(), contact.getSuffixListTypeId(), user.isMale(), this._getBirthdayMonth(userAccount), this._getBirthdayDay(userAccount), this._getBirthdayYear(userAccount), sms, facebook, jabber, skype, twitter, user.getJobTitle(), user.getGroupIds(), user.getOrganizationIds(), user.getRoleIds(), null, user.getUserGroupIds(), ServiceContextRequestUtil.createServiceContext(CustomFieldsUtil.toMap(User.class.getName(), this.contextCompany.getCompanyId(), userAccount.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale()), (long)this.contextCompany.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, null)));
    }

    @Override
    public UserAccount postAccountUserAccountByEmailAddress(Long accountId, String emailAddress) throws Exception {
        AccountEntryUserRel accountEntryUserRel = this._accountEntryUserRelService.addAccountEntryUserRelByEmailAddress(accountId.longValue(), emailAddress, new long[0], null, new ServiceContext(){
            {
                this.setCompanyId(UserAccountResourceImpl.this.contextCompany.getCompanyId());
                this.setLanguageId(UserAccountResourceImpl.this.contextAcceptLanguage.getPreferredLanguageId());
                this.setUserId(UserAccountResourceImpl.this.contextUser.getUserId());
            }
        });
        return this._toUserAccount(this._userLocalService.getUser(accountEntryUserRel.getAccountUserId()));
    }

    @Override
    public UserAccount postAccountUserAccountByExternalReferenceCode(String externalReferenceCode, UserAccount userAccount) throws Exception {
        return this.postAccountUserAccount(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), userAccount);
    }

    @Override
    public void postAccountUserAccountByExternalReferenceCodeByEmailAddress(String externalReferenceCode, String emailAddress) throws Exception {
        this.postAccountUserAccountByEmailAddress(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), emailAddress);
    }

    @Override
    public Page<UserAccount> postAccountUserAccountsByEmailAddress(Long accountId, String accountRoleIds, String[] emailAddresses) throws Exception {
        List userAccounts = this.transformToList(emailAddresses, emailAddress -> this.postAccountUserAccountByEmailAddress(accountId, (String)emailAddress));
        if (Validator.isNull((String)accountRoleIds)) {
            return Page.of(userAccounts);
        }
        String[] accountRoleIdsArray = StringUtil.split((String)accountRoleIds, (char)',');
        for (UserAccount userAccount2 : userAccounts) {
            for (String accountRoleId : accountRoleIdsArray) {
                this._accountRoleResource.postAccountAccountRoleUserAccountAssociation(accountId, Long.valueOf(GetterUtil.getLong((String)accountRoleId)), userAccount2.getId());
            }
        }
        return Page.of(this.transform(userAccounts, userAccount -> this._toUserAccount(this._userService.getUserByEmailAddress(this.contextCompany.getCompanyId(), userAccount.getEmailAddress()))));
    }

    @Override
    public void postAccountUserAccountsByExternalReferenceCodeByEmailAddress(String externalReferenceCode, String[] emailAddresses) throws Exception {
        for (String emailAddress : emailAddresses) {
            this.postAccountUserAccountByExternalReferenceCodeByEmailAddress(externalReferenceCode, emailAddress);
        }
    }

    @Override
    public UserAccount postUserAccount(UserAccount userAccount) throws Exception {
        boolean autoPassword = false;
        String password = userAccount.getPassword();
        if (Validator.isNull((String)password)) {
            autoPassword = true;
        }
        User user = null;
        if (this.contextUser.isDefaultUser()) {
            if (this._captchaSettings.isCreateAccountCaptchaEnabled()) {
                CaptchaUtil.check((HttpServletRequest)this.contextHttpServletRequest);
            }
            user = this._userService.addUser(this.contextCompany.getCompanyId(), autoPassword, password, password, false, userAccount.getAlternateName(), userAccount.getEmailAddress(), this.contextAcceptLanguage.getPreferredLocale(), userAccount.getGivenName(), userAccount.getAdditionalName(), userAccount.getFamilyName(), this._getPrefixId(userAccount), this._getSuffixId(userAccount), true, this._getBirthdayMonth(userAccount), this._getBirthdayDay(userAccount), this._getBirthdayYear(userAccount), userAccount.getJobTitle(), new long[0], new long[0], new long[0], new long[0], true, ServiceContextRequestUtil.createServiceContext(CustomFieldsUtil.toMap(User.class.getName(), this.contextCompany.getCompanyId(), userAccount.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale()), (long)this.contextCompany.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, null));
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._permissionCheckerFactory.create(user));
            this._usersAdmin.updateAddresses(Contact.class.getName(), user.getContactId(), this._getAddresses(userAccount));
            this._usersAdmin.updateEmailAddresses(Contact.class.getName(), user.getContactId(), this._getServiceBuilderEmailAddresses(userAccount));
            this._usersAdmin.updatePhones(Contact.class.getName(), user.getContactId(), this._getServiceBuilderPhones(userAccount));
            this._usersAdmin.updateWebsites(Contact.class.getName(), user.getContactId(), this._getWebsites(userAccount));
        } else {
            user = this._userService.addUser(this.contextCompany.getCompanyId(), autoPassword, password, password, false, userAccount.getAlternateName(), userAccount.getEmailAddress(), this.contextAcceptLanguage.getPreferredLocale(), userAccount.getGivenName(), userAccount.getAdditionalName(), userAccount.getFamilyName(), this._getPrefixId(userAccount), this._getSuffixId(userAccount), true, this._getBirthdayMonth(userAccount), this._getBirthdayDay(userAccount), this._getBirthdayYear(userAccount), userAccount.getJobTitle(), new long[0], new long[0], new long[0], new long[0], this._getAddresses(userAccount), this._getServiceBuilderEmailAddresses(userAccount), this._getServiceBuilderPhones(userAccount), this._getWebsites(userAccount), Collections.emptyList(), true, ServiceContextRequestUtil.createServiceContext(CustomFieldsUtil.toMap(User.class.getName(), this.contextCompany.getCompanyId(), userAccount.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale()), (long)this.contextCompany.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, null));
        }
        UserAccountContactInformation userAccountContactInformation = userAccount.getUserAccountContactInformation();
        if (userAccountContactInformation != null) {
            Contact contact = user.getContact();
            contact.setSmsSn(userAccountContactInformation.getSms());
            contact.setFacebookSn(userAccountContactInformation.getFacebook());
            contact.setJabberSn(userAccountContactInformation.getJabber());
            contact.setSkypeSn(userAccountContactInformation.getSkype());
            contact.setTwitterSn(userAccountContactInformation.getTwitter());
            this._contactLocalService.updateContact(contact);
            user = this._userService.getUserById(user.getUserId());
        }
        return this._toUserAccount(user);
    }

    @Override
    public UserAccount putUserAccount(Long userAccountId, UserAccount userAccount) throws Exception {
        AccountBrief[] accountBriefs = userAccount.getAccountBriefs();
        if (accountBriefs != null) {
            this._accountEntryUserRelLocalService.deleteAccountEntryUserRelsByAccountUserId(userAccountId.longValue());
            for (AccountBrief accountBrief : accountBriefs) {
                this._accountEntryUserRelLocalService.addAccountEntryUserRel(accountBrief.getId().longValue(), userAccountId.longValue());
            }
        }
        User user = this._userService.getUserById(userAccountId.longValue());
        String sms = null;
        String facebook = null;
        String jabber = null;
        String skype = null;
        String twitter = null;
        UserAccountContactInformation userAccountContactInformation = userAccount.getUserAccountContactInformation();
        if (userAccountContactInformation != null) {
            sms = userAccountContactInformation.getSms();
            facebook = userAccountContactInformation.getFacebook();
            jabber = userAccountContactInformation.getJabber();
            skype = userAccountContactInformation.getSkype();
            twitter = userAccountContactInformation.getTwitter();
        }
        long[] organizationIds = user.getOrganizationIds();
        OrganizationBrief[] organizationBriefs = userAccount.getOrganizationBriefs();
        if (organizationBriefs != null) {
            Stream<OrganizationBrief> stream = Arrays.stream(organizationBriefs);
            LongStream longStream = stream.mapToLong(OrganizationBrief::getId);
            organizationIds = longStream.toArray();
        }
        this._updatePassword(user, userAccount.getCurrentPassword(), userAccount.getPassword());
        return this._toUserAccount(this._userService.updateUser(userAccountId.longValue(), null, null, null, false, null, null, userAccount.getAlternateName(), userAccount.getEmailAddress(), true, null, user.getLanguageId(), user.getTimeZoneId(), user.getGreeting(), user.getComments(), userAccount.getGivenName(), userAccount.getAdditionalName(), userAccount.getFamilyName(), this._getPrefixId(userAccount), this._getSuffixId(userAccount), true, this._getBirthdayMonth(userAccount), this._getBirthdayDay(userAccount), this._getBirthdayYear(userAccount), sms, facebook, jabber, skype, twitter, userAccount.getJobTitle(), user.getGroupIds(), organizationIds, user.getRoleIds(), this._userGroupRoleLocalService.getUserGroupRoles(userAccountId.longValue()), user.getUserGroupIds(), this._getAddresses(userAccount), this._getServiceBuilderEmailAddresses(userAccount), this._getServiceBuilderPhones(userAccount), this._getWebsites(userAccount), this._announcementsDeliveryLocalService.getUserDeliveries(userAccountId.longValue()), ServiceContextRequestUtil.createServiceContext(CustomFieldsUtil.toMap(User.class.getName(), this.contextCompany.getCompanyId(), userAccount.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale()), (long)this.contextCompany.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, null)));
    }

    @Override
    public UserAccount putUserAccountByExternalReferenceCode(String externalReferenceCode, UserAccount userAccount) throws Exception {
        boolean autoPassword = true;
        String password = userAccount.getPassword();
        if (Validator.isNotNull((String)password)) {
            autoPassword = false;
            this._checkCurrentPassword(this._userLocalService.fetchUserByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId()), userAccount.getCurrentPassword());
        }
        User user = this._userService.addOrUpdateUser(externalReferenceCode, this.contextUser.getUserId(), this.contextCompany.getCompanyId(), autoPassword, password, password, false, userAccount.getAlternateName(), userAccount.getEmailAddress(), this.contextAcceptLanguage.getPreferredLocale(), userAccount.getGivenName(), userAccount.getAdditionalName(), userAccount.getFamilyName(), this._getPrefixId(userAccount), this._getSuffixId(userAccount), true, this._getBirthdayMonth(userAccount), this._getBirthdayDay(userAccount), this._getBirthdayYear(userAccount), userAccount.getJobTitle(), this._getAddresses(userAccount), this._getServiceBuilderEmailAddresses(userAccount), this._getServiceBuilderPhones(userAccount), this._getWebsites(userAccount), false, ServiceContextRequestUtil.createServiceContext(CustomFieldsUtil.toMap(User.class.getName(), this.contextCompany.getCompanyId(), userAccount.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale()), (long)this.contextCompany.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, null));
        UserAccountContactInformation userAccountContactInformation = userAccount.getUserAccountContactInformation();
        if (userAccountContactInformation != null) {
            Contact contact = user.getContact();
            contact.setSmsSn(userAccountContactInformation.getSms());
            contact.setFacebookSn(userAccountContactInformation.getFacebook());
            contact.setJabberSn(userAccountContactInformation.getJabber());
            contact.setSkypeSn(userAccountContactInformation.getSkype());
            contact.setTwitterSn(userAccountContactInformation.getTwitter());
            this._contactLocalService.updateContact(contact);
            user = this._userService.getUserById(user.getUserId());
        }
        return this._toUserAccount(user);
    }

    @Override
    protected void preparePatch(UserAccount userAccount, UserAccount existingUserAccount) {
        UserAccountContactInformation userAccountContactInformation;
        OrganizationBrief[] organizationBriefs;
        AccountBrief[] accountBriefs = userAccount.getAccountBriefs();
        if (accountBriefs != null) {
            existingUserAccount.setAccountBriefs(accountBriefs);
        }
        if ((organizationBriefs = userAccount.getOrganizationBriefs()) != null) {
            existingUserAccount.setOrganizationBriefs(organizationBriefs);
        }
        if ((userAccountContactInformation = userAccount.getUserAccountContactInformation()) != null) {
            UserAccountContactInformation existingUserAccountContactInformation = existingUserAccount.getUserAccountContactInformation();
            Optional.ofNullable(userAccountContactInformation.getEmailAddresses()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setEmailAddresses(arg_0));
            Optional.ofNullable(userAccountContactInformation.getFacebook()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setFacebook(arg_0));
            Optional.ofNullable(userAccountContactInformation.getJabber()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setJabber(arg_0));
            Optional.ofNullable(userAccountContactInformation.getPostalAddresses()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setPostalAddresses(arg_0));
            Optional.ofNullable(userAccountContactInformation.getSkype()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setSkype(arg_0));
            Optional.ofNullable(userAccountContactInformation.getSms()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setSms(arg_0));
            Optional.ofNullable(userAccountContactInformation.getTelephones()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setTelephones(arg_0));
            Optional.ofNullable(userAccountContactInformation.getTwitter()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setTwitter(arg_0));
            Optional.ofNullable(userAccountContactInformation.getWebUrls()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setWebUrls(arg_0));
        }
        if (userAccount.getCustomFields() != null) {
            Optional.ofNullable(userAccount.getCustomFields()).ifPresent(arg_0 -> ((UserAccount)existingUserAccount).setCustomFields(arg_0));
        }
    }

    private void _checkCurrentPassword(User user, String currentPassword) throws Exception {
        if (user == null || this.contextUser.getUserId() != user.getUserId()) {
            return;
        }
        if (Validator.isNull((String)currentPassword)) {
            throw new UserPasswordException.MustMatchCurrentPassword(user.getUserId());
        }
        int authResult = this._userLocalService.authenticateByUserId(this.contextCompany.getCompanyId(), user.getUserId(), currentPassword, new HashMap(), new HashMap(), new HashMap());
        if (authResult == -1) {
            if (user.isLockout()) {
                HttpServletRequest originalHttpServletRequest = this._portal.getOriginalServletRequest(this.contextHttpServletRequest);
                HttpServletResponse httpServletResponse = this.contextHttpServletResponse;
                AuthenticatedSessionManagerUtil.logout((HttpServletRequest)originalHttpServletRequest, (HttpServletResponse)httpServletResponse);
                throw new UserLockoutException.PasswordPolicyLockout(user, user.getPasswordPolicy());
            }
            throw new UserPasswordException.MustMatchCurrentPassword(user.getUserId());
        }
    }

    private String _formatActionMapKey(String methodName) {
        return TextFormatter.format((String)methodName, (int)10);
    }

    private List<Address> _getAddresses(UserAccount userAccount) {
        return Optional.ofNullable(userAccount.getUserAccountContactInformation()).map(UserAccountContactInformation::getPostalAddresses).map(postalAddresses -> ListUtil.filter(this.transformToList((T[])postalAddresses, _postalAddress -> ServiceBuilderAddressUtil.toServiceBuilderAddress(this.contextCompany.getCompanyId(), _postalAddress, ListTypeConstants.CONTACT_ADDRESS)), Objects::nonNull)).orElse(Collections.emptyList());
    }

    private int _getBirthdayDay(UserAccount userAccount) {
        return this._getCalendarFieldValue(userAccount, 5, 1);
    }

    private int _getBirthdayMonth(UserAccount userAccount) {
        return this._getCalendarFieldValue(userAccount, 2, 0);
    }

    private int _getBirthdayYear(UserAccount userAccount) {
        return this._getCalendarFieldValue(userAccount, 1, 1977);
    }

    private int _getCalendarFieldValue(UserAccount userAccount, int calendarField, int defaultValue) {
        return Optional.ofNullable(userAccount.getBirthDate()).map(date -> {
            Calendar calendar = CalendarFactoryUtil.getCalendar();
            calendar.setTime((Date)date);
            return calendar.get(calendarField);
        }).orElse(defaultValue);
    }

    private Map<String, Map<String, String>> _getCompanyScopeActions(String actionName, String[] methodNames, String resourceName) {
        HashMap<String, Map<String, String>> actions = new HashMap<String, Map<String, String>>();
        for (String methodName : methodNames) {
            actions.put(this._formatActionMapKey(methodName), this.addAction(actionName, methodName, resourceName, 0L));
        }
        return actions;
    }

    private DTOConverterContext _getDTOConverterContext(long userId) {
        return new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getModelActions(HashMapBuilder.put((Object)"DELETE", (Object)new String[]{"deleteUserAccount", "deleteUserAccountByExternalReferenceCode"}).put((Object)"UPDATE", (Object)new String[]{"putUserAccount", "putUserAccountByExternalReferenceCode", "patchUserAccount"}).put((Object)"VIEW", (Object)new String[]{"getMyUserAccount", "getUserAccount", "getUserAccountByExternalReferenceCode"}).build(), userId, this._userModelResourcePermission), null, this.contextHttpServletRequest, (Object)userId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser);
    }

    private Map<String, Map<String, String>> _getModelActions(Map<String, String[]> actionMethodMap, long id, ModelResourcePermission<?> modelResourcePermission) {
        HashMap<String, Map<String, String>> actions = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, String[]> entry : actionMethodMap.entrySet()) {
            for (String methodName : entry.getValue()) {
                actions.put(this._formatActionMapKey(methodName), this.addAction(entry.getKey(), id, methodName, modelResourcePermission));
            }
        }
        return actions;
    }

    private long _getPrefixId(UserAccount userAccount) {
        return Optional.ofNullable(userAccount.getHonorificPrefix()).map(prefix -> ServiceBuilderListTypeUtil.getServiceBuilderListTypeId(ListTypeConstants.CONTACT_PREFIX, prefix)).orElse(0L);
    }

    private List<EmailAddress> _getServiceBuilderEmailAddresses(UserAccount userAccount) {
        return Optional.ofNullable(userAccount.getUserAccountContactInformation()).map(UserAccountContactInformation::getEmailAddresses).map(emailAddresses -> ListUtil.filter(this.transformToList((T[])emailAddresses, emailAddress -> ServiceBuilderEmailAddressUtil.toServiceBuilderEmailAddress(emailAddress, ListTypeConstants.CONTACT_EMAIL_ADDRESS)), Objects::nonNull)).orElse(Collections.emptyList());
    }

    private List<Phone> _getServiceBuilderPhones(UserAccount userAccount) {
        return Optional.ofNullable(userAccount.getUserAccountContactInformation()).map(UserAccountContactInformation::getTelephones).map(telephones -> ListUtil.filter(this.transformToList((T[])telephones, telephone -> ServiceBuilderPhoneUtil.toServiceBuilderPhone(telephone, ListTypeConstants.CONTACT_PHONE)), Objects::nonNull)).orElse(Collections.emptyList());
    }

    private long _getSuffixId(UserAccount userAccount) {
        return Optional.ofNullable(userAccount.getHonorificSuffix()).map(prefix -> ServiceBuilderListTypeUtil.getServiceBuilderListTypeId(ListTypeConstants.CONTACT_SUFFIX, prefix)).orElse(0L);
    }

    private Page<UserAccount> _getUserAccountsPage(Map<String, Map<String, String>> actions, UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, Filter filter, String search, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQueryUnsafeConsumer, (Filter)filter, (String)User.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toUserAccount(actions, GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    private List<Website> _getWebsites(UserAccount userAccount) {
        return Optional.ofNullable(userAccount.getUserAccountContactInformation()).map(UserAccountContactInformation::getWebUrls).map(webUrls -> ListUtil.filter(this.transformToList((T[])webUrls, webUrl -> ServiceBuilderWebsiteUtil.toServiceBuilderWebsite(ListTypeConstants.CONTACT_WEBSITE, webUrl)), Objects::nonNull)).orElse(Collections.emptyList());
    }

    private boolean _isPasswordResetRequired(User user) throws Exception {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        boolean ldapPasswordPolicyEnabled = LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getCompanyId());
        return user.getLastLoginDate() == null && (passwordPolicy == null && !ldapPasswordPolicyEnabled || passwordPolicy != null && passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired());
    }

    private UserAccount _toUserAccount(Map<String, Map<String, String>> actions, long userId) throws Exception {
        return (UserAccount)this._userResourceDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), actions, this._dtoConverterRegistry, (Object)userId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private UserAccount _toUserAccount(User user) throws Exception {
        return this._userResourceDTOConverter.toDTO(this._getDTOConverterContext(user.getUserId()), user);
    }

    private void _updatePassword(User user, String currentPassword, String password) throws Exception {
        if (user == null || Validator.isNull((String)password)) {
            return;
        }
        this._checkCurrentPassword(user, currentPassword);
        this._userService.updatePassword(user.getUserId(), password, password, this._isPasswordResetRequired(user));
        String cookie = CookiesManagerUtil.getCookieValue((String)"JSESSIONID", (HttpServletRequest)this.contextHttpServletRequest, (boolean)false);
        if (this.contextUser.getUserId() == user.getUserId() && cookie != null) {
            String login = null;
            String authType = this.contextCompany.getAuthType();
            if (authType.equals("emailAddress")) {
                login = user.getEmailAddress();
            } else if (authType.equals("screenName")) {
                login = user.getScreenName();
            } else if (authType.equals("userId")) {
                login = String.valueOf(user.getUserId());
            }
            this._authenticatedSessionManager.login(this.contextHttpServletRequest, this.contextHttpServletResponse, login, password, false, null);
        }
    }
}

