/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.internal.resource.v1_0.BaseSubscriptionResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.SubscriptionResource;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.SubscriptionLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/subscription.properties"}, scope=ServiceScope.PROTOTYPE, service={SubscriptionResource.class})
public class SubscriptionResourceImpl
extends BaseSubscriptionResourceImpl {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    @Override
    public void deleteMyUserAccountSubscription(Long subscriptionId) throws Exception {
        this._subscriptionLocalService.deleteSubscription(subscriptionId.longValue());
    }

    @Override
    public com.liferay.headless.admin.user.dto.v1_0.Subscription getMyUserAccountSubscription(Long subscriptionId) throws Exception {
        return this._toSubscription(this._subscriptionLocalService.getSubscription(subscriptionId.longValue()));
    }

    @Override
    public Page<com.liferay.headless.admin.user.dto.v1_0.Subscription> getMyUserAccountSubscriptionsPage(String contentType, Pagination pagination) {
        long userId = this.contextUser.getUserId();
        if (contentType != null) {
            return Page.of(this.transform(this._subscriptionLocalService.getUserSubscriptions(userId, this._getDTOClassName(contentType)), this::_toSubscription));
        }
        return Page.of(this.transform(this._subscriptionLocalService.getUserSubscriptions(userId, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toSubscription), (Pagination)pagination, (long)this._subscriptionLocalService.getUserSubscriptionsCount(userId));
    }

    private String _getDTOClassName(String contentType) {
        for (String dtoClassName : this._dtoConverterRegistry.getDTOClassNames()) {
            DTOConverter dtoConverter = this._dtoConverterRegistry.getDTOConverter(dtoClassName);
            if (!contentType.equals(dtoConverter.getContentType())) continue;
            return dtoConverter.getDTOClassName();
        }
        return contentType;
    }

    private com.liferay.headless.admin.user.dto.v1_0.Subscription _toSubscription(final Subscription subscription) {
        return new com.liferay.headless.admin.user.dto.v1_0.Subscription(){
            {
                this.contentId = subscription.getClassPK();
                this.dateCreated = subscription.getCreateDate();
                this.dateModified = subscription.getModifiedDate();
                this.frequency = subscription.getFrequency();
                this.id = subscription.getSubscriptionId();
                this.siteId = subscription.getGroupId();
                this.setContentType(() -> {
                    DTOConverter dtoConverter = SubscriptionResourceImpl.this._dtoConverterRegistry.getDTOConverter(subscription.getClassName());
                    if (dtoConverter == null) {
                        return subscription.getClassName();
                    }
                    return dtoConverter.getContentType();
                });
            }
        };
    }
}

