/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.UserGroup;
import com.liferay.headless.admin.user.resource.v1_0.UserGroupResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseUserGroupResourceImpl
implements EntityModelResource,
UserGroupResource,
VulcanBatchEngineTaskItemDelegate<UserGroup> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<UserGroup>, UnsafeConsumer<UserGroup, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseUserGroupResourceImpl.class);

    @Operation(description="Retrieves the user's user groups.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userAccountId")})
    @Tags(value={@Tag(name="UserGroup")})
    @GET
    @Path(value="/user-accounts/{userAccountId}/user-groups")
    @Produces(value={"application/json", "application/xml"})
    public Page<UserGroup> getUserUserGroups(@Parameter(hidden=true) @NotNull @PathParam(value="userAccountId") Long userAccountId) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="UserGroup")})
    @GET
    @Path(value="/user-groups")
    @Produces(value={"application/json", "application/xml"})
    public Page<UserGroup> getUserGroupsPage(@Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Tags(value={@Tag(name="UserGroup")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/user-groups")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public UserGroup postUserGroup(UserGroup userGroup) throws Exception {
        return new UserGroup();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="UserGroup")})
    @Consumes(value={"application/json"})
    @Path(value="/user-groups/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postUserGroupBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(UserGroup.class.getName(), callbackURL, null, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="UserGroup")})
    @DELETE
    @Path(value="/user-groups/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteUserGroupByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="UserGroup")})
    @GET
    @Path(value="/user-groups/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public UserGroup getUserGroupByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new UserGroup();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="UserGroup")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/user-groups/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public UserGroup patchUserGroupByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, UserGroup userGroup) throws Exception {
        UserGroup existingUserGroup = this.getUserGroupByExternalReferenceCode(externalReferenceCode);
        if (userGroup.getActions() != null) {
            existingUserGroup.setActions(userGroup.getActions());
        }
        if (userGroup.getDescription() != null) {
            existingUserGroup.setDescription(userGroup.getDescription());
        }
        if (userGroup.getExternalReferenceCode() != null) {
            existingUserGroup.setExternalReferenceCode(userGroup.getExternalReferenceCode());
        }
        if (userGroup.getName() != null) {
            existingUserGroup.setName(userGroup.getName());
        }
        if (userGroup.getUsersCount() != null) {
            existingUserGroup.setUsersCount(userGroup.getUsersCount());
        }
        this.preparePatch(userGroup, existingUserGroup);
        return this.putUserGroupByExternalReferenceCode(externalReferenceCode, existingUserGroup);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="UserGroup")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/user-groups/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public UserGroup putUserGroupByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, UserGroup userGroup) throws Exception {
        return new UserGroup();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userGroupId")})
    @Tags(value={@Tag(name="UserGroup")})
    @DELETE
    @Path(value="/user-groups/{userGroupId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteUserGroup(@Parameter(hidden=true) @NotNull @PathParam(value="userGroupId") Long userGroupId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="UserGroup")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/user-groups/batch")
    @Produces(value={"application/json"})
    public Response deleteUserGroupBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(UserGroup.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userGroupId")})
    @Tags(value={@Tag(name="UserGroup")})
    @GET
    @Path(value="/user-groups/{userGroupId}")
    @Produces(value={"application/json", "application/xml"})
    public UserGroup getUserGroup(@Parameter(hidden=true) @NotNull @PathParam(value="userGroupId") Long userGroupId) throws Exception {
        return new UserGroup();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userGroupId")})
    @Tags(value={@Tag(name="UserGroup")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/user-groups/{userGroupId}")
    @Produces(value={"application/json", "application/xml"})
    public UserGroup patchUserGroup(@Parameter(hidden=true) @NotNull @PathParam(value="userGroupId") Long userGroupId, UserGroup userGroup) throws Exception {
        UserGroup existingUserGroup = this.getUserGroup(userGroupId);
        if (userGroup.getActions() != null) {
            existingUserGroup.setActions(userGroup.getActions());
        }
        if (userGroup.getDescription() != null) {
            existingUserGroup.setDescription(userGroup.getDescription());
        }
        if (userGroup.getExternalReferenceCode() != null) {
            existingUserGroup.setExternalReferenceCode(userGroup.getExternalReferenceCode());
        }
        if (userGroup.getName() != null) {
            existingUserGroup.setName(userGroup.getName());
        }
        if (userGroup.getUsersCount() != null) {
            existingUserGroup.setUsersCount(userGroup.getUsersCount());
        }
        this.preparePatch(userGroup, existingUserGroup);
        return this.putUserGroup(userGroupId, existingUserGroup);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userGroupId")})
    @Tags(value={@Tag(name="UserGroup")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/user-groups/{userGroupId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public UserGroup putUserGroup(@Parameter(hidden=true) @NotNull @PathParam(value="userGroupId") Long userGroupId, UserGroup userGroup) throws Exception {
        return new UserGroup();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="UserGroup")})
    @Consumes(value={"application/json"})
    @Path(value="/user-groups/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putUserGroupBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(UserGroup.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userGroupId")})
    @Tags(value={@Tag(name="UserGroup")})
    @Consumes(value={"application/json", "application/xml"})
    @DELETE
    @Path(value="/user-groups/{userGroupId}/user-group-users")
    @Produces(value={"application/json", "application/xml"})
    public void deleteUserGroupUsers(@Parameter(hidden=true) @NotNull @PathParam(value="userGroupId") Long userGroupId, Long[] longs) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userGroupId")})
    @Tags(value={@Tag(name="UserGroup")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/user-groups/{userGroupId}/user-group-users")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public void postUserGroupUsers(@Parameter(hidden=true) @NotNull @PathParam(value="userGroupId") Long userGroupId, Long[] longs) throws Exception {
    }

    public void create(Collection<UserGroup> userGroups, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer userGroupUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            userGroupUnsafeConsumer = userGroup -> this.postUserGroup((UserGroup)userGroup);
        }
        if ("UPSERT".equalsIgnoreCase(createStrategy)) {
            userGroupUnsafeConsumer = userGroup -> this.putUserGroupByExternalReferenceCode(userGroup.getExternalReferenceCode(), (UserGroup)userGroup);
        }
        if (userGroupUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for UserGroup");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(userGroups, (Object)userGroupUnsafeConsumer);
        } else {
            for (UserGroup userGroup2 : userGroups) {
                userGroupUnsafeConsumer.accept((Object)userGroup2);
            }
        }
    }

    public void delete(Collection<UserGroup> userGroups, Map<String, Serializable> parameters) throws Exception {
        for (UserGroup userGroup : userGroups) {
            this.deleteUserGroup(userGroup.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"UPSERT", "INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<UserGroup> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getUserGroupsPage(search, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<UserGroup> userGroups, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer userGroupUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            userGroupUnsafeConsumer = userGroup -> this.patchUserGroup(userGroup.getId() != null ? userGroup.getId() : Long.parseLong((String)parameters.get("userGroupId")), (UserGroup)userGroup);
        }
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            userGroupUnsafeConsumer = userGroup -> this.putUserGroup(userGroup.getId() != null ? userGroup.getId() : Long.parseLong((String)parameters.get("userGroupId")), (UserGroup)userGroup);
        }
        if (userGroupUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for UserGroup");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(userGroups, (Object)userGroupUnsafeConsumer);
        } else {
            for (UserGroup userGroup2 : userGroups) {
                userGroupUnsafeConsumer.accept((Object)userGroup2);
            }
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<UserGroup>, UnsafeConsumer<UserGroup, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(UserGroup userGroup, UserGroup existingUserGroup) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

