/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.UserAccount;
import com.liferay.headless.admin.user.resource.v1_0.UserAccountResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseUserAccountResourceImpl
implements EntityModelResource,
UserAccountResource,
VulcanBatchEngineTaskItemDelegate<UserAccount> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<UserAccount>, UnsafeConsumer<UserAccount, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseUserAccountResourceImpl.class);

    @Operation(description="Removes a user by their external reference code from an account by external reference code")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="userAccountExternalReferenceCode")})
    @Tags(value={@Tag(name="UserAccount")})
    @DELETE
    @Path(value="/accounts/by-external-reference-code/{accountExternalReferenceCode}/user-accounts/by-external-reference-code/{userAccountExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAccountByExternalReferenceCodeUserAccountByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="accountExternalReferenceCode") String accountExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="userAccountExternalReferenceCode") String userAccountExternalReferenceCode) throws Exception {
    }

    @Operation(description="Assigns a user by their external reference code to an account by external reference code")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="userAccountExternalReferenceCode")})
    @Tags(value={@Tag(name="UserAccount")})
    @Path(value="/accounts/by-external-reference-code/{accountExternalReferenceCode}/user-accounts/by-external-reference-code/{userAccountExternalReferenceCode}")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public void postAccountByExternalReferenceCodeUserAccountByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="accountExternalReferenceCode") String accountExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="userAccountExternalReferenceCode") String userAccountExternalReferenceCode) throws Exception {
    }

    @Operation(description="Gets the users assigned to an account")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="UserAccount")})
    @GET
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}/user-accounts")
    @Produces(value={"application/json", "application/xml"})
    public Page<UserAccount> getAccountUserAccountsByExternalReferenceCodePage(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a user and assigns them to the account")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="UserAccount")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}/user-accounts")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public UserAccount postAccountUserAccountByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, UserAccount userAccount) throws Exception {
        return new UserAccount();
    }

    @Operation(description="Removes users from an account by their email addresses")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="UserAccount")})
    @Consumes(value={"application/json", "application/xml"})
    @DELETE
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}/user-accounts/by-email-address")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAccountUserAccountsByExternalReferenceCodeByEmailAddress(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, String[] strings) throws Exception {
    }

    @Operation(description="Assigns users to an account by their email addresses")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="UserAccount")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}/user-accounts/by-email-address")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public void postAccountUserAccountsByExternalReferenceCodeByEmailAddress(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, String[] strings) throws Exception {
    }

    @Operation(description="Removes a user from an account by external reference code by their email address")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="emailAddress")})
    @Tags(value={@Tag(name="UserAccount")})
    @DELETE
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}/user-accounts/by-email-address/{emailAddress}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAccountUserAccountByExternalReferenceCodeByEmailAddress(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="emailAddress") String emailAddress) throws Exception {
    }

    @Operation(description="Assigns a user to an account by external reference code by their email address")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="emailAddress")})
    @Tags(value={@Tag(name="UserAccount")})
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}/user-accounts/by-email-address/{emailAddress}")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public void postAccountUserAccountByExternalReferenceCodeByEmailAddress(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="emailAddress") String emailAddress) throws Exception {
    }

    @Operation(description="Gets the users assigned to an account")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="UserAccount")})
    @GET
    @Path(value="/accounts/{accountId}/user-accounts")
    @Produces(value={"application/json", "application/xml"})
    public Page<UserAccount> getAccountUserAccountsPage(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a user and assigns them to the account")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId")})
    @Tags(value={@Tag(name="UserAccount")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/accounts/{accountId}/user-accounts")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public UserAccount postAccountUserAccount(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, UserAccount userAccount) throws Exception {
        return new UserAccount();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="UserAccount")})
    @Consumes(value={"application/json"})
    @Path(value="/accounts/{accountId}/user-accounts/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postAccountUserAccountBatch(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(UserAccount.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Removes users from an account by their email addresses")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId")})
    @Tags(value={@Tag(name="UserAccount")})
    @Consumes(value={"application/json", "application/xml"})
    @DELETE
    @Path(value="/accounts/{accountId}/user-accounts/by-email-address")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAccountUserAccountsByEmailAddress(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, String[] strings) throws Exception {
    }

    @Operation(description="Assigns users to an account by their email addresses")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId"), @Parameter(in=ParameterIn.QUERY, name="accountRoleIds")})
    @Tags(value={@Tag(name="UserAccount")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/accounts/{accountId}/user-accounts/by-email-address")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Page<UserAccount> postAccountUserAccountsByEmailAddress(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, @Parameter(hidden=true) @QueryParam(value="accountRoleIds") String accountRoleIds, String[] strings) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Removes a user from an account by their email address")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId"), @Parameter(in=ParameterIn.PATH, name="emailAddress")})
    @Tags(value={@Tag(name="UserAccount")})
    @DELETE
    @Path(value="/accounts/{accountId}/user-accounts/by-email-address/{emailAddress}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAccountUserAccountByEmailAddress(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, @Parameter(hidden=true) @NotNull @PathParam(value="emailAddress") String emailAddress) throws Exception {
    }

    @Operation(description="Assigns a user to an account by their email address")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId"), @Parameter(in=ParameterIn.PATH, name="emailAddress")})
    @Tags(value={@Tag(name="UserAccount")})
    @Path(value="/accounts/{accountId}/user-accounts/by-email-address/{emailAddress}")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public UserAccount postAccountUserAccountByEmailAddress(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, @Parameter(hidden=true) @NotNull @PathParam(value="emailAddress") String emailAddress) throws Exception {
        return new UserAccount();
    }

    @Operation(description="Retrieves information about the user who made the request.")
    @Tags(value={@Tag(name="UserAccount")})
    @GET
    @Path(value="/my-user-account")
    @Produces(value={"application/json", "application/xml"})
    public UserAccount getMyUserAccount() throws Exception {
        return new UserAccount();
    }

    @Operation(description="Retrieves the organization's members (users). Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="UserAccount")})
    @GET
    @Path(value="/organizations/{organizationId}/user-accounts")
    @Produces(value={"application/json", "application/xml"})
    public Page<UserAccount> getOrganizationUserAccountsPage(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Retrieves the site members' user accounts. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="UserAccount")})
    @GET
    @Path(value="/sites/{siteId}/user-accounts")
    @Produces(value={"application/json", "application/xml"})
    public Page<UserAccount> getSiteUserAccountsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Retrieves the user accounts. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="UserAccount")})
    @GET
    @Path(value="/user-accounts")
    @Produces(value={"application/json", "application/xml"})
    public Page<UserAccount> getUserAccountsPage(@Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a new user account")
    @Tags(value={@Tag(name="UserAccount")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/user-accounts")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public UserAccount postUserAccount(UserAccount userAccount) throws Exception {
        return new UserAccount();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="UserAccount")})
    @Consumes(value={"application/json"})
    @Path(value="/user-accounts/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postUserAccountBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(UserAccount.class.getName(), callbackURL, null, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="UserAccount")})
    @DELETE
    @Path(value="/user-accounts/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteUserAccountByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="UserAccount")})
    @GET
    @Path(value="/user-accounts/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public UserAccount getUserAccountByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new UserAccount();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="UserAccount")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/user-accounts/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public UserAccount putUserAccountByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, UserAccount userAccount) throws Exception {
        return new UserAccount();
    }

    @Operation(description="Deletes the user account")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userAccountId")})
    @Tags(value={@Tag(name="UserAccount")})
    @DELETE
    @Path(value="/user-accounts/{userAccountId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteUserAccount(@Parameter(hidden=true) @NotNull @PathParam(value="userAccountId") Long userAccountId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="UserAccount")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/user-accounts/batch")
    @Produces(value={"application/json"})
    public Response deleteUserAccountBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(UserAccount.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Retrieves the user account.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userAccountId")})
    @Tags(value={@Tag(name="UserAccount")})
    @GET
    @Path(value="/user-accounts/{userAccountId}")
    @Produces(value={"application/json", "application/xml"})
    public UserAccount getUserAccount(@Parameter(hidden=true) @NotNull @PathParam(value="userAccountId") Long userAccountId) throws Exception {
        return new UserAccount();
    }

    @Operation(description="Updates the user account with information sent in the request body. Only the provided fields are updated.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userAccountId")})
    @Tags(value={@Tag(name="UserAccount")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/user-accounts/{userAccountId}")
    @Produces(value={"application/json", "application/xml"})
    public UserAccount patchUserAccount(@Parameter(hidden=true) @NotNull @PathParam(value="userAccountId") Long userAccountId, UserAccount userAccount) throws Exception {
        UserAccount existingUserAccount = this.getUserAccount(userAccountId);
        if (userAccount.getActions() != null) {
            existingUserAccount.setActions(userAccount.getActions());
        }
        if (userAccount.getAdditionalName() != null) {
            existingUserAccount.setAdditionalName(userAccount.getAdditionalName());
        }
        if (userAccount.getAlternateName() != null) {
            existingUserAccount.setAlternateName(userAccount.getAlternateName());
        }
        if (userAccount.getBirthDate() != null) {
            existingUserAccount.setBirthDate(userAccount.getBirthDate());
        }
        if (userAccount.getCurrentPassword() != null) {
            existingUserAccount.setCurrentPassword(userAccount.getCurrentPassword());
        }
        if (userAccount.getDashboardURL() != null) {
            existingUserAccount.setDashboardURL(userAccount.getDashboardURL());
        }
        if (userAccount.getDateCreated() != null) {
            existingUserAccount.setDateCreated(userAccount.getDateCreated());
        }
        if (userAccount.getDateModified() != null) {
            existingUserAccount.setDateModified(userAccount.getDateModified());
        }
        if (userAccount.getEmailAddress() != null) {
            existingUserAccount.setEmailAddress(userAccount.getEmailAddress());
        }
        if (userAccount.getExternalReferenceCode() != null) {
            existingUserAccount.setExternalReferenceCode(userAccount.getExternalReferenceCode());
        }
        if (userAccount.getFamilyName() != null) {
            existingUserAccount.setFamilyName(userAccount.getFamilyName());
        }
        if (userAccount.getGivenName() != null) {
            existingUserAccount.setGivenName(userAccount.getGivenName());
        }
        if (userAccount.getHonorificPrefix() != null) {
            existingUserAccount.setHonorificPrefix(userAccount.getHonorificPrefix());
        }
        if (userAccount.getHonorificSuffix() != null) {
            existingUserAccount.setHonorificSuffix(userAccount.getHonorificSuffix());
        }
        if (userAccount.getImage() != null) {
            existingUserAccount.setImage(userAccount.getImage());
        }
        if (userAccount.getJobTitle() != null) {
            existingUserAccount.setJobTitle(userAccount.getJobTitle());
        }
        if (userAccount.getKeywords() != null) {
            existingUserAccount.setKeywords(userAccount.getKeywords());
        }
        if (userAccount.getLastLoginDate() != null) {
            existingUserAccount.setLastLoginDate(userAccount.getLastLoginDate());
        }
        if (userAccount.getName() != null) {
            existingUserAccount.setName(userAccount.getName());
        }
        if (userAccount.getPassword() != null) {
            existingUserAccount.setPassword(userAccount.getPassword());
        }
        if (userAccount.getProfileURL() != null) {
            existingUserAccount.setProfileURL(userAccount.getProfileURL());
        }
        this.preparePatch(userAccount, existingUserAccount);
        return this.putUserAccount(userAccountId, existingUserAccount);
    }

    @Operation(description="Replaces the user account with information sent in the request body. Any missing fields are deleted unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userAccountId")})
    @Tags(value={@Tag(name="UserAccount")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/user-accounts/{userAccountId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public UserAccount putUserAccount(@Parameter(hidden=true) @NotNull @PathParam(value="userAccountId") Long userAccountId, UserAccount userAccount) throws Exception {
        return new UserAccount();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="UserAccount")})
    @Consumes(value={"application/json"})
    @Path(value="/user-accounts/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putUserAccountBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(UserAccount.class.getName(), callbackURL, object)).build();
    }

    public void create(Collection<UserAccount> userAccounts, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer userAccountUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            userAccountUnsafeConsumer = userAccount -> this.postUserAccount((UserAccount)userAccount);
            if (parameters.containsKey("accountId")) {
                userAccountUnsafeConsumer = userAccount -> this.postAccountUserAccount(Long.parseLong((String)parameters.get("accountId")), (UserAccount)userAccount);
            }
        }
        if ("UPSERT".equalsIgnoreCase(createStrategy)) {
            userAccountUnsafeConsumer = userAccount -> this.putUserAccountByExternalReferenceCode(userAccount.getExternalReferenceCode(), (UserAccount)userAccount);
        }
        if (userAccountUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for UserAccount");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(userAccounts, (Object)userAccountUnsafeConsumer);
        } else {
            for (UserAccount userAccount2 : userAccounts) {
                userAccountUnsafeConsumer.accept((Object)userAccount2);
            }
        }
    }

    public void delete(Collection<UserAccount> userAccounts, Map<String, Serializable> parameters) throws Exception {
        for (UserAccount userAccount : userAccounts) {
            this.deleteUserAccount(userAccount.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"UPSERT", "INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<UserAccount> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("siteId")) {
            return this.getSiteUserAccountsPage((Long)parameters.get("siteId"), search, filter, pagination, sorts);
        }
        if (parameters.containsKey("accountId")) {
            return this.getAccountUserAccountsPage(Long.parseLong((String)((Object)parameters.get("accountId"))), search, filter, pagination, sorts);
        }
        if (parameters.containsKey("organizationId")) {
            return this.getOrganizationUserAccountsPage((String)((Object)parameters.get("organizationId")), search, filter, pagination, sorts);
        }
        return this.getUserAccountsPage(search, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<UserAccount> userAccounts, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer userAccountUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            userAccountUnsafeConsumer = userAccount -> this.patchUserAccount(userAccount.getId() != null ? userAccount.getId() : Long.parseLong((String)parameters.get("userAccountId")), (UserAccount)userAccount);
        }
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            userAccountUnsafeConsumer = userAccount -> this.putUserAccount(userAccount.getId() != null ? userAccount.getId() : Long.parseLong((String)parameters.get("userAccountId")), (UserAccount)userAccount);
        }
        if (userAccountUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for UserAccount");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(userAccounts, (Object)userAccountUnsafeConsumer);
        } else {
            for (UserAccount userAccount2 : userAccounts) {
                userAccountUnsafeConsumer.accept((Object)userAccount2);
            }
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<UserAccount>, UnsafeConsumer<UserAccount, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(UserAccount userAccount, UserAccount existingUserAccount) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

