/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.Account;
import com.liferay.headless.admin.user.resource.v1_0.AccountResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseAccountResourceImpl
implements AccountResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<Account> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<Account>, UnsafeConsumer<Account, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseAccountResourceImpl.class);

    @Operation(description="Retrieves the accounts. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="Account")})
    @GET
    @Path(value="/accounts")
    @Produces(value={"application/json", "application/xml"})
    public Page<Account> getAccountsPage(@Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a new account")
    @Tags(value={@Tag(name="Account")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/accounts")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Account postAccount(Account account) throws Exception {
        return new Account();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Account")})
    @Consumes(value={"application/json"})
    @Path(value="/accounts/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postAccountBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(Account.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Deletes an account.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Account")})
    @DELETE
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAccountByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Account")})
    @GET
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public Account getAccountByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new Account();
    }

    @Operation(description="Updates the account with information sent in the request body. Only the provided fields are updated.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Account")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public Account patchAccountByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, Account account) throws Exception {
        Account existingAccount = this.getAccountByExternalReferenceCode(externalReferenceCode);
        if (account.getActions() != null) {
            existingAccount.setActions(account.getActions());
        }
        if (account.getDescription() != null) {
            existingAccount.setDescription(account.getDescription());
        }
        if (account.getDomains() != null) {
            existingAccount.setDomains(account.getDomains());
        }
        if (account.getExternalReferenceCode() != null) {
            existingAccount.setExternalReferenceCode(account.getExternalReferenceCode());
        }
        if (account.getName() != null) {
            existingAccount.setName(account.getName());
        }
        if (account.getNumberOfUsers() != null) {
            existingAccount.setNumberOfUsers(account.getNumberOfUsers());
        }
        if (account.getOrganizationIds() != null) {
            existingAccount.setOrganizationIds(account.getOrganizationIds());
        }
        if (account.getParentAccountId() != null) {
            existingAccount.setParentAccountId(account.getParentAccountId());
        }
        if (account.getStatus() != null) {
            existingAccount.setStatus(account.getStatus());
        }
        if (account.getType() != null) {
            existingAccount.setType(account.getType());
        }
        this.preparePatch(account, existingAccount);
        return this.putAccountByExternalReferenceCode(externalReferenceCode, existingAccount);
    }

    @Operation(description="Replaces the account with information sent in the request body. Any missing fields are deleted unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Account")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Account putAccountByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, Account account) throws Exception {
        return new Account();
    }

    @Operation(description="Deletes an account.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId")})
    @Tags(value={@Tag(name="Account")})
    @DELETE
    @Path(value="/accounts/{accountId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAccount(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Account")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/accounts/batch")
    @Produces(value={"application/json"})
    public Response deleteAccountBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(Account.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId")})
    @Tags(value={@Tag(name="Account")})
    @GET
    @Path(value="/accounts/{accountId}")
    @Produces(value={"application/json", "application/xml"})
    public Account getAccount(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId) throws Exception {
        return new Account();
    }

    @Operation(description="Updates the account with information sent in the request body. Only the provided fields are updated.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId")})
    @Tags(value={@Tag(name="Account")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/accounts/{accountId}")
    @Produces(value={"application/json", "application/xml"})
    public Account patchAccount(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, Account account) throws Exception {
        Account existingAccount = this.getAccount(accountId);
        if (account.getActions() != null) {
            existingAccount.setActions(account.getActions());
        }
        if (account.getDescription() != null) {
            existingAccount.setDescription(account.getDescription());
        }
        if (account.getDomains() != null) {
            existingAccount.setDomains(account.getDomains());
        }
        if (account.getExternalReferenceCode() != null) {
            existingAccount.setExternalReferenceCode(account.getExternalReferenceCode());
        }
        if (account.getName() != null) {
            existingAccount.setName(account.getName());
        }
        if (account.getNumberOfUsers() != null) {
            existingAccount.setNumberOfUsers(account.getNumberOfUsers());
        }
        if (account.getOrganizationIds() != null) {
            existingAccount.setOrganizationIds(account.getOrganizationIds());
        }
        if (account.getParentAccountId() != null) {
            existingAccount.setParentAccountId(account.getParentAccountId());
        }
        if (account.getStatus() != null) {
            existingAccount.setStatus(account.getStatus());
        }
        if (account.getType() != null) {
            existingAccount.setType(account.getType());
        }
        this.preparePatch(account, existingAccount);
        return this.putAccount(accountId, existingAccount);
    }

    @Operation(description="Replaces the account with information sent in the request body. Any missing fields are deleted unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId")})
    @Tags(value={@Tag(name="Account")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/accounts/{accountId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Account putAccount(@Parameter(hidden=true) @NotNull @PathParam(value="accountId") Long accountId, Account account) throws Exception {
        return new Account();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Account")})
    @Consumes(value={"application/json"})
    @Path(value="/accounts/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putAccountBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(Account.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="sourceOrganizationId"), @Parameter(in=ParameterIn.PATH, name="targetOrganizationId")})
    @Tags(value={@Tag(name="Account")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/organizations/move-accounts/{sourceOrganizationId}/{targetOrganizationId}")
    @Produces(value={"application/json", "application/xml"})
    public void patchOrganizationMoveAccounts(@Parameter(hidden=true) @NotNull @PathParam(value="sourceOrganizationId") Long sourceOrganizationId, @Parameter(hidden=true) @NotNull @PathParam(value="targetOrganizationId") Long targetOrganizationId, Long[] longs) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="sourceOrganizationId"), @Parameter(in=ParameterIn.PATH, name="targetOrganizationId")})
    @Tags(value={@Tag(name="Account")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/organizations/move-accounts/{sourceOrganizationId}/{targetOrganizationId}/by-external-reference-code")
    @Produces(value={"application/json", "application/xml"})
    public void patchOrganizationMoveAccountsByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="sourceOrganizationId") Long sourceOrganizationId, @Parameter(hidden=true) @NotNull @PathParam(value="targetOrganizationId") Long targetOrganizationId, String[] strings) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Tags(value={@Tag(name="Account")})
    @Consumes(value={"application/json", "application/xml"})
    @DELETE
    @Path(value="/organizations/{organizationId}/accounts")
    @Produces(value={"application/json", "application/xml"})
    public void deleteOrganizationAccounts(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") Long organizationId, Long[] longs) throws Exception {
    }

    @Operation(description="Retrieves the organization's members (accounts). Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="Account")})
    @GET
    @Path(value="/organizations/{organizationId}/accounts")
    @Produces(value={"application/json", "application/xml"})
    public Page<Account> getOrganizationAccountsPage(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") String organizationId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Tags(value={@Tag(name="Account")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/organizations/{organizationId}/accounts")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public void postOrganizationAccounts(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") Long organizationId, Long[] longs) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Tags(value={@Tag(name="Account")})
    @Consumes(value={"application/json", "application/xml"})
    @DELETE
    @Path(value="/organizations/{organizationId}/accounts/by-external-reference-code")
    @Produces(value={"application/json", "application/xml"})
    public void deleteOrganizationAccountsByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") Long organizationId, String[] strings) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Tags(value={@Tag(name="Account")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/organizations/{organizationId}/accounts/by-external-reference-code")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public void postOrganizationAccountsByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="organizationId") Long organizationId, String[] strings) throws Exception {
    }

    public void create(Collection<Account> accounts, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer accountUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            accountUnsafeConsumer = account -> this.postAccount((Account)account);
        }
        if ("UPSERT".equalsIgnoreCase(createStrategy)) {
            accountUnsafeConsumer = account -> this.putAccountByExternalReferenceCode(account.getExternalReferenceCode(), (Account)account);
        }
        if (accountUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for Account");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(accounts, (Object)accountUnsafeConsumer);
        } else {
            for (Account account2 : accounts) {
                accountUnsafeConsumer.accept((Object)account2);
            }
        }
    }

    public void delete(Collection<Account> accounts, Map<String, Serializable> parameters) throws Exception {
        for (Account account : accounts) {
            this.deleteAccount(account.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"UPSERT", "INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<Account> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("organizationId")) {
            return this.getOrganizationAccountsPage((String)((Object)parameters.get("organizationId")), search, filter, pagination, sorts);
        }
        return this.getAccountsPage(search, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<Account> accounts, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer accountUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            accountUnsafeConsumer = account -> this.patchAccount(account.getId() != null ? account.getId() : Long.parseLong((String)parameters.get("accountId")), (Account)account);
        }
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            accountUnsafeConsumer = account -> this.putAccount(account.getId() != null ? account.getId() : Long.parseLong((String)parameters.get("accountId")), (Account)account);
        }
        if (accountUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for Account");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(accounts, (Object)accountUnsafeConsumer);
        } else {
            for (Account account2 : accounts) {
                accountUnsafeConsumer.accept((Object)account2);
            }
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<Account>, UnsafeConsumer<Account, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(Account account, Account existingAccount) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

