/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.graphql.query.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.Account;
import com.liferay.headless.admin.user.dto.v1_0.AccountRole;
import com.liferay.headless.admin.user.dto.v1_0.EmailAddress;
import com.liferay.headless.admin.user.dto.v1_0.Organization;
import com.liferay.headless.admin.user.dto.v1_0.Phone;
import com.liferay.headless.admin.user.dto.v1_0.PostalAddress;
import com.liferay.headless.admin.user.dto.v1_0.Role;
import com.liferay.headless.admin.user.dto.v1_0.Segment;
import com.liferay.headless.admin.user.dto.v1_0.SegmentUser;
import com.liferay.headless.admin.user.dto.v1_0.Site;
import com.liferay.headless.admin.user.dto.v1_0.Subscription;
import com.liferay.headless.admin.user.dto.v1_0.UserAccount;
import com.liferay.headless.admin.user.dto.v1_0.UserGroup;
import com.liferay.headless.admin.user.dto.v1_0.WebUrl;
import com.liferay.headless.admin.user.resource.v1_0.AccountResource;
import com.liferay.headless.admin.user.resource.v1_0.AccountRoleResource;
import com.liferay.headless.admin.user.resource.v1_0.EmailAddressResource;
import com.liferay.headless.admin.user.resource.v1_0.OrganizationResource;
import com.liferay.headless.admin.user.resource.v1_0.PhoneResource;
import com.liferay.headless.admin.user.resource.v1_0.PostalAddressResource;
import com.liferay.headless.admin.user.resource.v1_0.RoleResource;
import com.liferay.headless.admin.user.resource.v1_0.SegmentResource;
import com.liferay.headless.admin.user.resource.v1_0.SegmentUserResource;
import com.liferay.headless.admin.user.resource.v1_0.SiteResource;
import com.liferay.headless.admin.user.resource.v1_0.SubscriptionResource;
import com.liferay.headless.admin.user.resource.v1_0.UserAccountResource;
import com.liferay.headless.admin.user.resource.v1_0.UserGroupResource;
import com.liferay.headless.admin.user.resource.v1_0.WebUrlResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLTypeExtension;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<AccountResource> _accountResourceComponentServiceObjects;
    private static ComponentServiceObjects<AccountRoleResource> _accountRoleResourceComponentServiceObjects;
    private static ComponentServiceObjects<EmailAddressResource> _emailAddressResourceComponentServiceObjects;
    private static ComponentServiceObjects<OrganizationResource> _organizationResourceComponentServiceObjects;
    private static ComponentServiceObjects<PhoneResource> _phoneResourceComponentServiceObjects;
    private static ComponentServiceObjects<PostalAddressResource> _postalAddressResourceComponentServiceObjects;
    private static ComponentServiceObjects<RoleResource> _roleResourceComponentServiceObjects;
    private static ComponentServiceObjects<SegmentResource> _segmentResourceComponentServiceObjects;
    private static ComponentServiceObjects<SegmentUserResource> _segmentUserResourceComponentServiceObjects;
    private static ComponentServiceObjects<SiteResource> _siteResourceComponentServiceObjects;
    private static ComponentServiceObjects<SubscriptionResource> _subscriptionResourceComponentServiceObjects;
    private static ComponentServiceObjects<UserAccountResource> _userAccountResourceComponentServiceObjects;
    private static ComponentServiceObjects<UserGroupResource> _userGroupResourceComponentServiceObjects;
    private static ComponentServiceObjects<WebUrlResource> _webUrlResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private Company _company;
    private BiFunction<Object, String, Filter> _filterBiFunction;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;

    public static void setAccountResourceComponentServiceObjects(ComponentServiceObjects<AccountResource> accountResourceComponentServiceObjects) {
        _accountResourceComponentServiceObjects = accountResourceComponentServiceObjects;
    }

    public static void setAccountRoleResourceComponentServiceObjects(ComponentServiceObjects<AccountRoleResource> accountRoleResourceComponentServiceObjects) {
        _accountRoleResourceComponentServiceObjects = accountRoleResourceComponentServiceObjects;
    }

    public static void setEmailAddressResourceComponentServiceObjects(ComponentServiceObjects<EmailAddressResource> emailAddressResourceComponentServiceObjects) {
        _emailAddressResourceComponentServiceObjects = emailAddressResourceComponentServiceObjects;
    }

    public static void setOrganizationResourceComponentServiceObjects(ComponentServiceObjects<OrganizationResource> organizationResourceComponentServiceObjects) {
        _organizationResourceComponentServiceObjects = organizationResourceComponentServiceObjects;
    }

    public static void setPhoneResourceComponentServiceObjects(ComponentServiceObjects<PhoneResource> phoneResourceComponentServiceObjects) {
        _phoneResourceComponentServiceObjects = phoneResourceComponentServiceObjects;
    }

    public static void setPostalAddressResourceComponentServiceObjects(ComponentServiceObjects<PostalAddressResource> postalAddressResourceComponentServiceObjects) {
        _postalAddressResourceComponentServiceObjects = postalAddressResourceComponentServiceObjects;
    }

    public static void setRoleResourceComponentServiceObjects(ComponentServiceObjects<RoleResource> roleResourceComponentServiceObjects) {
        _roleResourceComponentServiceObjects = roleResourceComponentServiceObjects;
    }

    public static void setSegmentResourceComponentServiceObjects(ComponentServiceObjects<SegmentResource> segmentResourceComponentServiceObjects) {
        _segmentResourceComponentServiceObjects = segmentResourceComponentServiceObjects;
    }

    public static void setSegmentUserResourceComponentServiceObjects(ComponentServiceObjects<SegmentUserResource> segmentUserResourceComponentServiceObjects) {
        _segmentUserResourceComponentServiceObjects = segmentUserResourceComponentServiceObjects;
    }

    public static void setSiteResourceComponentServiceObjects(ComponentServiceObjects<SiteResource> siteResourceComponentServiceObjects) {
        _siteResourceComponentServiceObjects = siteResourceComponentServiceObjects;
    }

    public static void setSubscriptionResourceComponentServiceObjects(ComponentServiceObjects<SubscriptionResource> subscriptionResourceComponentServiceObjects) {
        _subscriptionResourceComponentServiceObjects = subscriptionResourceComponentServiceObjects;
    }

    public static void setUserAccountResourceComponentServiceObjects(ComponentServiceObjects<UserAccountResource> userAccountResourceComponentServiceObjects) {
        _userAccountResourceComponentServiceObjects = userAccountResourceComponentServiceObjects;
    }

    public static void setUserGroupResourceComponentServiceObjects(ComponentServiceObjects<UserGroupResource> userGroupResourceComponentServiceObjects) {
        _userGroupResourceComponentServiceObjects = userGroupResourceComponentServiceObjects;
    }

    public static void setWebUrlResourceComponentServiceObjects(ComponentServiceObjects<WebUrlResource> webUrlResourceComponentServiceObjects) {
        _webUrlResourceComponentServiceObjects = webUrlResourceComponentServiceObjects;
    }

    @GraphQLField(description="Retrieves the accounts. Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves the accounts. Results can be paginated, filtered, searched, and sorted.") AccountPage accounts(@GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (AccountPage)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> new AccountPage(accountResource.getAccountsPage(search, this._filterBiFunction.apply(accountResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(accountResource, sortsString))));
    }

    @GraphQLField
    public Account accountByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return (Account)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.getAccountByExternalReferenceCode(externalReferenceCode));
    }

    @GraphQLField
    public Account account(@GraphQLName(value="accountId") Long accountId) throws Exception {
        return (Account)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.getAccount(accountId));
    }

    @GraphQLField(description="Retrieves the organization's members (accounts). Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves the organization's members (accounts). Results can be paginated, filtered, searched, and sorted.") AccountPage organizationAccounts(@GraphQLName(value="organizationId") String organizationId, @GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (AccountPage)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> new AccountPage(accountResource.getOrganizationAccountsPage(organizationId, search, this._filterBiFunction.apply(accountResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(accountResource, sortsString))));
    }

    @GraphQLField(description="Gets a user's account roles by their external reference code from an account by external reference code")
    public @GraphQLField(description="Gets a user's account roles by their external reference code from an account by external reference code") AccountRolePage accountByExternalReferenceCodeUserAccountByExternalReferenceCodeAccountRoles(@GraphQLName(value="accountExternalReferenceCode") String accountExternalReferenceCode, @GraphQLName(value="userAccountExternalReferenceCode") String userAccountExternalReferenceCode) throws Exception {
        return (AccountRolePage)this._applyComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> new AccountRolePage(accountRoleResource.getAccountByExternalReferenceCodeUserAccountByExternalReferenceCodeAccountRolesPage(accountExternalReferenceCode, userAccountExternalReferenceCode)));
    }

    @GraphQLField(description="Gets the account's roles")
    public @GraphQLField(description="Gets the account's roles") AccountRolePage accountAccountRolesByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="keywords") String keywords, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (AccountRolePage)this._applyComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> new AccountRolePage(accountRoleResource.getAccountAccountRolesByExternalReferenceCodePage(externalReferenceCode, keywords, this._filterBiFunction.apply(accountRoleResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(accountRoleResource, sortsString))));
    }

    @GraphQLField(description="Gets a user's account roles by their email address from an account by external reference code")
    public @GraphQLField(description="Gets a user's account roles by their email address from an account by external reference code") AccountRolePage accountByExternalReferenceCodeUserAccountByEmailAddressAccountRoles(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="emailAddress") String emailAddress) throws Exception {
        return (AccountRolePage)this._applyComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> new AccountRolePage(accountRoleResource.getAccountByExternalReferenceCodeUserAccountByEmailAddressAccountRolesPage(externalReferenceCode, emailAddress)));
    }

    @GraphQLField(description="Gets the account's roles")
    public @GraphQLField(description="Gets the account's roles") AccountRolePage accountAccountRoles(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="keywords") String keywords, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (AccountRolePage)this._applyComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> new AccountRolePage(accountRoleResource.getAccountAccountRolesPage(accountId, keywords, this._filterBiFunction.apply(accountRoleResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(accountRoleResource, sortsString))));
    }

    @GraphQLField(description="Retrieves the email address.")
    public @GraphQLField(description="Retrieves the email address.") EmailAddress emailAddress(@GraphQLName(value="emailAddressId") Long emailAddressId) throws Exception {
        return (EmailAddress)this._applyComponentServiceObjects(_emailAddressResourceComponentServiceObjects, this::_populateResourceContext, emailAddressResource -> emailAddressResource.getEmailAddress(emailAddressId));
    }

    @GraphQLField(description="Retrieves the organization's email addresses.")
    public @GraphQLField(description="Retrieves the organization's email addresses.") EmailAddressPage organizationEmailAddresses(@GraphQLName(value="organizationId") String organizationId) throws Exception {
        return (EmailAddressPage)this._applyComponentServiceObjects(_emailAddressResourceComponentServiceObjects, this::_populateResourceContext, emailAddressResource -> new EmailAddressPage(emailAddressResource.getOrganizationEmailAddressesPage(organizationId)));
    }

    @GraphQLField(description="Retrieves the user's email addresses.")
    public @GraphQLField(description="Retrieves the user's email addresses.") EmailAddressPage userAccountEmailAddresses(@GraphQLName(value="userAccountId") Long userAccountId) throws Exception {
        return (EmailAddressPage)this._applyComponentServiceObjects(_emailAddressResourceComponentServiceObjects, this::_populateResourceContext, emailAddressResource -> new EmailAddressPage(emailAddressResource.getUserAccountEmailAddressesPage(userAccountId)));
    }

    @GraphQLField(description="Retrieves the account's organizations. Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves the account's organizations. Results can be paginated, filtered, searched, and sorted.") OrganizationPage accountByExternalReferenceCodeOrganizations(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (OrganizationPage)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> new OrganizationPage(organizationResource.getAccountByExternalReferenceCodeOrganizationsPage(externalReferenceCode, search, this._filterBiFunction.apply(organizationResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(organizationResource, sortsString))));
    }

    @GraphQLField(description="Retrieves the account's organizations. Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves the account's organizations. Results can be paginated, filtered, searched, and sorted.") OrganizationPage accountOrganizations(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (OrganizationPage)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> new OrganizationPage(organizationResource.getAccountOrganizationsPage(accountId, search, this._filterBiFunction.apply(organizationResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(organizationResource, sortsString))));
    }

    @GraphQLField(description="Retrieves the organizations. Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves the organizations. Results can be paginated, filtered, searched, and sorted.") OrganizationPage organizations(@GraphQLName(value="flatten") Boolean flatten, @GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (OrganizationPage)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> new OrganizationPage(organizationResource.getOrganizationsPage(flatten, search, this._filterBiFunction.apply(organizationResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(organizationResource, sortsString))));
    }

    @GraphQLField
    public Organization organizationByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return (Organization)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.getOrganizationByExternalReferenceCode(externalReferenceCode));
    }

    @GraphQLField(description="Retrieves the organization.")
    public @GraphQLField(description="Retrieves the organization.") Organization organization(@GraphQLName(value="organizationId") String organizationId) throws Exception {
        return (Organization)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> organizationResource.getOrganization(organizationId));
    }

    @GraphQLField(description="Retrieves the parent organization's child organizations. Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves the parent organization's child organizations. Results can be paginated, filtered, searched, and sorted.") OrganizationPage organizationChildOrganizations(@GraphQLName(value="organizationId") String organizationId, @GraphQLName(value="flatten") Boolean flatten, @GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (OrganizationPage)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> new OrganizationPage(organizationResource.getOrganizationChildOrganizationsPage(organizationId, flatten, search, this._filterBiFunction.apply(organizationResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(organizationResource, sortsString))));
    }

    @GraphQLField(description="Retrieves the parent organization's child organizations. Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves the parent organization's child organizations. Results can be paginated, filtered, searched, and sorted.") OrganizationPage organizationOrganizations(@GraphQLName(value="parentOrganizationId") String parentOrganizationId, @GraphQLName(value="flatten") Boolean flatten, @GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (OrganizationPage)this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, this::_populateResourceContext, organizationResource -> new OrganizationPage(organizationResource.getOrganizationOrganizationsPage(parentOrganizationId, flatten, search, this._filterBiFunction.apply(organizationResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(organizationResource, sortsString))));
    }

    @GraphQLField(description="Retrieves the organization's phone numbers.")
    public @GraphQLField(description="Retrieves the organization's phone numbers.") PhonePage organizationPhones(@GraphQLName(value="organizationId") String organizationId) throws Exception {
        return (PhonePage)this._applyComponentServiceObjects(_phoneResourceComponentServiceObjects, this::_populateResourceContext, phoneResource -> new PhonePage(phoneResource.getOrganizationPhonesPage(organizationId)));
    }

    @GraphQLField(description="Retrieves the phone number.")
    public @GraphQLField(description="Retrieves the phone number.") Phone phone(@GraphQLName(value="phoneId") Long phoneId) throws Exception {
        return (Phone)this._applyComponentServiceObjects(_phoneResourceComponentServiceObjects, this::_populateResourceContext, phoneResource -> phoneResource.getPhone(phoneId));
    }

    @GraphQLField(description="Retrieves the user's phone numbers.")
    public @GraphQLField(description="Retrieves the user's phone numbers.") PhonePage userAccountPhones(@GraphQLName(value="userAccountId") Long userAccountId) throws Exception {
        return (PhonePage)this._applyComponentServiceObjects(_phoneResourceComponentServiceObjects, this::_populateResourceContext, phoneResource -> new PhonePage(phoneResource.getUserAccountPhonesPage(userAccountId)));
    }

    @GraphQLField(description="Retrieves the account's postal addresses.")
    public @GraphQLField(description="Retrieves the account's postal addresses.") PostalAddressPage accountPostalAddresses(@GraphQLName(value="accountId") Long accountId) throws Exception {
        return (PostalAddressPage)this._applyComponentServiceObjects(_postalAddressResourceComponentServiceObjects, this::_populateResourceContext, postalAddressResource -> new PostalAddressPage(postalAddressResource.getAccountPostalAddressesPage(accountId)));
    }

    @GraphQLField(description="Retrieves the organization's postal addresses.")
    public @GraphQLField(description="Retrieves the organization's postal addresses.") PostalAddressPage organizationPostalAddresses(@GraphQLName(value="organizationId") String organizationId) throws Exception {
        return (PostalAddressPage)this._applyComponentServiceObjects(_postalAddressResourceComponentServiceObjects, this::_populateResourceContext, postalAddressResource -> new PostalAddressPage(postalAddressResource.getOrganizationPostalAddressesPage(organizationId)));
    }

    @GraphQLField(description="Retrieves the postal address.")
    public @GraphQLField(description="Retrieves the postal address.") PostalAddress postalAddress(@GraphQLName(value="postalAddressId") Long postalAddressId) throws Exception {
        return (PostalAddress)this._applyComponentServiceObjects(_postalAddressResourceComponentServiceObjects, this::_populateResourceContext, postalAddressResource -> postalAddressResource.getPostalAddress(postalAddressId));
    }

    @GraphQLField(description="Retrieves the user's postal addresses.")
    public @GraphQLField(description="Retrieves the user's postal addresses.") PostalAddressPage userAccountPostalAddresses(@GraphQLName(value="userAccountId") Long userAccountId) throws Exception {
        return (PostalAddressPage)this._applyComponentServiceObjects(_postalAddressResourceComponentServiceObjects, this::_populateResourceContext, postalAddressResource -> new PostalAddressPage(postalAddressResource.getUserAccountPostalAddressesPage(userAccountId)));
    }

    @GraphQLField(description="Retrieves the portal instance's roles. Results can be paginated.")
    public @GraphQLField(description="Retrieves the portal instance's roles. Results can be paginated.") RolePage roles(@GraphQLName(value="types") Integer[] types, @GraphQLName(value="search") String search, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (RolePage)this._applyComponentServiceObjects(_roleResourceComponentServiceObjects, this::_populateResourceContext, roleResource -> new RolePage(roleResource.getRolesPage(types, search, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField(description="Retrieves the role.")
    public @GraphQLField(description="Retrieves the role.") Role role(@GraphQLName(value="roleId") Long roleId) throws Exception {
        return (Role)this._applyComponentServiceObjects(_roleResourceComponentServiceObjects, this::_populateResourceContext, roleResource -> roleResource.getRole(roleId));
    }

    @GraphQLField(description="Gets a site's segments.")
    public @GraphQLField(description="Gets a site's segments.") SegmentPage segments(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (SegmentPage)this._applyComponentServiceObjects(_segmentResourceComponentServiceObjects, this::_populateResourceContext, segmentResource -> new SegmentPage(segmentResource.getSiteSegmentsPage(Long.valueOf(siteKey), Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField(description="Gets a user's segments. The set of available headers are: Accept-Language (string), Host (string), User-Agent (string), X-Browser (string), X-Cookies (collection string), X-Device-Brand (string), X-Device-Model (string), X-Device-Screen-Resolution-Height (double), X-Device-Screen-Resolution-Width (double), X-Last-Sign-In-Date-Time (date time) and X-Signed-In (boolean). Local date will be always present in the request.")
    public @GraphQLField(description="Gets a user's segments. The set of available headers are: Accept-Language (string), Host (string), User-Agent (string), X-Browser (string), X-Cookies (collection string), X-Device-Brand (string), X-Device-Model (string), X-Device-Screen-Resolution-Height (double), X-Device-Screen-Resolution-Width (double), X-Last-Sign-In-Date-Time (date time) and X-Signed-In (boolean). Local date will be always present in the request.") SegmentPage userAccountSegments(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="userAccountId") Long userAccountId) throws Exception {
        return (SegmentPage)this._applyComponentServiceObjects(_segmentResourceComponentServiceObjects, this::_populateResourceContext, segmentResource -> new SegmentPage(segmentResource.getSiteUserAccountSegmentsPage(Long.valueOf(siteKey), userAccountId)));
    }

    @GraphQLField(description="Gets a segment's users.")
    public @GraphQLField(description="Gets a segment's users.") SegmentUserPage segmentUserAccounts(@GraphQLName(value="segmentId") Long segmentId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (SegmentUserPage)this._applyComponentServiceObjects(_segmentUserResourceComponentServiceObjects, this::_populateResourceContext, segmentUserResource -> new SegmentUserPage(segmentUserResource.getSegmentUserAccountsPage(segmentId, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public SitePage myUserAccountSites(@GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (SitePage)this._applyComponentServiceObjects(_siteResourceComponentServiceObjects, this::_populateResourceContext, siteResource -> new SitePage(siteResource.getMyUserAccountSitesPage(Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public Site byFriendlyUrlPath(@GraphQLName(value="friendlyUrlPath") String friendlyUrlPath) throws Exception {
        return (Site)this._applyComponentServiceObjects(_siteResourceComponentServiceObjects, this::_populateResourceContext, siteResource -> siteResource.getSiteByFriendlyUrlPath(friendlyUrlPath));
    }

    @GraphQLField
    public Site site(@GraphQLName(value="siteKey") @NotEmpty String siteKey) throws Exception {
        return (Site)this._applyComponentServiceObjects(_siteResourceComponentServiceObjects, this::_populateResourceContext, siteResource -> siteResource.getSite(Long.valueOf(siteKey)));
    }

    @GraphQLField
    public SubscriptionPage myUserAccountSubscriptions(@GraphQLName(value="contentType") String contentType, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (SubscriptionPage)this._applyComponentServiceObjects(_subscriptionResourceComponentServiceObjects, this::_populateResourceContext, subscriptionResource -> new SubscriptionPage(subscriptionResource.getMyUserAccountSubscriptionsPage(contentType, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public Subscription myUserAccountSubscription(@GraphQLName(value="subscriptionId") Long subscriptionId) throws Exception {
        return (Subscription)this._applyComponentServiceObjects(_subscriptionResourceComponentServiceObjects, this::_populateResourceContext, subscriptionResource -> subscriptionResource.getMyUserAccountSubscription(subscriptionId));
    }

    @GraphQLField(description="Gets the users assigned to an account")
    public @GraphQLField(description="Gets the users assigned to an account") UserAccountPage accountUserAccountsByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (UserAccountPage)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> new UserAccountPage(userAccountResource.getAccountUserAccountsByExternalReferenceCodePage(externalReferenceCode, search, this._filterBiFunction.apply(userAccountResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(userAccountResource, sortsString))));
    }

    @GraphQLField(description="Gets the users assigned to an account")
    public @GraphQLField(description="Gets the users assigned to an account") UserAccountPage accountUserAccounts(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (UserAccountPage)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> new UserAccountPage(userAccountResource.getAccountUserAccountsPage(accountId, search, this._filterBiFunction.apply(userAccountResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(userAccountResource, sortsString))));
    }

    @GraphQLField(description="Retrieves information about the user who made the request.")
    public @GraphQLField(description="Retrieves information about the user who made the request.") UserAccount myUserAccount() throws Exception {
        return (UserAccount)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.getMyUserAccount());
    }

    @GraphQLField(description="Retrieves the organization's members (users). Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves the organization's members (users). Results can be paginated, filtered, searched, and sorted.") UserAccountPage organizationUserAccounts(@GraphQLName(value="organizationId") String organizationId, @GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (UserAccountPage)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> new UserAccountPage(userAccountResource.getOrganizationUserAccountsPage(organizationId, search, this._filterBiFunction.apply(userAccountResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(userAccountResource, sortsString))));
    }

    @GraphQLField(description="Retrieves the site members' user accounts. Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves the site members' user accounts. Results can be paginated, filtered, searched, and sorted.") UserAccountPage siteUserAccounts(@GraphQLName(value="siteKey") @NotEmpty String siteKey, @GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (UserAccountPage)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> new UserAccountPage(userAccountResource.getSiteUserAccountsPage(Long.valueOf(siteKey), search, this._filterBiFunction.apply(userAccountResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(userAccountResource, sortsString))));
    }

    @GraphQLField(description="Retrieves the user accounts. Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves the user accounts. Results can be paginated, filtered, searched, and sorted.") UserAccountPage userAccounts(@GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (UserAccountPage)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> new UserAccountPage(userAccountResource.getUserAccountsPage(search, this._filterBiFunction.apply(userAccountResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(userAccountResource, sortsString))));
    }

    @GraphQLField
    public UserAccount userAccountByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return (UserAccount)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.getUserAccountByExternalReferenceCode(externalReferenceCode));
    }

    @GraphQLField(description="Retrieves the user account.")
    public @GraphQLField(description="Retrieves the user account.") UserAccount userAccount(@GraphQLName(value="userAccountId") Long userAccountId) throws Exception {
        return (UserAccount)this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, this::_populateResourceContext, userAccountResource -> userAccountResource.getUserAccount(userAccountId));
    }

    @GraphQLField(description="Retrieves the user's user groups.")
    public @GraphQLField(description="Retrieves the user's user groups.") UserGroupPage userUserGroups(@GraphQLName(value="userAccountId") Long userAccountId) throws Exception {
        return (UserGroupPage)this._applyComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> new UserGroupPage(userGroupResource.getUserUserGroups(userAccountId)));
    }

    @GraphQLField
    public UserGroupPage userGroups(@GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (UserGroupPage)this._applyComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> new UserGroupPage(userGroupResource.getUserGroupsPage(search, this._filterBiFunction.apply(userGroupResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(userGroupResource, sortsString))));
    }

    @GraphQLField
    public UserGroup userGroupByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return (UserGroup)this._applyComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> userGroupResource.getUserGroupByExternalReferenceCode(externalReferenceCode));
    }

    @GraphQLField
    public UserGroup userGroup(@GraphQLName(value="userGroupId") Long userGroupId) throws Exception {
        return (UserGroup)this._applyComponentServiceObjects(_userGroupResourceComponentServiceObjects, this::_populateResourceContext, userGroupResource -> userGroupResource.getUserGroup(userGroupId));
    }

    @GraphQLField(description="Retrieves the organization's URLs.")
    public @GraphQLField(description="Retrieves the organization's URLs.") WebUrlPage organizationWebUrls(@GraphQLName(value="organizationId") String organizationId) throws Exception {
        return (WebUrlPage)this._applyComponentServiceObjects(_webUrlResourceComponentServiceObjects, this::_populateResourceContext, webUrlResource -> new WebUrlPage(webUrlResource.getOrganizationWebUrlsPage(organizationId)));
    }

    @GraphQLField(description="Retrieves the user's URLs.")
    public @GraphQLField(description="Retrieves the user's URLs.") WebUrlPage userAccountWebUrls(@GraphQLName(value="userAccountId") Long userAccountId) throws Exception {
        return (WebUrlPage)this._applyComponentServiceObjects(_webUrlResourceComponentServiceObjects, this::_populateResourceContext, webUrlResource -> new WebUrlPage(webUrlResource.getUserAccountWebUrlsPage(userAccountId)));
    }

    @GraphQLField(description="Retrieves the web URL.")
    public @GraphQLField(description="Retrieves the web URL.") WebUrl webUrl(@GraphQLName(value="webUrlId") Long webUrlId) throws Exception {
        return (WebUrl)this._applyComponentServiceObjects(_webUrlResourceComponentServiceObjects, this::_populateResourceContext, webUrlResource -> webUrlResource.getWebUrl(webUrlId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(AccountResource accountResource) throws Exception {
        accountResource.setContextAcceptLanguage(this._acceptLanguage);
        accountResource.setContextCompany(this._company);
        accountResource.setContextHttpServletRequest(this._httpServletRequest);
        accountResource.setContextHttpServletResponse(this._httpServletResponse);
        accountResource.setContextUriInfo(this._uriInfo);
        accountResource.setContextUser(this._user);
        accountResource.setGroupLocalService(this._groupLocalService);
        accountResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(AccountRoleResource accountRoleResource) throws Exception {
        accountRoleResource.setContextAcceptLanguage(this._acceptLanguage);
        accountRoleResource.setContextCompany(this._company);
        accountRoleResource.setContextHttpServletRequest(this._httpServletRequest);
        accountRoleResource.setContextHttpServletResponse(this._httpServletResponse);
        accountRoleResource.setContextUriInfo(this._uriInfo);
        accountRoleResource.setContextUser(this._user);
        accountRoleResource.setGroupLocalService(this._groupLocalService);
        accountRoleResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(EmailAddressResource emailAddressResource) throws Exception {
        emailAddressResource.setContextAcceptLanguage(this._acceptLanguage);
        emailAddressResource.setContextCompany(this._company);
        emailAddressResource.setContextHttpServletRequest(this._httpServletRequest);
        emailAddressResource.setContextHttpServletResponse(this._httpServletResponse);
        emailAddressResource.setContextUriInfo(this._uriInfo);
        emailAddressResource.setContextUser(this._user);
        emailAddressResource.setGroupLocalService(this._groupLocalService);
        emailAddressResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(OrganizationResource organizationResource) throws Exception {
        organizationResource.setContextAcceptLanguage(this._acceptLanguage);
        organizationResource.setContextCompany(this._company);
        organizationResource.setContextHttpServletRequest(this._httpServletRequest);
        organizationResource.setContextHttpServletResponse(this._httpServletResponse);
        organizationResource.setContextUriInfo(this._uriInfo);
        organizationResource.setContextUser(this._user);
        organizationResource.setGroupLocalService(this._groupLocalService);
        organizationResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(PhoneResource phoneResource) throws Exception {
        phoneResource.setContextAcceptLanguage(this._acceptLanguage);
        phoneResource.setContextCompany(this._company);
        phoneResource.setContextHttpServletRequest(this._httpServletRequest);
        phoneResource.setContextHttpServletResponse(this._httpServletResponse);
        phoneResource.setContextUriInfo(this._uriInfo);
        phoneResource.setContextUser(this._user);
        phoneResource.setGroupLocalService(this._groupLocalService);
        phoneResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(PostalAddressResource postalAddressResource) throws Exception {
        postalAddressResource.setContextAcceptLanguage(this._acceptLanguage);
        postalAddressResource.setContextCompany(this._company);
        postalAddressResource.setContextHttpServletRequest(this._httpServletRequest);
        postalAddressResource.setContextHttpServletResponse(this._httpServletResponse);
        postalAddressResource.setContextUriInfo(this._uriInfo);
        postalAddressResource.setContextUser(this._user);
        postalAddressResource.setGroupLocalService(this._groupLocalService);
        postalAddressResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(RoleResource roleResource) throws Exception {
        roleResource.setContextAcceptLanguage(this._acceptLanguage);
        roleResource.setContextCompany(this._company);
        roleResource.setContextHttpServletRequest(this._httpServletRequest);
        roleResource.setContextHttpServletResponse(this._httpServletResponse);
        roleResource.setContextUriInfo(this._uriInfo);
        roleResource.setContextUser(this._user);
        roleResource.setGroupLocalService(this._groupLocalService);
        roleResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(SegmentResource segmentResource) throws Exception {
        segmentResource.setContextAcceptLanguage(this._acceptLanguage);
        segmentResource.setContextCompany(this._company);
        segmentResource.setContextHttpServletRequest(this._httpServletRequest);
        segmentResource.setContextHttpServletResponse(this._httpServletResponse);
        segmentResource.setContextUriInfo(this._uriInfo);
        segmentResource.setContextUser(this._user);
        segmentResource.setGroupLocalService(this._groupLocalService);
        segmentResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(SegmentUserResource segmentUserResource) throws Exception {
        segmentUserResource.setContextAcceptLanguage(this._acceptLanguage);
        segmentUserResource.setContextCompany(this._company);
        segmentUserResource.setContextHttpServletRequest(this._httpServletRequest);
        segmentUserResource.setContextHttpServletResponse(this._httpServletResponse);
        segmentUserResource.setContextUriInfo(this._uriInfo);
        segmentUserResource.setContextUser(this._user);
        segmentUserResource.setGroupLocalService(this._groupLocalService);
        segmentUserResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(SiteResource siteResource) throws Exception {
        siteResource.setContextAcceptLanguage(this._acceptLanguage);
        siteResource.setContextCompany(this._company);
        siteResource.setContextHttpServletRequest(this._httpServletRequest);
        siteResource.setContextHttpServletResponse(this._httpServletResponse);
        siteResource.setContextUriInfo(this._uriInfo);
        siteResource.setContextUser(this._user);
        siteResource.setGroupLocalService(this._groupLocalService);
        siteResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(SubscriptionResource subscriptionResource) throws Exception {
        subscriptionResource.setContextAcceptLanguage(this._acceptLanguage);
        subscriptionResource.setContextCompany(this._company);
        subscriptionResource.setContextHttpServletRequest(this._httpServletRequest);
        subscriptionResource.setContextHttpServletResponse(this._httpServletResponse);
        subscriptionResource.setContextUriInfo(this._uriInfo);
        subscriptionResource.setContextUser(this._user);
        subscriptionResource.setGroupLocalService(this._groupLocalService);
        subscriptionResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(UserAccountResource userAccountResource) throws Exception {
        userAccountResource.setContextAcceptLanguage(this._acceptLanguage);
        userAccountResource.setContextCompany(this._company);
        userAccountResource.setContextHttpServletRequest(this._httpServletRequest);
        userAccountResource.setContextHttpServletResponse(this._httpServletResponse);
        userAccountResource.setContextUriInfo(this._uriInfo);
        userAccountResource.setContextUser(this._user);
        userAccountResource.setGroupLocalService(this._groupLocalService);
        userAccountResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(UserGroupResource userGroupResource) throws Exception {
        userGroupResource.setContextAcceptLanguage(this._acceptLanguage);
        userGroupResource.setContextCompany(this._company);
        userGroupResource.setContextHttpServletRequest(this._httpServletRequest);
        userGroupResource.setContextHttpServletResponse(this._httpServletResponse);
        userGroupResource.setContextUriInfo(this._uriInfo);
        userGroupResource.setContextUser(this._user);
        userGroupResource.setGroupLocalService(this._groupLocalService);
        userGroupResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(WebUrlResource webUrlResource) throws Exception {
        webUrlResource.setContextAcceptLanguage(this._acceptLanguage);
        webUrlResource.setContextCompany(this._company);
        webUrlResource.setContextHttpServletRequest(this._httpServletRequest);
        webUrlResource.setContextHttpServletResponse(this._httpServletResponse);
        webUrlResource.setContextUriInfo(this._uriInfo);
        webUrlResource.setContextUser(this._user);
        webUrlResource.setGroupLocalService(this._groupLocalService);
        webUrlResource.setRoleLocalService(this._roleLocalService);
    }

    @GraphQLTypeExtension(value=Site.class)
    public class ParentSiteSiteIdTypeExtension {
        private Site _site;

        public ParentSiteSiteIdTypeExtension(Site site) {
            this._site = site;
        }

        @GraphQLField
        public Site parentSite() throws Exception {
            if (this._site.getParentSiteId() == null) {
                return null;
            }
            return (Site)Query.this._applyComponentServiceObjects(_siteResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), siteResource -> siteResource.getSite(this._site.getParentSiteId()));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class ParentAccountAccountIdTypeExtension {
        private Account _account;

        public ParentAccountAccountIdTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField
        public Account parentAccount() throws Exception {
            if (this._account.getParentAccountId() == null) {
                return null;
            }
            return (Account)Query.this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), accountResource -> accountResource.getAccount(this._account.getParentAccountId()));
        }
    }

    @GraphQLName(value="WebUrlPage")
    public class WebUrlPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<WebUrl> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public WebUrlPage(Page webUrlPage) {
            this.actions = webUrlPage.getActions();
            this.items = webUrlPage.getItems();
            this.lastPage = webUrlPage.getLastPage();
            this.page = webUrlPage.getPage();
            this.pageSize = webUrlPage.getPageSize();
            this.totalCount = webUrlPage.getTotalCount();
        }
    }

    @GraphQLName(value="UserGroupPage")
    public class UserGroupPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<UserGroup> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public UserGroupPage(Page userGroupPage) {
            this.actions = userGroupPage.getActions();
            this.items = userGroupPage.getItems();
            this.lastPage = userGroupPage.getLastPage();
            this.page = userGroupPage.getPage();
            this.pageSize = userGroupPage.getPageSize();
            this.totalCount = userGroupPage.getTotalCount();
        }
    }

    @GraphQLName(value="UserAccountPage")
    public class UserAccountPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<UserAccount> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public UserAccountPage(Page userAccountPage) {
            this.actions = userAccountPage.getActions();
            this.items = userAccountPage.getItems();
            this.lastPage = userAccountPage.getLastPage();
            this.page = userAccountPage.getPage();
            this.pageSize = userAccountPage.getPageSize();
            this.totalCount = userAccountPage.getTotalCount();
        }
    }

    @GraphQLName(value="SubscriptionPage")
    public class SubscriptionPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Subscription> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public SubscriptionPage(Page subscriptionPage) {
            this.actions = subscriptionPage.getActions();
            this.items = subscriptionPage.getItems();
            this.lastPage = subscriptionPage.getLastPage();
            this.page = subscriptionPage.getPage();
            this.pageSize = subscriptionPage.getPageSize();
            this.totalCount = subscriptionPage.getTotalCount();
        }
    }

    @GraphQLName(value="SitePage")
    public class SitePage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Site> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public SitePage(Page sitePage) {
            this.actions = sitePage.getActions();
            this.items = sitePage.getItems();
            this.lastPage = sitePage.getLastPage();
            this.page = sitePage.getPage();
            this.pageSize = sitePage.getPageSize();
            this.totalCount = sitePage.getTotalCount();
        }
    }

    @GraphQLName(value="SegmentUserPage")
    public class SegmentUserPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<SegmentUser> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public SegmentUserPage(Page segmentUserPage) {
            this.actions = segmentUserPage.getActions();
            this.items = segmentUserPage.getItems();
            this.lastPage = segmentUserPage.getLastPage();
            this.page = segmentUserPage.getPage();
            this.pageSize = segmentUserPage.getPageSize();
            this.totalCount = segmentUserPage.getTotalCount();
        }
    }

    @GraphQLName(value="SegmentPage")
    public class SegmentPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Segment> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public SegmentPage(Page segmentPage) {
            this.actions = segmentPage.getActions();
            this.items = segmentPage.getItems();
            this.lastPage = segmentPage.getLastPage();
            this.page = segmentPage.getPage();
            this.pageSize = segmentPage.getPageSize();
            this.totalCount = segmentPage.getTotalCount();
        }
    }

    @GraphQLName(value="RolePage")
    public class RolePage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Role> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public RolePage(Page rolePage) {
            this.actions = rolePage.getActions();
            this.items = rolePage.getItems();
            this.lastPage = rolePage.getLastPage();
            this.page = rolePage.getPage();
            this.pageSize = rolePage.getPageSize();
            this.totalCount = rolePage.getTotalCount();
        }
    }

    @GraphQLName(value="PostalAddressPage")
    public class PostalAddressPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<PostalAddress> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public PostalAddressPage(Page postalAddressPage) {
            this.actions = postalAddressPage.getActions();
            this.items = postalAddressPage.getItems();
            this.lastPage = postalAddressPage.getLastPage();
            this.page = postalAddressPage.getPage();
            this.pageSize = postalAddressPage.getPageSize();
            this.totalCount = postalAddressPage.getTotalCount();
        }
    }

    @GraphQLName(value="PhonePage")
    public class PhonePage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Phone> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public PhonePage(Page phonePage) {
            this.actions = phonePage.getActions();
            this.items = phonePage.getItems();
            this.lastPage = phonePage.getLastPage();
            this.page = phonePage.getPage();
            this.pageSize = phonePage.getPageSize();
            this.totalCount = phonePage.getTotalCount();
        }
    }

    @GraphQLName(value="OrganizationPage")
    public class OrganizationPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Organization> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public OrganizationPage(Page organizationPage) {
            this.actions = organizationPage.getActions();
            this.items = organizationPage.getItems();
            this.lastPage = organizationPage.getLastPage();
            this.page = organizationPage.getPage();
            this.pageSize = organizationPage.getPageSize();
            this.totalCount = organizationPage.getTotalCount();
        }
    }

    @GraphQLName(value="EmailAddressPage")
    public class EmailAddressPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<EmailAddress> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public EmailAddressPage(Page emailAddressPage) {
            this.actions = emailAddressPage.getActions();
            this.items = emailAddressPage.getItems();
            this.lastPage = emailAddressPage.getLastPage();
            this.page = emailAddressPage.getPage();
            this.pageSize = emailAddressPage.getPageSize();
            this.totalCount = emailAddressPage.getTotalCount();
        }
    }

    @GraphQLName(value="AccountRolePage")
    public class AccountRolePage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<AccountRole> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public AccountRolePage(Page accountRolePage) {
            this.actions = accountRolePage.getActions();
            this.items = accountRolePage.getItems();
            this.lastPage = accountRolePage.getLastPage();
            this.page = accountRolePage.getPage();
            this.pageSize = accountRolePage.getPageSize();
            this.totalCount = accountRolePage.getTotalCount();
        }
    }

    @GraphQLName(value="AccountPage")
    public class AccountPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Account> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public AccountPage(Page accountPage) {
            this.actions = accountPage.getActions();
            this.items = accountPage.getItems();
            this.lastPage = accountPage.getLastPage();
            this.page = accountPage.getPage();
            this.pageSize = accountPage.getPageSize();
            this.totalCount = accountPage.getTotalCount();
        }
    }

    @GraphQLTypeExtension(value=UserAccount.class)
    public class GetUserUserGroupsTypeExtension {
        private UserAccount _userAccount;

        public GetUserUserGroupsTypeExtension(UserAccount userAccount) {
            this._userAccount = userAccount;
        }

        @GraphQLField(description="Retrieves the user's user groups.")
        public @GraphQLField(description="Retrieves the user's user groups.") UserGroupPage userUserGroups() throws Exception {
            return (UserGroupPage)Query.this._applyComponentServiceObjects(_userGroupResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), userGroupResource -> new UserGroupPage(userGroupResource.getUserUserGroups(this._userAccount.getId())));
        }
    }

    @GraphQLTypeExtension(value=Organization.class)
    public class GetOrganizationPhonesPageTypeExtension {
        private Organization _organization;

        public GetOrganizationPhonesPageTypeExtension(Organization organization) {
            this._organization = organization;
        }

        @GraphQLField(description="Retrieves the organization's phone numbers.")
        public @GraphQLField(description="Retrieves the organization's phone numbers.") PhonePage phones() throws Exception {
            return (PhonePage)Query.this._applyComponentServiceObjects(_phoneResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), phoneResource -> new PhonePage(phoneResource.getOrganizationPhonesPage(this._organization.getId())));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetOrganizationByExternalReferenceCodeTypeExtension {
        private Account _account;

        public GetOrganizationByExternalReferenceCodeTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField
        public Organization organizationByExternalReferenceCode() throws Exception {
            return (Organization)Query.this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), organizationResource -> organizationResource.getOrganizationByExternalReferenceCode(this._account.getExternalReferenceCode()));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetAccountPostalAddressesPageTypeExtension {
        private Account _account;

        public GetAccountPostalAddressesPageTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField(description="Retrieves the account's postal addresses.")
        public @GraphQLField(description="Retrieves the account's postal addresses.") PostalAddressPage postalAddresses() throws Exception {
            return (PostalAddressPage)Query.this._applyComponentServiceObjects(_postalAddressResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), postalAddressResource -> new PostalAddressPage(postalAddressResource.getAccountPostalAddressesPage(this._account.getId())));
        }
    }

    @GraphQLTypeExtension(value=UserAccount.class)
    public class GetUserAccountWebUrlsPageTypeExtension {
        private UserAccount _userAccount;

        public GetUserAccountWebUrlsPageTypeExtension(UserAccount userAccount) {
            this._userAccount = userAccount;
        }

        @GraphQLField(description="Retrieves the user's URLs.")
        public @GraphQLField(description="Retrieves the user's URLs.") WebUrlPage webUrls() throws Exception {
            return (WebUrlPage)Query.this._applyComponentServiceObjects(_webUrlResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), webUrlResource -> new WebUrlPage(webUrlResource.getUserAccountWebUrlsPage(this._userAccount.getId())));
        }
    }

    @GraphQLTypeExtension(value=Subscription.class)
    public class GetSiteTypeExtension {
        private Subscription _subscription;

        public GetSiteTypeExtension(Subscription subscription) {
            this._subscription = subscription;
        }

        @GraphQLField
        public Site site() throws Exception {
            return (Site)Query.this._applyComponentServiceObjects(_siteResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), siteResource -> siteResource.getSite(this._subscription.getSiteId()));
        }
    }

    @GraphQLTypeExtension(value=Organization.class)
    public class GetOrganizationWebUrlsPageTypeExtension {
        private Organization _organization;

        public GetOrganizationWebUrlsPageTypeExtension(Organization organization) {
            this._organization = organization;
        }

        @GraphQLField(description="Retrieves the organization's URLs.")
        public @GraphQLField(description="Retrieves the organization's URLs.") WebUrlPage webUrls() throws Exception {
            return (WebUrlPage)Query.this._applyComponentServiceObjects(_webUrlResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), webUrlResource -> new WebUrlPage(webUrlResource.getOrganizationWebUrlsPage(this._organization.getId())));
        }
    }

    @GraphQLTypeExtension(value=Site.class)
    public class GetSiteSegmentsPageTypeExtension {
        private Site _site;

        public GetSiteSegmentsPageTypeExtension(Site site) {
            this._site = site;
        }

        @GraphQLField(description="Gets a site's segments.")
        public @GraphQLField(description="Gets a site's segments.") SegmentPage segments(@GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
            return (SegmentPage)Query.this._applyComponentServiceObjects(_segmentResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), segmentResource -> new SegmentPage(segmentResource.getSiteSegmentsPage(this._site.getId(), Pagination.of((int)page, (int)pageSize))));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetAccountByExternalReferenceCodeUserAccountByEmailAddressAccountRolesPageTypeExtension {
        private Account _account;

        public GetAccountByExternalReferenceCodeUserAccountByEmailAddressAccountRolesPageTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField(description="Gets a user's account roles by their email address from an account by external reference code")
        public @GraphQLField(description="Gets a user's account roles by their email address from an account by external reference code") AccountRolePage byExternalReferenceCodeUserAccountByEmailAddressAccountRoles(@GraphQLName(value="emailAddress") String emailAddress) throws Exception {
            return (AccountRolePage)Query.this._applyComponentServiceObjects(_accountRoleResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), accountRoleResource -> new AccountRolePage(accountRoleResource.getAccountByExternalReferenceCodeUserAccountByEmailAddressAccountRolesPage(this._account.getExternalReferenceCode(), emailAddress)));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetAccountOrganizationsPageTypeExtension {
        private Account _account;

        public GetAccountOrganizationsPageTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField(description="Retrieves the account's organizations. Results can be paginated, filtered, searched, and sorted.")
        public @GraphQLField(description="Retrieves the account's organizations. Results can be paginated, filtered, searched, and sorted.") OrganizationPage organizations(@GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (OrganizationPage)Query.this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), organizationResource -> new OrganizationPage(organizationResource.getAccountOrganizationsPage(this._account.getId(), search, (Filter)Query.this._filterBiFunction.apply(organizationResource, filterString), Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(organizationResource, sortsString))));
        }
    }

    @GraphQLTypeExtension(value=AccountRole.class)
    public class GetRoleTypeExtension {
        private AccountRole _accountRole;

        public GetRoleTypeExtension(AccountRole accountRole) {
            this._accountRole = accountRole;
        }

        @GraphQLField(description="Retrieves the role.")
        public @GraphQLField(description="Retrieves the role.") Role role() throws Exception {
            return (Role)Query.this._applyComponentServiceObjects(_roleResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), roleResource -> roleResource.getRole(this._accountRole.getRoleId()));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetAccountUserAccountsByExternalReferenceCodePageTypeExtension {
        private Account _account;

        public GetAccountUserAccountsByExternalReferenceCodePageTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField(description="Gets the users assigned to an account")
        public @GraphQLField(description="Gets the users assigned to an account") UserAccountPage userAccountsByExternalReferenceCode(@GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (UserAccountPage)Query.this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), userAccountResource -> new UserAccountPage(userAccountResource.getAccountUserAccountsByExternalReferenceCodePage(this._account.getExternalReferenceCode(), search, (Filter)Query.this._filterBiFunction.apply(userAccountResource, filterString), Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(userAccountResource, sortsString))));
        }
    }

    @GraphQLTypeExtension(value=Site.class)
    public class GetSiteUserAccountsPageTypeExtension {
        private Site _site;

        public GetSiteUserAccountsPageTypeExtension(Site site) {
            this._site = site;
        }

        @GraphQLField(description="Retrieves the site members' user accounts. Results can be paginated, filtered, searched, and sorted.")
        public @GraphQLField(description="Retrieves the site members' user accounts. Results can be paginated, filtered, searched, and sorted.") UserAccountPage userAccounts(@GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (UserAccountPage)Query.this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), userAccountResource -> new UserAccountPage(userAccountResource.getSiteUserAccountsPage(this._site.getId(), search, (Filter)Query.this._filterBiFunction.apply(userAccountResource, filterString), Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(userAccountResource, sortsString))));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetUserGroupByExternalReferenceCodeTypeExtension {
        private Account _account;

        public GetUserGroupByExternalReferenceCodeTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField
        public UserGroup userGroupByExternalReferenceCode() throws Exception {
            return (UserGroup)Query.this._applyComponentServiceObjects(_userGroupResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), userGroupResource -> userGroupResource.getUserGroupByExternalReferenceCode(this._account.getExternalReferenceCode()));
        }
    }

    @GraphQLTypeExtension(value=Organization.class)
    public class GetOrganizationEmailAddressesPageTypeExtension {
        private Organization _organization;

        public GetOrganizationEmailAddressesPageTypeExtension(Organization organization) {
            this._organization = organization;
        }

        @GraphQLField(description="Retrieves the organization's email addresses.")
        public @GraphQLField(description="Retrieves the organization's email addresses.") EmailAddressPage emailAddresses() throws Exception {
            return (EmailAddressPage)Query.this._applyComponentServiceObjects(_emailAddressResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), emailAddressResource -> new EmailAddressPage(emailAddressResource.getOrganizationEmailAddressesPage(this._organization.getId())));
        }
    }

    @GraphQLTypeExtension(value=Organization.class)
    public class GetOrganizationOrganizationsPageTypeExtension {
        private Organization _organization;

        public GetOrganizationOrganizationsPageTypeExtension(Organization organization) {
            this._organization = organization;
        }

        @GraphQLField(description="Retrieves the parent organization's child organizations. Results can be paginated, filtered, searched, and sorted.")
        public @GraphQLField(description="Retrieves the parent organization's child organizations. Results can be paginated, filtered, searched, and sorted.") OrganizationPage organizations(@GraphQLName(value="flatten") Boolean flatten, @GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (OrganizationPage)Query.this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), organizationResource -> new OrganizationPage(organizationResource.getOrganizationOrganizationsPage(this._organization.getId(), flatten, search, (Filter)Query.this._filterBiFunction.apply(organizationResource, filterString), Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(organizationResource, sortsString))));
        }
    }

    @GraphQLTypeExtension(value=AccountRole.class)
    public class GetAccountTypeExtension {
        private AccountRole _accountRole;

        public GetAccountTypeExtension(AccountRole accountRole) {
            this._accountRole = accountRole;
        }

        @GraphQLField
        public Account account() throws Exception {
            return (Account)Query.this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), accountResource -> accountResource.getAccount(this._accountRole.getAccountId()));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetAccountByExternalReferenceCodeOrganizationsPageTypeExtension {
        private Account _account;

        public GetAccountByExternalReferenceCodeOrganizationsPageTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField(description="Retrieves the account's organizations. Results can be paginated, filtered, searched, and sorted.")
        public @GraphQLField(description="Retrieves the account's organizations. Results can be paginated, filtered, searched, and sorted.") OrganizationPage byExternalReferenceCodeOrganizations(@GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (OrganizationPage)Query.this._applyComponentServiceObjects(_organizationResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), organizationResource -> new OrganizationPage(organizationResource.getAccountByExternalReferenceCodeOrganizationsPage(this._account.getExternalReferenceCode(), search, (Filter)Query.this._filterBiFunction.apply(organizationResource, filterString), Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(organizationResource, sortsString))));
        }
    }

    @GraphQLTypeExtension(value=Organization.class)
    public class GetOrganizationPostalAddressesPageTypeExtension {
        private Organization _organization;

        public GetOrganizationPostalAddressesPageTypeExtension(Organization organization) {
            this._organization = organization;
        }

        @GraphQLField(description="Retrieves the organization's postal addresses.")
        public @GraphQLField(description="Retrieves the organization's postal addresses.") PostalAddressPage postalAddresses() throws Exception {
            return (PostalAddressPage)Query.this._applyComponentServiceObjects(_postalAddressResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), postalAddressResource -> new PostalAddressPage(postalAddressResource.getOrganizationPostalAddressesPage(this._organization.getId())));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetUserAccountByExternalReferenceCodeTypeExtension {
        private Account _account;

        public GetUserAccountByExternalReferenceCodeTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField
        public UserAccount userAccountByExternalReferenceCode() throws Exception {
            return (UserAccount)Query.this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), userAccountResource -> userAccountResource.getUserAccountByExternalReferenceCode(this._account.getExternalReferenceCode()));
        }
    }

    @GraphQLTypeExtension(value=UserAccount.class)
    public class GetUserAccountEmailAddressesPageTypeExtension {
        private UserAccount _userAccount;

        public GetUserAccountEmailAddressesPageTypeExtension(UserAccount userAccount) {
            this._userAccount = userAccount;
        }

        @GraphQLField(description="Retrieves the user's email addresses.")
        public @GraphQLField(description="Retrieves the user's email addresses.") EmailAddressPage emailAddresses() throws Exception {
            return (EmailAddressPage)Query.this._applyComponentServiceObjects(_emailAddressResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), emailAddressResource -> new EmailAddressPage(emailAddressResource.getUserAccountEmailAddressesPage(this._userAccount.getId())));
        }
    }

    @GraphQLTypeExtension(value=UserAccount.class)
    public class GetUserAccountPostalAddressesPageTypeExtension {
        private UserAccount _userAccount;

        public GetUserAccountPostalAddressesPageTypeExtension(UserAccount userAccount) {
            this._userAccount = userAccount;
        }

        @GraphQLField(description="Retrieves the user's postal addresses.")
        public @GraphQLField(description="Retrieves the user's postal addresses.") PostalAddressPage postalAddresses() throws Exception {
            return (PostalAddressPage)Query.this._applyComponentServiceObjects(_postalAddressResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), postalAddressResource -> new PostalAddressPage(postalAddressResource.getUserAccountPostalAddressesPage(this._userAccount.getId())));
        }
    }

    @GraphQLTypeExtension(value=Site.class)
    public class GetSiteUserAccountSegmentsPageTypeExtension {
        private Site _site;

        public GetSiteUserAccountSegmentsPageTypeExtension(Site site) {
            this._site = site;
        }

        @GraphQLField(description="Gets a user's segments. The set of available headers are: Accept-Language (string), Host (string), User-Agent (string), X-Browser (string), X-Cookies (collection string), X-Device-Brand (string), X-Device-Model (string), X-Device-Screen-Resolution-Height (double), X-Device-Screen-Resolution-Width (double), X-Last-Sign-In-Date-Time (date time) and X-Signed-In (boolean). Local date will be always present in the request.")
        public @GraphQLField(description="Gets a user's segments. The set of available headers are: Accept-Language (string), Host (string), User-Agent (string), X-Browser (string), X-Cookies (collection string), X-Device-Brand (string), X-Device-Model (string), X-Device-Screen-Resolution-Height (double), X-Device-Screen-Resolution-Width (double), X-Last-Sign-In-Date-Time (date time) and X-Signed-In (boolean). Local date will be always present in the request.") SegmentPage userAccountSegments(@GraphQLName(value="userAccountId") Long userAccountId) throws Exception {
            return (SegmentPage)Query.this._applyComponentServiceObjects(_segmentResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), segmentResource -> new SegmentPage(segmentResource.getSiteUserAccountSegmentsPage(this._site.getId(), userAccountId)));
        }
    }

    @GraphQLTypeExtension(value=Organization.class)
    public class GetOrganizationAccountsPageTypeExtension {
        private Organization _organization;

        public GetOrganizationAccountsPageTypeExtension(Organization organization) {
            this._organization = organization;
        }

        @GraphQLField(description="Retrieves the organization's members (accounts). Results can be paginated, filtered, searched, and sorted.")
        public @GraphQLField(description="Retrieves the organization's members (accounts). Results can be paginated, filtered, searched, and sorted.") AccountPage accounts(@GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (AccountPage)Query.this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), accountResource -> new AccountPage(accountResource.getOrganizationAccountsPage(this._organization.getId(), search, (Filter)Query.this._filterBiFunction.apply(accountResource, filterString), Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(accountResource, sortsString))));
        }
    }

    @GraphQLTypeExtension(value=Organization.class)
    public class GetAccountByExternalReferenceCodeTypeExtension {
        private Organization _organization;

        public GetAccountByExternalReferenceCodeTypeExtension(Organization organization) {
            this._organization = organization;
        }

        @GraphQLField
        public Account accountByExternalReferenceCode() throws Exception {
            return (Account)Query.this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), accountResource -> accountResource.getAccountByExternalReferenceCode(this._organization.getExternalReferenceCode()));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetAccountAccountRolesByExternalReferenceCodePageTypeExtension {
        private Account _account;

        public GetAccountAccountRolesByExternalReferenceCodePageTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField(description="Gets the account's roles")
        public @GraphQLField(description="Gets the account's roles") AccountRolePage accountRolesByExternalReferenceCode(@GraphQLName(value="keywords") String keywords, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (AccountRolePage)Query.this._applyComponentServiceObjects(_accountRoleResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), accountRoleResource -> new AccountRolePage(accountRoleResource.getAccountAccountRolesByExternalReferenceCodePage(this._account.getExternalReferenceCode(), keywords, (Filter)Query.this._filterBiFunction.apply(accountRoleResource, filterString), Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(accountRoleResource, sortsString))));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetAccountAccountRolesPageTypeExtension {
        private Account _account;

        public GetAccountAccountRolesPageTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField(description="Gets the account's roles")
        public @GraphQLField(description="Gets the account's roles") AccountRolePage accountRoles(@GraphQLName(value="keywords") String keywords, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (AccountRolePage)Query.this._applyComponentServiceObjects(_accountRoleResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), accountRoleResource -> new AccountRolePage(accountRoleResource.getAccountAccountRolesPage(this._account.getId(), keywords, (Filter)Query.this._filterBiFunction.apply(accountRoleResource, filterString), Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(accountRoleResource, sortsString))));
        }
    }

    @GraphQLTypeExtension(value=UserAccount.class)
    public class GetUserAccountPhonesPageTypeExtension {
        private UserAccount _userAccount;

        public GetUserAccountPhonesPageTypeExtension(UserAccount userAccount) {
            this._userAccount = userAccount;
        }

        @GraphQLField(description="Retrieves the user's phone numbers.")
        public @GraphQLField(description="Retrieves the user's phone numbers.") PhonePage phones() throws Exception {
            return (PhonePage)Query.this._applyComponentServiceObjects(_phoneResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), phoneResource -> new PhonePage(phoneResource.getUserAccountPhonesPage(this._userAccount.getId())));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetAccountUserAccountsPageTypeExtension {
        private Account _account;

        public GetAccountUserAccountsPageTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField(description="Gets the users assigned to an account")
        public @GraphQLField(description="Gets the users assigned to an account") UserAccountPage userAccounts(@GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (UserAccountPage)Query.this._applyComponentServiceObjects(_userAccountResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), userAccountResource -> new UserAccountPage(userAccountResource.getAccountUserAccountsPage(this._account.getId(), search, (Filter)Query.this._filterBiFunction.apply(userAccountResource, filterString), Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(userAccountResource, sortsString))));
        }
    }
}

