/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.dto.v1_0.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.CountryModel;
import com.liferay.portal.kernel.service.CountryServiceUtil;
import java.util.Optional;

public class ServiceBuilderCountryUtil {
    private static final Log _log = LogFactoryUtil.getLog(ServiceBuilderCountryUtil.class);

    public static Country toServiceBuilderCountry(long companyId, String addressCountry) {
        try {
            Country country = CountryServiceUtil.fetchCountryByA2((long)companyId, (String)addressCountry);
            if (country != null) {
                return country;
            }
            country = CountryServiceUtil.fetchCountryByA3((long)companyId, (String)addressCountry);
            if (country != null) {
                return country;
            }
            return CountryServiceUtil.getCountryByName((long)companyId, (String)addressCountry);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            return null;
        }
    }

    public static long toServiceBuilderCountryId(long companyId, String addressCountry) {
        return Optional.ofNullable(addressCountry).map(country -> ServiceBuilderCountryUtil.toServiceBuilderCountry(companyId, country)).map(CountryModel::getCountryId).orElse(0L);
    }
}

