/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.dto.v1_0.converter;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.headless.admin.user.dto.v1_0.Account;
import com.liferay.headless.admin.user.dto.v1_0.AccountBrief;
import com.liferay.headless.admin.user.dto.v1_0.EmailAddress;
import com.liferay.headless.admin.user.dto.v1_0.OrganizationBrief;
import com.liferay.headless.admin.user.dto.v1_0.Phone;
import com.liferay.headless.admin.user.dto.v1_0.PostalAddress;
import com.liferay.headless.admin.user.dto.v1_0.RoleBrief;
import com.liferay.headless.admin.user.dto.v1_0.SiteBrief;
import com.liferay.headless.admin.user.dto.v1_0.UserAccount;
import com.liferay.headless.admin.user.dto.v1_0.UserAccountContactInformation;
import com.liferay.headless.admin.user.dto.v1_0.UserGroupBrief;
import com.liferay.headless.admin.user.dto.v1_0.WebUrl;
import com.liferay.headless.admin.user.internal.dto.v1_0.converter.UserGroupResourceDTOConverter;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.EmailAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.PhoneUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.PostalAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderListTypeUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.WebUrlUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.RoleService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"application.name=Liferay.Headless.Admin.User", "dto.class.name=com.liferay.portal.kernel.model.User", "version=v1.0"}, service={DTOConverter.class, UserResourceDTOConverter.class})
public class UserResourceDTOConverter
implements DTOConverter<User, UserAccount> {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelService;
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private GroupService _groupService;
    @Reference
    private Portal _portal;
    @Reference
    private RoleService _roleService;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserGroupResourceDTOConverter _userGroupResourceDTOConverter;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return Account.class.getSimpleName();
    }

    public User getObject(String externalReferenceCode) throws Exception {
        User user = this._userLocalService.fetchUserByExternalReferenceCode(externalReferenceCode, CompanyThreadLocal.getCompanyId().longValue());
        if (user == null) {
            user = this._userLocalService.getUser(GetterUtil.getLong((String)externalReferenceCode));
        }
        return user;
    }

    public long getUserId(String externalReferenceCode) throws Exception {
        User user = this.getObject(externalReferenceCode);
        return user.getUserId();
    }

    public UserAccount toDTO(final DTOConverterContext dtoConverterContext, final User user) throws Exception {
        if (user == null) {
            return null;
        }
        final Contact contact = user.getContact();
        return new UserAccount(){
            {
                this.accountBriefs = (AccountBrief[])TransformUtil.transformToArray((Collection)UserResourceDTOConverter.this._accountEntryUserRelService.getAccountEntryUserRelsByAccountUserId(user.getUserId()), accountEntryUserRel -> UserResourceDTOConverter.this._toAccountBrief(accountEntryUserRel, dtoConverterContext, user), AccountBrief.class);
                this.actions = dtoConverterContext.getActions();
                this.additionalName = user.getMiddleName();
                this.alternateName = user.getScreenName();
                this.birthDate = user.getBirthday();
                this.customFields = CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), User.class.getName(), user.getUserId(), user.getCompanyId(), dtoConverterContext.getLocale());
                this.dateCreated = user.getCreateDate();
                this.dateModified = user.getModifiedDate();
                this.emailAddress = user.getEmailAddress();
                this.externalReferenceCode = user.getExternalReferenceCode();
                this.familyName = user.getLastName();
                this.givenName = user.getFirstName();
                this.honorificPrefix = ServiceBuilderListTypeUtil.getServiceBuilderListTypeMessage(contact.getPrefixListTypeId(), dtoConverterContext.getLocale());
                this.honorificSuffix = ServiceBuilderListTypeUtil.getServiceBuilderListTypeMessage(contact.getSuffixListTypeId(), dtoConverterContext.getLocale());
                this.id = user.getUserId();
                this.jobTitle = user.getJobTitle();
                this.keywords = (String[])ListUtil.toArray((List)UserResourceDTOConverter.this._assetTagLocalService.getTags(User.class.getName(), user.getUserId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.lastLoginDate = user.getLastLoginDate();
                this.name = user.getFullName();
                this.organizationBriefs = (OrganizationBrief[])TransformUtil.transformToArray((Collection)user.getOrganizations(), organization -> UserResourceDTOConverter.this._toOrganizationBrief(dtoConverterContext, organization, user), OrganizationBrief.class);
                this.roleBriefs = (RoleBrief[])TransformUtil.transformToArray((Collection)UserResourceDTOConverter.this._roleService.getUserRoles(user.getUserId()), role -> UserResourceDTOConverter.this._toRoleBrief(dtoConverterContext, role), RoleBrief.class);
                this.siteBriefs = (SiteBrief[])TransformUtil.transformToArray((Collection)UserResourceDTOConverter.this._groupService.getGroups(user.getCompanyId(), 0L, true), group -> UserResourceDTOConverter.this._toSiteBrief(dtoConverterContext, group), SiteBrief.class);
                this.userAccountContactInformation = new UserAccountContactInformation(){
                    {
                        this.emailAddresses = (EmailAddress[])TransformUtil.transformToArray((Collection)user.getEmailAddresses(), EmailAddressUtil::toEmailAddress, EmailAddress.class);
                        this.facebook = contact.getFacebookSn();
                        this.jabber = contact.getJabberSn();
                        this.postalAddresses = (PostalAddress[])TransformUtil.transformToArray((Collection)user.getAddresses(), address -> PostalAddressUtil.toPostalAddress(dtoConverterContext.isAcceptAllLanguages(), address, user.getCompanyId(), dtoConverterContext.getLocale()), PostalAddress.class);
                        this.skype = contact.getSkypeSn();
                        this.sms = contact.getSmsSn();
                        this.telephones = (Phone[])TransformUtil.transformToArray((Collection)user.getPhones(), PhoneUtil::toPhone, Phone.class);
                        this.twitter = contact.getTwitterSn();
                        this.webUrls = (WebUrl[])TransformUtil.transformToArray((Collection)user.getWebsites(), WebUrlUtil::toWebUrl, WebUrl.class);
                    }
                };
                this.userGroupBriefs = (UserGroupBrief[])TransformUtil.transformToArray((Collection)UserResourceDTOConverter.this._userGroupLocalService.getUserUserGroups(user.getUserId()), userGroup -> UserResourceDTOConverter.this._toUserGroupBrief(userGroup), UserGroupBrief.class);
                this.setDashboardURL(() -> {
                    Group group = user.getGroup();
                    if (group == null) {
                        return null;
                    }
                    return group.getDisplayURL(UserResourceDTOConverter.this._getThemeDisplay(group), true);
                });
                this.setImage(() -> {
                    if (user.getPortraitId() == 0L) {
                        return null;
                    }
                    ThemeDisplay themeDisplay = new ThemeDisplay(){
                        {
                            this.setPathImage(UserResourceDTOConverter.this._portal.getPathImage());
                        }
                    };
                    return user.getPortraitURL(themeDisplay);
                });
                this.setProfileURL(() -> {
                    Group group = user.getGroup();
                    if (group == null) {
                        return null;
                    }
                    return group.getDisplayURL(UserResourceDTOConverter.this._getThemeDisplay(group));
                });
            }
        };
    }

    private ThemeDisplay _getThemeDisplay(final Group group) {
        return new ThemeDisplay(){
            {
                this.setPortalURL("");
                if (group != null) {
                    this.setSiteGroupId(group.getGroupId());
                }
            }
        };
    }

    private AccountBrief _toAccountBrief(AccountEntryUserRel accountEntryUserRel, final DTOConverterContext dtoConverterContext, final User user) throws Exception {
        if (accountEntryUserRel.getAccountEntryId() == 0L) {
            return null;
        }
        final AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryUserRel.getAccountEntryId());
        return new AccountBrief(){
            {
                this.externalReferenceCode = accountEntry.getExternalReferenceCode();
                this.id = accountEntry.getAccountEntryId();
                this.name = accountEntry.getName();
                this.roleBriefs = (RoleBrief[])TransformUtil.transformToArray((Collection)UserResourceDTOConverter.this._accountRoleLocalService.getAccountRoles(accountEntry.getAccountEntryId(), user.getUserId()), accountRole -> UserResourceDTOConverter.this._toRoleBrief(accountRole, dtoConverterContext), RoleBrief.class);
            }
        };
    }

    private OrganizationBrief _toOrganizationBrief(final DTOConverterContext dtoConverterContext, final Organization organization, final User user) throws Exception {
        return new OrganizationBrief(){
            {
                this.id = organization.getOrganizationId();
                this.name = organization.getName();
                this.roleBriefs = (RoleBrief[])TransformUtil.transformToArray((Collection)UserResourceDTOConverter.this._roleService.getUserGroupRoles(user.getUserId(), organization.getGroupId()), role -> UserResourceDTOConverter.this._toRoleBrief(dtoConverterContext, role), RoleBrief.class);
            }
        };
    }

    private RoleBrief _toRoleBrief(final AccountRole accountRole, final DTOConverterContext dtoConverterContext) throws Exception {
        final Role role = accountRole.getRole();
        return new RoleBrief(){
            {
                this.id = accountRole.getAccountRoleId();
                this.name = accountRole.getRoleName();
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)role.getTitleMap());
            }
        };
    }

    private RoleBrief _toRoleBrief(final DTOConverterContext dtoConverterContext, final Role role) {
        return new RoleBrief(){
            {
                this.id = role.getRoleId();
                this.name = role.getTitle(dtoConverterContext.getLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)role.getTitleMap());
            }
        };
    }

    private SiteBrief _toSiteBrief(final DTOConverterContext dtoConverterContext, final Group group) throws Exception {
        return new SiteBrief(){
            {
                this.descriptiveName = group.getDescriptiveName(dtoConverterContext.getLocale());
                this.descriptiveName_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)group.getDescriptiveNameMap());
                this.id = group.getGroupId();
                this.name = group.getName(dtoConverterContext.getLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)group.getNameMap());
            }
        };
    }

    private UserGroupBrief _toUserGroupBrief(final UserGroup userGroup) throws Exception {
        return new UserGroupBrief(){
            {
                this.description = userGroup.getDescription();
                this.id = userGroup.getGroupId();
                this.name = userGroup.getName();
            }
        };
    }
}

