/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.dto.v1_0.converter;

import com.liferay.headless.admin.user.dto.v1_0.Segment;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.segments.model.SegmentsEntry;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.segments.model.SegmentsEntry"}, service={DTOConverter.class, SegmentDTOConverter.class})
public class SegmentDTOConverter
implements DTOConverter<SegmentsEntry, Segment> {
    private static final Log _log = LogFactoryUtil.getLog(SegmentDTOConverter.class);
    @Reference
    private JSONFactory _jsonFactory;

    public String getContentType() {
        return SegmentsEntry.class.getSimpleName();
    }

    public Segment toDTO(final SegmentsEntry segmentsEntry) {
        return new Segment(){
            {
                this.active = segmentsEntry.isActive();
                this.dateCreated = segmentsEntry.getCreateDate();
                this.dateModified = segmentsEntry.getModifiedDate();
                this.id = segmentsEntry.getSegmentsEntryId();
                this.name = segmentsEntry.getName(segmentsEntry.getDefaultLanguageId());
                this.siteId = segmentsEntry.getGroupId();
                this.setCriteria(() -> {
                    String criteria = segmentsEntry.getCriteria();
                    if (!criteria.isEmpty()) {
                        return segmentsEntry.getCriteria();
                    }
                    return null;
                });
                this.setCriteriaValue(() -> {
                    block3: {
                        String criteria = segmentsEntry.getCriteria();
                        if (!criteria.isEmpty()) {
                            try {
                                return SegmentDTOConverter.this._toMap(SegmentDTOConverter.this._jsonFactory.createJSONObject(segmentsEntry.getCriteria()));
                            }
                            catch (JSONException jsonException) {
                                if (!_log.isWarnEnabled()) break block3;
                                _log.warn((Throwable)jsonException);
                            }
                        }
                    }
                    return null;
                });
                this.setSource(() -> {
                    if (StringUtil.equals((String)segmentsEntry.getSource(), (String)"ASAH_FARO_BACKEND")) {
                        return "Analytics Cloud";
                    }
                    if (StringUtil.equals((String)segmentsEntry.getSource(), (String)"REFERRED")) {
                        return "Liferay (Compound)";
                    }
                    return "Liferay";
                });
            }
        };
    }

    private Map<String, Object> _toMap(JSONObject jsonObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : jsonObject.keySet()) {
            if (jsonObject.getJSONObject(key) != null) {
                map.put(key, this._toMap(jsonObject.getJSONObject(key)));
                continue;
            }
            map.put(key, jsonObject.get(key));
        }
        return map;
    }
}

