/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.dto.v1_0.converter;

import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.headless.admin.user.dto.v1_0.EmailAddress;
import com.liferay.headless.admin.user.dto.v1_0.HoursAvailable;
import com.liferay.headless.admin.user.dto.v1_0.Location;
import com.liferay.headless.admin.user.dto.v1_0.Organization;
import com.liferay.headless.admin.user.dto.v1_0.OrganizationContactInformation;
import com.liferay.headless.admin.user.dto.v1_0.Phone;
import com.liferay.headless.admin.user.dto.v1_0.PostalAddress;
import com.liferay.headless.admin.user.dto.v1_0.Service;
import com.liferay.headless.admin.user.dto.v1_0.WebUrl;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.EmailAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.PhoneUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.PostalAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.WebUrlUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.EmailAddressService;
import com.liferay.portal.kernel.service.OrgLaborService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.PhoneService;
import com.liferay.portal.kernel.service.RegionService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.service.WebsiteService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.portal.kernel.model.Organization"}, service={DTOConverter.class, OrganizationResourceDTOConverter.class})
public class OrganizationResourceDTOConverter
implements DTOConverter<com.liferay.portal.kernel.model.Organization, Organization> {
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private CountryService _countryService;
    @Reference
    private EmailAddressService _emailAddressService;
    @Reference
    private Language _language;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private OrganizationService _organizationService;
    @Reference
    private OrgLaborService _orgLaborService;
    @Reference
    private PhoneService _phoneService;
    @Reference
    private RegionService _regionService;
    @Reference
    private UserService _userService;
    @Reference
    private WebsiteService _websiteService;

    public String getContentType() {
        return Organization.class.getSimpleName();
    }

    public com.liferay.portal.kernel.model.Organization getObject(String externalReferenceCode) throws Exception {
        com.liferay.portal.kernel.model.Organization organization = this._organizationLocalService.fetchOrganizationByExternalReferenceCode(externalReferenceCode, CompanyThreadLocal.getCompanyId().longValue());
        if (organization == null) {
            organization = this._organizationService.getOrganization(GetterUtil.getLong((String)externalReferenceCode));
        }
        return organization;
    }

    public Organization toDTO(final DTOConverterContext dtoConverterContext, final com.liferay.portal.kernel.model.Organization organization) throws Exception {
        if (organization == null) {
            return null;
        }
        final OrganizationResourceDTOConverter organizationResourceDTOConverter = this;
        return new Organization(){
            {
                this.actions = dtoConverterContext.getActions();
                this.comment = organization.getComments();
                this.customFields = CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), com.liferay.portal.kernel.model.Organization.class.getName(), organization.getOrganizationId(), organization.getCompanyId(), dtoConverterContext.getLocale());
                this.dateCreated = organization.getCreateDate();
                this.dateModified = organization.getModifiedDate();
                this.externalReferenceCode = organization.getExternalReferenceCode();
                this.id = String.valueOf(organization.getOrganizationId());
                this.keywords = (String[])ListUtil.toArray((List)OrganizationResourceDTOConverter.this._assetTagLocalService.getTags(organization.getModelClassName(), organization.getOrganizationId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.location = new Location(){
                    {
                        this.setAddressCountry(() -> {
                            if (organization.getCountryId() <= 0L) {
                                return null;
                            }
                            Country country = OrganizationResourceDTOConverter.this._countryService.getCountry(organization.getCountryId());
                            return country.getName(dtoConverterContext.getLocale());
                        });
                        this.setAddressCountry_i18n(() -> {
                            if (!dtoConverterContext.isAcceptAllLanguages()) {
                                return null;
                            }
                            Set locales = OrganizationResourceDTOConverter.this._language.getCompanyAvailableLocales(organization.getCompanyId());
                            Stream localesStream = locales.stream();
                            Country country = OrganizationResourceDTOConverter.this._countryService.getCountry(organization.getCountryId());
                            return localesStream.collect(Collectors.toMap(LocaleUtil::toBCP47LanguageId, arg_0 -> ((Country)country).getName(arg_0)));
                        });
                        this.setAddressRegion(() -> {
                            if (organization.getRegionId() <= 0L) {
                                return null;
                            }
                            Region region = OrganizationResourceDTOConverter.this._regionService.getRegion(organization.getRegionId());
                            return region.getName();
                        });
                    }
                };
                this.name = organization.getName();
                this.numberOfAccounts = OrganizationResourceDTOConverter.this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRelsByOrganizationIdCount(organization.getOrganizationId());
                this.numberOfOrganizations = OrganizationResourceDTOConverter.this._organizationService.getOrganizationsCount(organization.getCompanyId(), organization.getOrganizationId());
                this.numberOfUsers = OrganizationResourceDTOConverter.this._userService.getOrganizationUsersCount(organization.getOrganizationId(), -1);
                this.organizationContactInformation = new OrganizationContactInformation(){
                    {
                        this.emailAddresses = (EmailAddress[])TransformUtil.transformToArray((Collection)OrganizationResourceDTOConverter.this._emailAddressService.getEmailAddresses(organization.getModelClassName(), organization.getOrganizationId()), EmailAddressUtil::toEmailAddress, EmailAddress.class);
                        this.postalAddresses = (PostalAddress[])TransformUtil.transformToArray((Collection)organization.getAddresses(), address -> PostalAddressUtil.toPostalAddress(dtoConverterContext.isAcceptAllLanguages(), address, organization.getCompanyId(), dtoConverterContext.getLocale()), PostalAddress.class);
                        this.telephones = (Phone[])TransformUtil.transformToArray((Collection)OrganizationResourceDTOConverter.this._phoneService.getPhones(organization.getModelClassName(), organization.getOrganizationId()), PhoneUtil::toPhone, Phone.class);
                        this.webUrls = (WebUrl[])TransformUtil.transformToArray((Collection)OrganizationResourceDTOConverter.this._websiteService.getWebsites(organization.getModelClassName(), organization.getOrganizationId()), WebUrlUtil::toWebUrl, WebUrl.class);
                    }
                };
                this.parentOrganization = organizationResourceDTOConverter.toDTO(dtoConverterContext, organization.getParentOrganization());
                this.services = (Service[])TransformUtil.transformToArray((Collection)OrganizationResourceDTOConverter.this._orgLaborService.getOrgLabors(organization.getOrganizationId()), x$0 -> OrganizationResourceDTOConverter.this._toService(x$0), Service.class);
                this.setImage(() -> {
                    if (organization.getLogoId() <= 0L) {
                        return null;
                    }
                    return organization.getLogoURL();
                });
            }
        };
    }

    private HoursAvailable _createHoursAvailable(final int closeHour, final String day, final int openHour) {
        return new HoursAvailable(){
            {
                this.closes = OrganizationResourceDTOConverter.this._formatHour(closeHour);
                this.dayOfWeek = day;
                this.opens = OrganizationResourceDTOConverter.this._formatHour(openHour);
            }
        };
    }

    private String _formatHour(int hour) {
        if (hour == -1) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("00,00"){
            {
                this.setDecimalFormatSymbols(new DecimalFormatSymbols(){
                    {
                        this.setGroupingSeparator(':');
                    }
                });
                this.setGroupingSize(2);
            }
        };
        return decimalFormat.format(hour);
    }

    private Service _toService(final OrgLabor orgLabor) throws Exception {
        final ListType listType = orgLabor.getListType();
        return new Service(){
            {
                this.hoursAvailable = new HoursAvailable[]{OrganizationResourceDTOConverter.this._createHoursAvailable(orgLabor.getSunClose(), "Sunday", orgLabor.getSunOpen()), OrganizationResourceDTOConverter.this._createHoursAvailable(orgLabor.getMonClose(), "Monday", orgLabor.getMonOpen()), OrganizationResourceDTOConverter.this._createHoursAvailable(orgLabor.getTueClose(), "Tuesday", orgLabor.getTueOpen()), OrganizationResourceDTOConverter.this._createHoursAvailable(orgLabor.getWedClose(), "Wednesday", orgLabor.getWedOpen()), OrganizationResourceDTOConverter.this._createHoursAvailable(orgLabor.getThuClose(), "Thursday", orgLabor.getThuOpen()), OrganizationResourceDTOConverter.this._createHoursAvailable(orgLabor.getFriClose(), "Friday", orgLabor.getFriOpen()), OrganizationResourceDTOConverter.this._createHoursAvailable(orgLabor.getSatClose(), "Saturday", orgLabor.getSatOpen())};
                this.serviceType = listType.getName();
            }
        };
    }
}

