/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.dto.v1_0.converter;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRelModel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.headless.admin.user.dto.v1_0.Account;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"application.name=Liferay.Headless.Admin.User", "dto.class.name=com.liferay.account.model.AccountEntry", "version=v1.0"}, service={AccountResourceDTOConverter.class, DTOConverter.class})
public class AccountResourceDTOConverter
implements DTOConverter<AccountEntry, Account> {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;

    public long getAccountEntryId(String externalReferenceCode) throws Exception {
        AccountEntry accountEntry = this.getObject(externalReferenceCode);
        return accountEntry.getAccountEntryId();
    }

    public String getContentType() {
        return Account.class.getSimpleName();
    }

    public AccountEntry getObject(String externalReferenceCode) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, CompanyThreadLocal.getCompanyId().longValue());
        if (accountEntry == null) {
            accountEntry = this._accountEntryLocalService.getAccountEntry(GetterUtil.getLong((String)externalReferenceCode));
        }
        return accountEntry;
    }

    public Account toDTO(final DTOConverterContext dtoConverterContext, final AccountEntry accountEntry) {
        if (accountEntry == null) {
            return null;
        }
        return new Account(){
            {
                this.actions = dtoConverterContext.getActions();
                this.description = accountEntry.getDescription();
                this.domains = StringUtil.split((String)accountEntry.getDomains());
                this.externalReferenceCode = accountEntry.getExternalReferenceCode();
                this.id = accountEntry.getAccountEntryId();
                this.name = accountEntry.getName();
                this.numberOfUsers = (int)AccountResourceDTOConverter.this._accountEntryUserRelLocalService.getAccountEntryUserRelsCountByAccountEntryId(accountEntry.getAccountEntryId());
                this.organizationIds = (Long[])TransformUtil.transformToArray((Collection)AccountResourceDTOConverter.this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntry.getAccountEntryId()), AccountEntryOrganizationRelModel::getOrganizationId, Long.class);
                this.parentAccountId = accountEntry.getParentAccountEntryId();
                this.status = accountEntry.getStatus();
                this.type = Account.Type.create((String)accountEntry.getType());
            }
        };
    }
}

