/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.Location;
import com.liferay.headless.admin.user.dto.v1_0.Organization;
import com.liferay.headless.admin.user.dto.v1_0.OrganizationContactInformation;
import com.liferay.headless.admin.user.dto.v1_0.Service;
import com.liferay.headless.admin.user.internal.dto.v1_0.converter.OrganizationResourceDTOConverter;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderCountryUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderEmailAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderListTypeUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderPhoneUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderRegionUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderWebsiteUtil;
import com.liferay.headless.admin.user.internal.odata.entity.v1_0.OrganizationEntityModel;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseOrganizationResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.OrganizationResource;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.service.OrgLaborLocalService;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/organization.properties"}, scope=ServiceScope.PROTOTYPE, service={OrganizationResource.class})
public class OrganizationResourceImpl
extends BaseOrganizationResourceImpl
implements EntityModelResource {
    private static final Log _log = LogFactoryUtil.getLog(OrganizationResourceImpl.class);
    private static final EntityModel _entityModel = new OrganizationEntityModel();
    @Reference
    private OrganizationResourceDTOConverter _organizationResourceDTOConverter;
    @Reference
    private OrganizationService _organizationService;
    @Reference
    private OrgLaborLocalService _orgLaborLocalService;

    @Override
    public void deleteOrganization(String organizationId) throws Exception {
        long serviceBuilderOrganizationId = this._getServiceBuilderOrganizationId(organizationId);
        this._organizationService.deleteOrganization(serviceBuilderOrganizationId);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public Organization getOrganization(String organizationId) throws Exception {
        return this._toOrganization(organizationId);
    }

    @Override
    public Page<Organization> getOrganizationOrganizationsPage(String parentOrganizationId, Boolean flatten, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getOrganizationsPage(HashMapBuilder.put((Object)"get", this.addAction("VIEW", "getOrganizationOrganizationsPage", com.liferay.portal.kernel.model.Organization.class.getName(), this._getServiceBuilderOrganizationId(parentOrganizationId))).build(), parentOrganizationId, flatten, filter, search, pagination, sorts);
    }

    @Override
    public Page<Organization> getOrganizationsPage(Boolean flatten, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getOrganizationsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_ORGANIZATION", "postOrganization", com.liferay.portal.kernel.model.Organization.class.getName(), 0L)).put((Object)"get", this.addAction("VIEW", "getOrganizationsPage", com.liferay.portal.kernel.model.Organization.class.getName(), 0L)).build(), null, flatten, filter, search, pagination, sorts);
    }

    @Override
    public Organization postOrganization(Organization organization) throws Exception {
        long countryId = this._getCountryId(organization);
        com.liferay.portal.kernel.model.Organization serviceBuilderOrganization = this._organizationService.addOrganization(this._getDefaultParentOrganizationId(organization), organization.getName(), "organization", this._getRegionId(organization, countryId), countryId, (long)ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, organization.getComment(), false, this._getAddresses(organization), this._getEmailAddresses(organization), this._getOrgLabors(organization), this._getPhones(organization), this._getWebsites(organization), ServiceContextFactory.getInstance((HttpServletRequest)this.contextHttpServletRequest));
        return this._organizationResourceDTOConverter.toDTO((DTOConverterContext)this._getDTOConverterContext(String.valueOf(serviceBuilderOrganization)), serviceBuilderOrganization);
    }

    @Override
    public Organization putOrganization(String organizationId, Organization organization) throws Exception {
        com.liferay.portal.kernel.model.Organization serviceBuilderOrganization = this._organizationResourceDTOConverter.getObject(organizationId);
        long countryId = this._getCountryId(organization);
        Group group = serviceBuilderOrganization.getGroup();
        return this._organizationResourceDTOConverter.toDTO((DTOConverterContext)this._getDTOConverterContext(organizationId), this._organizationService.updateOrganization(serviceBuilderOrganization.getOrganizationId(), this._getDefaultParentOrganizationId(organization), organization.getName(), serviceBuilderOrganization.getType(), this._getRegionId(organization, countryId), countryId, serviceBuilderOrganization.getStatusId(), organization.getComment(), false, null, group.isSite(), this._getAddresses(organization), this._getEmailAddresses(organization), this._getOrgLabors(organization), this._getPhones(organization), this._getWebsites(organization), ServiceContextFactory.getInstance((HttpServletRequest)this.contextHttpServletRequest)));
    }

    @Override
    protected void preparePatch(Organization organization, Organization existingOrganization) {
        OrganizationContactInformation organizationContactInformation = organization.getOrganizationContactInformation();
        if (organizationContactInformation != null) {
            OrganizationContactInformation existingOrganizationContactInformation = existingOrganization.getOrganizationContactInformation();
            if (organizationContactInformation.getEmailAddresses() != null) {
                existingOrganizationContactInformation.setEmailAddresses(organizationContactInformation.getEmailAddresses());
            }
            if (organizationContactInformation.getPostalAddresses() != null) {
                existingOrganizationContactInformation.setPostalAddresses(organizationContactInformation.getPostalAddresses());
            }
            if (organizationContactInformation.getTelephones() != null) {
                existingOrganizationContactInformation.setTelephones(organizationContactInformation.getTelephones());
            }
            if (organizationContactInformation.getWebUrls() != null) {
                existingOrganizationContactInformation.setWebUrls(organizationContactInformation.getWebUrls());
            }
        }
        if (organization.getServices() != null) {
            existingOrganization.setServices(organization.getServices());
        }
    }

    private List<Address> _getAddresses(Organization organization) {
        return Optional.ofNullable(organization.getOrganizationContactInformation()).map(OrganizationContactInformation::getPostalAddresses).map(postalAddresses -> ListUtil.filter(this.transformToList((T[])postalAddresses, _postalAddress -> ServiceBuilderAddressUtil.toServiceBuilderAddress(_postalAddress, ListTypeConstants.ORGANIZATION_ADDRESS)), Objects::nonNull)).orElse(Collections.emptyList());
    }

    private long _getCountryId(Organization organization) {
        return Optional.ofNullable(organization.getLocation()).map(Location::getAddressCountry).map(ServiceBuilderCountryUtil::toServiceBuilderCountryId).orElse(0L);
    }

    private long _getDefaultParentOrganizationId(Organization organization) {
        return Optional.ofNullable(organization.getParentOrganization()).map(Organization::getId).map(Long::valueOf).orElse(0L);
    }

    private DefaultDTOConverterContext _getDTOConverterContext(String organizationId) throws Exception {
        Long serviceBuilderOrganizationId = this._getServiceBuilderOrganizationId(organizationId);
        return new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", "deleteOrganization", com.liferay.portal.kernel.model.Organization.class.getName(), serviceBuilderOrganizationId)).put((Object)"get", this.addAction("VIEW", "getOrganization", com.liferay.portal.kernel.model.Organization.class.getName(), serviceBuilderOrganizationId)).put((Object)"replace", this.addAction("UPDATE", "putOrganization", com.liferay.portal.kernel.model.Organization.class.getName(), serviceBuilderOrganizationId)).put((Object)"update", this.addAction("UPDATE", "patchOrganization", com.liferay.portal.kernel.model.Organization.class.getName(), serviceBuilderOrganizationId)).build(), null, (Object)organizationId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser);
    }

    private List<EmailAddress> _getEmailAddresses(Organization organization) {
        return Optional.ofNullable(organization.getOrganizationContactInformation()).map(OrganizationContactInformation::getEmailAddresses).map(emailAddresses -> ListUtil.filter(this.transformToList((T[])emailAddresses, emailAddress -> ServiceBuilderEmailAddressUtil.toServiceBuilderEmailAddress(emailAddress, ListTypeConstants.ORGANIZATION_EMAIL_ADDRESS)), Objects::nonNull)).orElse(Collections.emptyList());
    }

    private Page<Organization> _getOrganizationsPage(Map<String, Map<String, String>> actions, String parentOrganizationId, Boolean flatten, Filter filter, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        long serviceBuilderOrganizationId = this._getServiceBuilderOrganizationId(parentOrganizationId);
        return SearchUtil.search(actions, booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            if (GetterUtil.getBoolean((Object)flatten)) {
                if (serviceBuilderOrganizationId != 0L) {
                    booleanFilter.add((Filter)new QueryFilter((Query)new WildcardQueryImpl("treePath", "*" + parentOrganizationId + "*")));
                    booleanFilter.add((Filter)new TermFilter("organizationId", String.valueOf(parentOrganizationId)), BooleanClauseOccur.MUST_NOT);
                }
            } else {
                booleanFilter.add((Filter)new TermFilter("parentOrganizationId", String.valueOf(serviceBuilderOrganizationId)), BooleanClauseOccur.MUST);
            }
        }, (Filter)filter, com.liferay.portal.kernel.model.Organization.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toOrganization(GetterUtil.getString((String)document.get("entryClassPK"))));
    }

    private List<OrgLabor> _getOrgLabors(Organization organization) {
        return Optional.ofNullable(organization.getServices()).map(services -> ListUtil.filter(this.transformToList((T[])services, this::_toOrgLabor), Objects::nonNull)).orElse(Collections.emptyList());
    }

    private List<Phone> _getPhones(Organization organization) {
        return Optional.ofNullable(organization.getOrganizationContactInformation()).map(OrganizationContactInformation::getTelephones).map(telephones -> ListUtil.filter(this.transformToList((T[])telephones, telephone -> ServiceBuilderPhoneUtil.toServiceBuilderPhone(telephone, ListTypeConstants.ORGANIZATION_PHONE)), Objects::nonNull)).orElse(Collections.emptyList());
    }

    private long _getRegionId(Organization organization, long countryId) {
        return Optional.ofNullable(organization.getLocation()).map(Location::getAddressRegion).map(addressRegion -> ServiceBuilderRegionUtil.getServiceBuilderRegionId(addressRegion, countryId)).orElse(0L);
    }

    private long _getServiceBuilderOrganizationId(String organizationId) throws Exception {
        if (organizationId == null) {
            return 0L;
        }
        com.liferay.portal.kernel.model.Organization serviceBuilderOrganization = this._organizationResourceDTOConverter.getObject(organizationId);
        if (serviceBuilderOrganization == null) {
            return GetterUtil.getLong((String)organizationId);
        }
        return serviceBuilderOrganization.getOrganizationId();
    }

    private List<Website> _getWebsites(Organization organization) {
        return Optional.ofNullable(organization.getOrganizationContactInformation()).map(OrganizationContactInformation::getWebUrls).map(webUrls -> ListUtil.filter(this.transformToList((T[])webUrls, webUrl -> ServiceBuilderWebsiteUtil.toServiceBuilderWebsite(ListTypeConstants.ORGANIZATION_WEBSITE, webUrl)), Objects::nonNull)).orElse(Collections.emptyList());
    }

    private Organization _toOrganization(String organizationId) throws Exception {
        return (Organization)this._organizationResourceDTOConverter.toDTO((DTOConverterContext)this._getDTOConverterContext(organizationId));
    }

    private OrgLabor _toOrgLabor(Service service) {
        long typeId = ServiceBuilderListTypeUtil.toServiceBuilderListTypeId("administrative", service.getServiceType(), ListTypeConstants.ORGANIZATION_SERVICE);
        if (typeId == -1L) {
            return null;
        }
        OrgLabor orgLabor = this._orgLaborLocalService.createOrgLabor(0L);
        orgLabor.setTypeId(typeId);
        Object[] hoursAvailableArray = service.getHoursAvailable();
        if (ArrayUtil.isEmpty((Object[])hoursAvailableArray)) {
            return null;
        }
        orgLabor.setSunOpen(-1);
        orgLabor.setSunClose(-1);
        orgLabor.setMonOpen(-1);
        orgLabor.setMonClose(-1);
        orgLabor.setTueOpen(-1);
        orgLabor.setTueClose(-1);
        orgLabor.setWedOpen(-1);
        orgLabor.setWedClose(-1);
        orgLabor.setThuOpen(-1);
        orgLabor.setThuClose(-1);
        orgLabor.setFriOpen(-1);
        orgLabor.setFriClose(-1);
        orgLabor.setSatOpen(-1);
        orgLabor.setSatClose(-1);
        for (Object hoursAvailable : hoursAvailableArray) {
            String dayOfWeek = hoursAvailable.getDayOfWeek();
            if (Validator.isNull((String)dayOfWeek)) continue;
            dayOfWeek = StringUtil.toLowerCase((String)dayOfWeek);
            int opens = this._toTime(hoursAvailable.getOpens());
            int closes = this._toTime(hoursAvailable.getCloses());
            if (dayOfWeek.startsWith("sun")) {
                orgLabor.setSunOpen(opens);
                orgLabor.setSunClose(closes);
                continue;
            }
            if (dayOfWeek.startsWith("mon")) {
                orgLabor.setMonOpen(opens);
                orgLabor.setMonClose(closes);
                continue;
            }
            if (dayOfWeek.startsWith("tue")) {
                orgLabor.setTueOpen(opens);
                orgLabor.setTueClose(closes);
                continue;
            }
            if (dayOfWeek.startsWith("wed")) {
                orgLabor.setWedOpen(opens);
                orgLabor.setWedClose(closes);
                continue;
            }
            if (dayOfWeek.startsWith("thu")) {
                orgLabor.setThuOpen(opens);
                orgLabor.setThuClose(closes);
                continue;
            }
            if (dayOfWeek.startsWith("fri")) {
                orgLabor.setFriOpen(opens);
                orgLabor.setFriClose(closes);
                continue;
            }
            if (!dayOfWeek.startsWith("sat")) continue;
            orgLabor.setSatOpen(opens);
            orgLabor.setSatClose(closes);
        }
        return orgLabor;
    }

    private int _toTime(String timeString) {
        if (Validator.isNull((String)timeString)) {
            return -1;
        }
        Date date = null;
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"HH:mm");
        try {
            date = dateFormat.parse(timeString);
        }
        catch (ParseException parseException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)parseException, (Throwable)parseException);
            }
            return -1;
        }
        Format format = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"HHmm");
        return GetterUtil.getInteger((String)format.format(date));
    }
}

