/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.Role;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseRoleResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.RoleResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.RoleAssignmentException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.role.RoleConstants;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.RoleService;
import com.liferay.portal.kernel.service.UserGroupRoleService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/role.properties"}, scope=ServiceScope.PROTOTYPE, service={RoleResource.class})
public class RoleResourceImpl
extends BaseRoleResourceImpl {
    @Reference
    private OrganizationService _organizationService;
    @Reference
    private Portal _portal;
    @Reference
    private RoleService _roleService;
    @Reference
    private UserGroupRoleService _userGroupRoleService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UserService _userService;

    @Override
    public void deleteOrganizationRoleUserAccountAssociation(Long roleId, Long userAccountId, Long organizationId) throws Exception {
        this._checkRoleType(roleId, 3);
        Organization organization = this._organizationService.getOrganization(organizationId.longValue());
        this._userGroupRoleService.deleteUserGroupRoles(userAccountId.longValue(), organization.getGroupId(), new long[]{roleId});
    }

    @Override
    public void deleteRoleUserAccountAssociation(Long roleId, Long userAccountId) throws Exception {
        this._userService.deleteRoleUser(roleId.longValue(), userAccountId.longValue());
    }

    @Override
    public void deleteSiteRoleUserAccountAssociation(Long roleId, Long userAccountId, Long siteId) throws Exception {
        this._checkRoleType(roleId, 2);
        this._userGroupRoleService.deleteUserGroupRoles(userAccountId.longValue(), siteId.longValue(), new long[]{roleId});
    }

    @Override
    public Role getRole(Long roleId) throws Exception {
        com.liferay.portal.kernel.model.Role role = this._roleService.fetchRole(roleId.longValue());
        if (role == null) {
            throw new NoSuchRoleException("No role exists with role ID " + roleId);
        }
        return this._toRole(this._roleService.getRole(roleId.longValue()));
    }

    @Override
    public Page<Role> getRolesPage(Pagination pagination) throws Exception {
        Integer[] types = new Integer[]{3, 1, 2};
        return Page.of(this.transform(this._roleService.search(this.contextCompany.getCompanyId(), null, types, null, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toRole), (Pagination)pagination, (long)this._roleService.searchCount(this.contextCompany.getCompanyId(), null, types, null));
    }

    @Override
    public void postOrganizationRoleUserAccountAssociation(Long roleId, Long userAccountId, Long organizationId) throws Exception {
        this._checkRoleType(roleId, 3);
        Organization organization = this._organizationService.getOrganization(organizationId.longValue());
        this._userGroupRoleService.addUserGroupRoles(userAccountId.longValue(), organization.getGroupId(), new long[]{roleId});
    }

    @Override
    public void postRoleUserAccountAssociation(Long roleId, Long userAccountId) throws Exception {
        this._checkRoleType(roleId, 1);
        this._userService.addRoleUsers(roleId.longValue(), new long[]{userAccountId});
    }

    @Override
    public void postSiteRoleUserAccountAssociation(Long roleId, Long userAccountId, Long siteId) throws Exception {
        this._checkRoleType(roleId, 2);
        this._userGroupRoleService.addUserGroupRoles(userAccountId.longValue(), siteId.longValue(), new long[]{roleId});
    }

    private void _checkRoleType(long roleId, int type) throws Exception {
        com.liferay.portal.kernel.model.Role serviceBuilderRole = this._roleService.getRole(roleId);
        if (serviceBuilderRole.getType() != type) {
            throw new RoleAssignmentException(StringBundler.concat((String[])new String[]{"Role type ", RoleConstants.getTypeLabel((int)serviceBuilderRole.getType()), " is not role type ", RoleConstants.getTypeLabel((int)type)}));
        }
    }

    private Role _toRole(final com.liferay.portal.kernel.model.Role role) throws Exception {
        return new Role(){
            {
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])role.getAvailableLanguageIds());
                this.creator = CreatorUtil.toCreator(RoleResourceImpl.this._portal, RoleResourceImpl.this._userLocalService.fetchUser(role.getUserId()));
                this.dateCreated = role.getCreateDate();
                this.dateModified = role.getModifiedDate();
                this.description = role.getDescription(RoleResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)RoleResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)role.getDescriptionMap());
                this.id = role.getRoleId();
                this.name = role.getTitle(RoleResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)RoleResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)role.getTitleMap());
                this.roleType = role.getTypeLabel();
            }
        };
    }
}

