/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.UserAccount;
import com.liferay.headless.admin.user.resource.v1_0.UserAccountResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseUserAccountResourceImpl
implements UserAccountResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<UserAccount> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;

    @GET
    @Operation(description="Retrieves information about the user who made the request.")
    @Path(value="/my-user-account")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="UserAccount")})
    public UserAccount getMyUserAccount() throws Exception {
        return new UserAccount();
    }

    @GET
    @Operation(description="Retrieves the organization's members (users). Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/organizations/{organizationId}/user-accounts")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="UserAccount")})
    public Page<UserAccount> getOrganizationUserAccountsPage(@NotNull @Parameter(hidden=true) @PathParam(value="organizationId") String organizationId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @GET
    @Operation(description="Retrieves the site members' user accounts. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/user-accounts")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="UserAccount")})
    public Page<UserAccount> getSiteUserAccountsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @GET
    @Operation(description="Retrieves the user accounts. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/user-accounts")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="UserAccount")})
    public Page<UserAccount> getUserAccountsPage(@Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new user account")
    @POST
    @Path(value="/user-accounts")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={})
    public UserAccount postUserAccount(UserAccount userAccount) throws Exception {
        return new UserAccount();
    }

    @Consumes(value={"application/json"})
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/user-accounts/batch")
    @Produces(value={"application/json"})
    @Tags(value={})
    public Response postUserAccountBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(UserAccount.class.getName(), callbackURL, null, object)).build();
    }

    @DELETE
    @Operation(description="Deletes the user account")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userAccountId")})
    @Path(value="/user-accounts/{userAccountId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="UserAccount")})
    public void deleteUserAccount(@NotNull @Parameter(hidden=true) @PathParam(value="userAccountId") Long userAccountId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/user-accounts/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="UserAccount")})
    public Response deleteUserAccountBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(UserAccount.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Operation(description="Retrieves the user account.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userAccountId")})
    @Path(value="/user-accounts/{userAccountId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="UserAccount")})
    public UserAccount getUserAccount(@NotNull @Parameter(hidden=true) @PathParam(value="userAccountId") Long userAccountId) throws Exception {
        return new UserAccount();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates the user account with information sent in the request body. Only the provided fields are updated.")
    @PATCH
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userAccountId")})
    @Path(value="/user-accounts/{userAccountId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={})
    public UserAccount patchUserAccount(@NotNull @Parameter(hidden=true) @PathParam(value="userAccountId") Long userAccountId, UserAccount userAccount) throws Exception {
        UserAccount existingUserAccount = this.getUserAccount(userAccountId);
        if (userAccount.getActions() != null) {
            existingUserAccount.setActions(userAccount.getActions());
        }
        if (userAccount.getAdditionalName() != null) {
            existingUserAccount.setAdditionalName(userAccount.getAdditionalName());
        }
        if (userAccount.getAlternateName() != null) {
            existingUserAccount.setAlternateName(userAccount.getAlternateName());
        }
        if (userAccount.getBirthDate() != null) {
            existingUserAccount.setBirthDate(userAccount.getBirthDate());
        }
        if (userAccount.getDashboardURL() != null) {
            existingUserAccount.setDashboardURL(userAccount.getDashboardURL());
        }
        if (userAccount.getDateCreated() != null) {
            existingUserAccount.setDateCreated(userAccount.getDateCreated());
        }
        if (userAccount.getDateModified() != null) {
            existingUserAccount.setDateModified(userAccount.getDateModified());
        }
        if (userAccount.getFamilyName() != null) {
            existingUserAccount.setFamilyName(userAccount.getFamilyName());
        }
        if (userAccount.getGivenName() != null) {
            existingUserAccount.setGivenName(userAccount.getGivenName());
        }
        if (userAccount.getHonorificPrefix() != null) {
            existingUserAccount.setHonorificPrefix(userAccount.getHonorificPrefix());
        }
        if (userAccount.getHonorificSuffix() != null) {
            existingUserAccount.setHonorificSuffix(userAccount.getHonorificSuffix());
        }
        if (userAccount.getImage() != null) {
            existingUserAccount.setImage(userAccount.getImage());
        }
        if (userAccount.getJobTitle() != null) {
            existingUserAccount.setJobTitle(userAccount.getJobTitle());
        }
        if (userAccount.getKeywords() != null) {
            existingUserAccount.setKeywords(userAccount.getKeywords());
        }
        if (userAccount.getName() != null) {
            existingUserAccount.setName(userAccount.getName());
        }
        if (userAccount.getProfileURL() != null) {
            existingUserAccount.setProfileURL(userAccount.getProfileURL());
        }
        this.preparePatch(userAccount, existingUserAccount);
        return this.putUserAccount(userAccountId, existingUserAccount);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the user account with information sent in the request body. Any missing fields are deleted unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="userAccountId")})
    @Path(value="/user-accounts/{userAccountId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={})
    public UserAccount putUserAccount(@NotNull @Parameter(hidden=true) @PathParam(value="userAccountId") Long userAccountId, UserAccount userAccount) throws Exception {
        return new UserAccount();
    }

    @Consumes(value={"application/json"})
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/user-accounts/batch")
    @Produces(value={"application/json"})
    @Tags(value={})
    public Response putUserAccountBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(UserAccount.class.getName(), callbackURL, object)).build();
    }

    public void create(Collection<UserAccount> userAccounts, Map<String, Serializable> parameters) throws Exception {
        for (UserAccount userAccount : userAccounts) {
            this.postUserAccount(userAccount);
        }
    }

    public void delete(Collection<UserAccount> userAccounts, Map<String, Serializable> parameters) throws Exception {
        for (UserAccount userAccount : userAccounts) {
            this.deleteUserAccount(userAccount.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<UserAccount> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getSiteUserAccountsPage((Long)parameters.get("siteId"), search, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<UserAccount> userAccounts, Map<String, Serializable> parameters) throws Exception {
        for (UserAccount userAccount : userAccounts) {
            this.putUserAccount(userAccount.getId() != null ? userAccount.getId() : (Long)parameters.get("userAccountId"), userAccount);
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(UserAccount userAccount, UserAccount existingUserAccount) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

