/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.announcements.kernel.service.AnnouncementsDeliveryLocalService;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.headless.admin.user.dto.v1_0.OrganizationBrief;
import com.liferay.headless.admin.user.dto.v1_0.Phone;
import com.liferay.headless.admin.user.dto.v1_0.PostalAddress;
import com.liferay.headless.admin.user.dto.v1_0.RoleBrief;
import com.liferay.headless.admin.user.dto.v1_0.SiteBrief;
import com.liferay.headless.admin.user.dto.v1_0.UserAccount;
import com.liferay.headless.admin.user.dto.v1_0.UserAccountContactInformation;
import com.liferay.headless.admin.user.dto.v1_0.WebUrl;
import com.liferay.headless.admin.user.internal.dto.v1_0.converter.OrganizationResourceDTOConverter;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.EmailAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.PhoneUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.PostalAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderEmailAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderListTypeUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderPhoneUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderWebsiteUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.WebUrlUtil;
import com.liferay.headless.admin.user.internal.odata.entity.v1_0.UserAccountEntityModel;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseUserAccountResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.UserAccountResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ContactLocalService;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.RoleService;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/user-account.properties"}, scope=ServiceScope.PROTOTYPE, service={UserAccountResource.class})
public class UserAccountResourceImpl
extends BaseUserAccountResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new UserAccountEntityModel();
    @Reference
    private AnnouncementsDeliveryLocalService _announcementsDeliveryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private ContactLocalService _contactLocalService;
    @Reference
    private GroupService _groupService;
    @Reference
    private OrganizationResourceDTOConverter _organizationResourceDTOConverter;
    @Reference
    private Portal _portal;
    @Reference
    private RoleService _roleService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserService _userService;

    @Override
    public void deleteUserAccount(Long userAccountId) throws Exception {
        this._userService.deleteUser(userAccountId.longValue());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public UserAccount getMyUserAccount() throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        return this._toUserAccount(this._userService.getUserById(permissionChecker.getUserId()));
    }

    @Override
    public Page<UserAccount> getOrganizationUserAccountsPage(Long organizationId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Organization organization = this._organizationResourceDTOConverter.getObject(String.valueOf(organizationId));
        return this._getUserAccountsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("organizationIds", String.valueOf(organization.getOrganizationId())), BooleanClauseOccur.MUST);
        }), search, filter, pagination, sorts);
    }

    @Override
    public Page<UserAccount> getSiteUserAccountsPage(Long siteId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getUserAccountsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("groupId", String.valueOf(siteId)), BooleanClauseOccur.MUST);
        }), search, filter, pagination, sorts);
    }

    @Override
    public UserAccount getUserAccount(Long userAccountId) throws Exception {
        return this._toUserAccount(this._userService.getUserById(userAccountId.longValue()));
    }

    @Override
    public Page<UserAccount> getUserAccountsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(this.contextCompany.getCompanyId())) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker);
        }
        return this._getUserAccountsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("userName", ""), BooleanClauseOccur.MUST_NOT);
        }), search, filter, pagination, sorts);
    }

    @Override
    public UserAccount postUserAccount(UserAccount userAccount) throws Exception {
        User user = this._userService.addUser(this.contextCompany.getCompanyId(), true, null, null, false, userAccount.getAlternateName(), userAccount.getEmailAddress(), 0L, null, this.contextAcceptLanguage.getPreferredLocale(), userAccount.getGivenName(), userAccount.getAdditionalName(), userAccount.getFamilyName(), this._getPrefixId(userAccount), this._getSuffixId(userAccount), true, this._getBirthdayMonth(userAccount), this._getBirthdayDay(userAccount), this._getBirthdayYear(userAccount), userAccount.getJobTitle(), new long[0], new long[0], new long[0], new long[0], this._getAddresses(userAccount), this._getServiceBuilderEmailAddresses(userAccount), this._getServiceBuilderPhones(userAccount), this._getWebsites(userAccount), Collections.emptyList(), false, ServiceContextFactory.getInstance((HttpServletRequest)this.contextHttpServletRequest));
        UserAccountContactInformation userAccountContactInformation = userAccount.getUserAccountContactInformation();
        if (userAccountContactInformation != null) {
            Contact contact = user.getContact();
            contact.setSmsSn(userAccountContactInformation.getSms());
            contact.setFacebookSn(userAccountContactInformation.getFacebook());
            contact.setJabberSn(userAccountContactInformation.getJabber());
            contact.setSkypeSn(userAccountContactInformation.getSkype());
            contact.setTwitterSn(userAccountContactInformation.getTwitter());
            this._contactLocalService.updateContact(contact);
            user = this._userService.getUserById(user.getUserId());
        }
        return this._toUserAccount(user);
    }

    @Override
    public UserAccount putUserAccount(Long userAccountId, UserAccount userAccount) throws Exception {
        User user = this._userService.getUserById(userAccountId.longValue());
        String sms = null;
        String facebook = null;
        String jabber = null;
        String skype = null;
        String twitter = null;
        UserAccountContactInformation userAccountContactInformation = userAccount.getUserAccountContactInformation();
        if (userAccountContactInformation != null) {
            sms = userAccountContactInformation.getSms();
            facebook = userAccountContactInformation.getFacebook();
            jabber = userAccountContactInformation.getJabber();
            skype = userAccountContactInformation.getSkype();
            twitter = userAccountContactInformation.getTwitter();
        }
        return this._toUserAccount(this._userService.updateUser(userAccountId.longValue(), null, null, null, false, null, null, userAccount.getAlternateName(), userAccount.getEmailAddress(), user.getFacebookId(), user.getOpenId(), false, null, user.getLanguageId(), user.getTimeZoneId(), user.getGreeting(), user.getComments(), userAccount.getGivenName(), userAccount.getAdditionalName(), userAccount.getFamilyName(), this._getPrefixId(userAccount), this._getSuffixId(userAccount), true, this._getBirthdayMonth(userAccount), this._getBirthdayDay(userAccount), this._getBirthdayYear(userAccount), sms, facebook, jabber, skype, twitter, userAccount.getJobTitle(), user.getGroupIds(), user.getOrganizationIds(), user.getRoleIds(), this._userGroupRoleLocalService.getUserGroupRoles(userAccountId.longValue()), user.getUserGroupIds(), this._getAddresses(userAccount), this._getServiceBuilderEmailAddresses(userAccount), this._getServiceBuilderPhones(userAccount), this._getWebsites(userAccount), this._announcementsDeliveryLocalService.getUserDeliveries(userAccountId.longValue()), ServiceContextFactory.getInstance((HttpServletRequest)this.contextHttpServletRequest)));
    }

    @Override
    protected void preparePatch(UserAccount userAccount, UserAccount existingUserAccount) {
        UserAccountContactInformation userAccountContactInformation = userAccount.getUserAccountContactInformation();
        if (userAccountContactInformation != null) {
            UserAccountContactInformation existingUserAccountContactInformation = existingUserAccount.getUserAccountContactInformation();
            Optional.ofNullable(userAccountContactInformation.getEmailAddresses()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setEmailAddresses(arg_0));
            Optional.ofNullable(userAccountContactInformation.getFacebook()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setFacebook(arg_0));
            Optional.ofNullable(userAccountContactInformation.getJabber()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setJabber(arg_0));
            Optional.ofNullable(userAccountContactInformation.getPostalAddresses()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setPostalAddresses(arg_0));
            Optional.ofNullable(userAccountContactInformation.getSkype()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setSkype(arg_0));
            Optional.ofNullable(userAccountContactInformation.getSms()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setSms(arg_0));
            Optional.ofNullable(userAccountContactInformation.getTelephones()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setTelephones(arg_0));
            Optional.ofNullable(userAccountContactInformation.getTwitter()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setTwitter(arg_0));
            Optional.ofNullable(userAccountContactInformation.getWebUrls()).ifPresent(arg_0 -> ((UserAccountContactInformation)existingUserAccountContactInformation).setWebUrls(arg_0));
        }
    }

    private List<Address> _getAddresses(UserAccount userAccount) {
        return Optional.ofNullable(userAccount.getUserAccountContactInformation()).map(UserAccountContactInformation::getPostalAddresses).map(postalAddresses -> ListUtil.filter(this.transformToList((T[])postalAddresses, _postalAddress -> ServiceBuilderAddressUtil.toServiceBuilderAddress(_postalAddress, ListTypeConstants.CONTACT_ADDRESS)), Objects::nonNull)).orElse(Collections.emptyList());
    }

    private int _getBirthdayDay(UserAccount userAccount) {
        return this._getCalendarFieldValue(userAccount, 5, 1);
    }

    private int _getBirthdayMonth(UserAccount userAccount) {
        return this._getCalendarFieldValue(userAccount, 2, 0);
    }

    private int _getBirthdayYear(UserAccount userAccount) {
        return this._getCalendarFieldValue(userAccount, 1, 1977);
    }

    private int _getCalendarFieldValue(UserAccount userAccount, int calendarField, int defaultValue) {
        return Optional.ofNullable(userAccount.getBirthDate()).map(date -> {
            Calendar calendar = CalendarFactoryUtil.getCalendar();
            calendar.setTime((Date)date);
            return calendar.get(calendarField);
        }).orElse(defaultValue);
    }

    private long _getPrefixId(UserAccount userAccount) {
        return Optional.ofNullable(userAccount.getHonorificPrefix()).map(prefix -> ServiceBuilderListTypeUtil.getServiceBuilderListTypeId(ListTypeConstants.CONTACT_PREFIX, prefix)).orElse(0L);
    }

    private List<EmailAddress> _getServiceBuilderEmailAddresses(UserAccount userAccount) {
        return Optional.ofNullable(userAccount.getUserAccountContactInformation()).map(UserAccountContactInformation::getEmailAddresses).map(emailAddresses -> ListUtil.filter(this.transformToList((T[])emailAddresses, emailAddress -> ServiceBuilderEmailAddressUtil.toServiceBuilderEmailAddress(emailAddress, ListTypeConstants.CONTACT_EMAIL_ADDRESS)), Objects::nonNull)).orElse(Collections.emptyList());
    }

    private List<com.liferay.portal.kernel.model.Phone> _getServiceBuilderPhones(UserAccount userAccount) {
        return Optional.ofNullable(userAccount.getUserAccountContactInformation()).map(UserAccountContactInformation::getTelephones).map(telephones -> ListUtil.filter(this.transformToList((T[])telephones, telephone -> ServiceBuilderPhoneUtil.toServiceBuilderPhone(telephone, ListTypeConstants.CONTACT_PHONE)), Objects::nonNull)).orElse(Collections.emptyList());
    }

    private long _getSuffixId(UserAccount userAccount) {
        return Optional.ofNullable(userAccount.getHonorificSuffix()).map(prefix -> ServiceBuilderListTypeUtil.getServiceBuilderListTypeId(ListTypeConstants.CONTACT_SUFFIX, prefix)).orElse(0L);
    }

    private ThemeDisplay _getThemeDisplay(final Group group) {
        return new ThemeDisplay(){
            {
                this.setPortalURL("");
                this.setSiteGroupId(group.getGroupId());
            }
        };
    }

    private Page<UserAccount> _getUserAccountsPage(UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQueryUnsafeConsumer, (Filter)filter, User.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), document -> this._toUserAccount(this._userService.getUserById(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    private List<Website> _getWebsites(UserAccount userAccount) {
        return Optional.ofNullable(userAccount.getUserAccountContactInformation()).map(UserAccountContactInformation::getWebUrls).map(webUrls -> ListUtil.filter(this.transformToList((T[])webUrls, webUrl -> ServiceBuilderWebsiteUtil.toServiceBuilderWebsite(ListTypeConstants.CONTACT_WEBSITE, webUrl)), Objects::nonNull)).orElse(Collections.emptyList());
    }

    private OrganizationBrief _toOrganizationBrief(final Organization organization) {
        return new OrganizationBrief(){
            {
                this.id = organization.getOrganizationId();
                this.name = organization.getName();
            }
        };
    }

    private RoleBrief _toRoleBrief(final Role role) {
        return new RoleBrief(){
            {
                this.id = role.getRoleId();
                this.name = role.getTitle(UserAccountResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)UserAccountResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)role.getTitleMap());
            }
        };
    }

    private SiteBrief _toSiteBrief(final Group group) {
        return new SiteBrief(){
            {
                this.id = group.getGroupId();
                this.name = group.getName(UserAccountResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)UserAccountResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)group.getNameMap());
            }
        };
    }

    private UserAccount _toUserAccount(final User user) throws Exception {
        final Contact contact = user.getContact();
        return new UserAccount(){
            {
                this.additionalName = user.getMiddleName();
                this.alternateName = user.getScreenName();
                this.birthDate = user.getBirthday();
                this.customFields = CustomFieldsUtil.toCustomFields(UserAccountResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), User.class.getName(), user.getUserId(), user.getCompanyId(), UserAccountResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.dateCreated = user.getCreateDate();
                this.dateModified = user.getModifiedDate();
                this.emailAddress = user.getEmailAddress();
                this.familyName = user.getLastName();
                this.givenName = user.getFirstName();
                this.honorificPrefix = ServiceBuilderListTypeUtil.getServiceBuilderListTypeMessage(contact.getPrefixId(), UserAccountResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.honorificSuffix = ServiceBuilderListTypeUtil.getServiceBuilderListTypeMessage(contact.getSuffixId(), UserAccountResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.id = user.getUserId();
                this.jobTitle = user.getJobTitle();
                this.keywords = (String[])ListUtil.toArray((List)UserAccountResourceImpl.this._assetTagLocalService.getTags(User.class.getName(), user.getUserId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.name = user.getFullName();
                this.organizationBriefs = (OrganizationBrief[])UserAccountResourceImpl.this.transformToArray(user.getOrganizations(), organization -> UserAccountResourceImpl.this._toOrganizationBrief(organization), OrganizationBrief.class);
                this.roleBriefs = (RoleBrief[])UserAccountResourceImpl.this.transformToArray(UserAccountResourceImpl.this._roleService.getUserRoles(user.getUserId()), role -> UserAccountResourceImpl.this._toRoleBrief(role), RoleBrief.class);
                this.siteBriefs = (SiteBrief[])UserAccountResourceImpl.this.transformToArray(UserAccountResourceImpl.this._groupService.getGroups(UserAccountResourceImpl.this.contextCompany.getCompanyId(), 0L, true), group -> UserAccountResourceImpl.this._toSiteBrief(group), SiteBrief.class);
                this.userAccountContactInformation = new UserAccountContactInformation(){
                    {
                        this.emailAddresses = (com.liferay.headless.admin.user.dto.v1_0.EmailAddress[])UserAccountResourceImpl.this.transformToArray(user.getEmailAddresses(), EmailAddressUtil::toEmailAddress, com.liferay.headless.admin.user.dto.v1_0.EmailAddress.class);
                        this.facebook = contact.getFacebookSn();
                        this.jabber = contact.getJabberSn();
                        this.postalAddresses = (PostalAddress[])UserAccountResourceImpl.this.transformToArray(user.getAddresses(), address -> PostalAddressUtil.toPostalAddress(UserAccountResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), address, UserAccountResourceImpl.this.contextCompany.getCompanyId(), UserAccountResourceImpl.this.contextAcceptLanguage.getPreferredLocale()), PostalAddress.class);
                        this.skype = contact.getSkypeSn();
                        this.sms = contact.getSmsSn();
                        this.telephones = (Phone[])UserAccountResourceImpl.this.transformToArray(user.getPhones(), PhoneUtil::toPhone, Phone.class);
                        this.twitter = contact.getTwitterSn();
                        this.webUrls = (WebUrl[])UserAccountResourceImpl.this.transformToArray(user.getWebsites(), WebUrlUtil::toWebUrl, WebUrl.class);
                    }
                };
                this.setDashboardURL(() -> {
                    Group group = user.getGroup();
                    return group.getDisplayURL(UserAccountResourceImpl.this._getThemeDisplay(group), true);
                });
                this.setImage(() -> {
                    if (user.getPortraitId() == 0L) {
                        return null;
                    }
                    ThemeDisplay themeDisplay = new ThemeDisplay(){
                        {
                            this.setPathImage(UserAccountResourceImpl.this._portal.getPathImage());
                        }
                    };
                    return user.getPortraitURL(themeDisplay);
                });
                this.setProfileURL(() -> {
                    Group group = user.getGroup();
                    return group.getDisplayURL(UserAccountResourceImpl.this._getThemeDisplay(group));
                });
            }
        };
    }
}

