/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.dto.v1_0.util;

import com.liferay.headless.admin.user.dto.v1_0.PostalAddress;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderCountryUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderListTypeUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.ServiceBuilderRegionUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.service.AddressLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;

public class ServiceBuilderAddressUtil {
    public static Address toServiceBuilderAddress(PostalAddress postalAddress, String type) {
        String street1 = postalAddress.getStreetAddressLine1();
        String street2 = postalAddress.getStreetAddressLine2();
        String street3 = postalAddress.getStreetAddressLine3();
        String city = postalAddress.getAddressLocality();
        String zip = postalAddress.getPostalCode();
        long countryId = ServiceBuilderCountryUtil.toServiceBuilderCountryId(postalAddress.getAddressCountry());
        if (Validator.isNull((String)street1) && Validator.isNull((String)street2) && Validator.isNull((String)street3) && Validator.isNull((String)city) && Validator.isNull((String)zip) && countryId == 0L) {
            return null;
        }
        Address address = AddressLocalServiceUtil.createAddress((long)GetterUtil.getLong((Object)postalAddress.getId()));
        address.setStreet1(street1);
        address.setStreet2(street2);
        address.setStreet3(street3);
        address.setCity(city);
        address.setZip(zip);
        address.setRegionId(ServiceBuilderRegionUtil.getServiceBuilderRegionId(postalAddress.getAddressRegion(), countryId));
        address.setCountryId(countryId);
        address.setTypeId(ServiceBuilderListTypeUtil.toServiceBuilderListTypeId("other", postalAddress.getAddressType(), type));
        address.setMailing(true);
        address.setPrimary(GetterUtil.getBoolean((Object)postalAddress.getPrimary()));
        return address;
    }
}

