/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.headless.admin.user.dto.v1_0.ContactInformation;
import com.liferay.headless.admin.user.dto.v1_0.EmailAddress;
import com.liferay.headless.admin.user.dto.v1_0.OrganizationBrief;
import com.liferay.headless.admin.user.dto.v1_0.Phone;
import com.liferay.headless.admin.user.dto.v1_0.PostalAddress;
import com.liferay.headless.admin.user.dto.v1_0.RoleBrief;
import com.liferay.headless.admin.user.dto.v1_0.SiteBrief;
import com.liferay.headless.admin.user.dto.v1_0.UserAccount;
import com.liferay.headless.admin.user.dto.v1_0.WebUrl;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.EmailAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.PhoneUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.PostalAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.WebUrlUtil;
import com.liferay.headless.admin.user.internal.odata.entity.v1_0.UserAccountEntityModel;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseUserAccountResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.UserAccountResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.ListTypeService;
import com.liferay.portal.kernel.service.RoleService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/user-account.properties"}, scope=ServiceScope.PROTOTYPE, service={UserAccountResource.class})
public class UserAccountResourceImpl
extends BaseUserAccountResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new UserAccountEntityModel();
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private GroupService _groupService;
    @Reference
    private ListTypeService _listTypeService;
    @Reference
    private Portal _portal;
    @Reference
    private RoleService _roleService;
    @Reference
    private UserService _userService;

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public UserAccount getMyUserAccount() throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        return this._toUserAccount(this._userService.getUserById(permissionChecker.getUserId()));
    }

    @Override
    public Page<UserAccount> getOrganizationUserAccountsPage(Long organizationId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getUserAccountsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("organizationIds", String.valueOf(organizationId)), BooleanClauseOccur.MUST);
        }), search, filter, pagination, sorts);
    }

    @Override
    public Page<UserAccount> getSiteUserAccountsPage(Long siteId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getUserAccountsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("groupId", String.valueOf(siteId)), BooleanClauseOccur.MUST);
        }), search, filter, pagination, sorts);
    }

    @Override
    public UserAccount getUserAccount(Long userAccountId) throws Exception {
        return this._toUserAccount(this._userService.getUserById(userAccountId.longValue()));
    }

    @Override
    public Page<UserAccount> getUserAccountsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(this.contextCompany.getCompanyId())) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker);
        }
        return this._getUserAccountsPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("userName", ""), BooleanClauseOccur.MUST_NOT);
        }), search, filter, pagination, sorts);
    }

    private String _getListTypeMessage(long listTypeId) throws Exception {
        if (listTypeId == 0L) {
            return null;
        }
        ListType listType = this._listTypeService.getListType(listTypeId);
        return LanguageUtil.get((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)listType.getName());
    }

    private ThemeDisplay _getThemeDisplay(final Group group) {
        return new ThemeDisplay(){
            {
                this.setPortalURL("");
                this.setSiteGroupId(group.getGroupId());
            }
        };
    }

    private Page<UserAccount> _getUserAccountsPage(UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQueryUnsafeConsumer, (Filter)filter, User.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), document -> this._toUserAccount(this._userService.getUserById(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    private OrganizationBrief _toOrganizationBrief(final Organization organization) {
        return new OrganizationBrief(){
            {
                this.id = organization.getOrganizationId();
                this.name = organization.getName();
            }
        };
    }

    private RoleBrief _toRoleBrief(final Role role) {
        return new RoleBrief(){
            {
                this.id = role.getRoleId();
                this.name = role.getTitle(UserAccountResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)UserAccountResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)role.getTitleMap());
            }
        };
    }

    private SiteBrief _toSiteBrief(final Group group) {
        return new SiteBrief(){
            {
                this.id = group.getGroupId();
                this.name = group.getName(UserAccountResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)UserAccountResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)group.getNameMap());
            }
        };
    }

    private UserAccount _toUserAccount(final User user) throws Exception {
        final Contact contact = user.getContact();
        return new UserAccount(){
            {
                this.additionalName = user.getMiddleName();
                this.alternateName = user.getScreenName();
                this.birthDate = user.getBirthday();
                this.contactInformation = new ContactInformation(){
                    {
                        this.emailAddresses = (EmailAddress[])UserAccountResourceImpl.this.transformToArray(user.getEmailAddresses(), EmailAddressUtil::toEmailAddress, EmailAddress.class);
                        this.facebook = contact.getFacebookSn();
                        this.jabber = contact.getJabberSn();
                        this.postalAddresses = (PostalAddress[])UserAccountResourceImpl.this.transformToArray(user.getAddresses(), address -> PostalAddressUtil.toPostalAddress(UserAccountResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), address, user.getCompanyId(), UserAccountResourceImpl.this.contextAcceptLanguage.getPreferredLocale()), PostalAddress.class);
                        this.skype = contact.getSkypeSn();
                        this.sms = contact.getSmsSn();
                        this.telephones = (Phone[])UserAccountResourceImpl.this.transformToArray(user.getPhones(), PhoneUtil::toPhone, Phone.class);
                        this.twitter = contact.getTwitterSn();
                        this.webUrls = (WebUrl[])UserAccountResourceImpl.this.transformToArray(user.getWebsites(), WebUrlUtil::toWebUrl, WebUrl.class);
                    }
                };
                this.customFields = CustomFieldsUtil.toCustomFields(UserAccountResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), User.class.getName(), user.getUserId(), user.getCompanyId(), UserAccountResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.dateCreated = user.getCreateDate();
                this.dateModified = user.getModifiedDate();
                this.emailAddress = user.getEmailAddress();
                this.familyName = user.getLastName();
                this.givenName = user.getFirstName();
                this.honorificPrefix = UserAccountResourceImpl.this._getListTypeMessage(contact.getPrefixId());
                this.honorificSuffix = UserAccountResourceImpl.this._getListTypeMessage(contact.getSuffixId());
                this.id = user.getUserId();
                this.jobTitle = user.getJobTitle();
                this.keywords = (String[])ListUtil.toArray((List)UserAccountResourceImpl.this._assetTagLocalService.getTags(User.class.getName(), user.getUserId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.name = user.getFullName();
                this.organizationBriefs = (OrganizationBrief[])UserAccountResourceImpl.this.transformToArray(user.getOrganizations(), organization -> UserAccountResourceImpl.this._toOrganizationBrief(organization), OrganizationBrief.class);
                this.roleBriefs = (RoleBrief[])UserAccountResourceImpl.this.transformToArray(UserAccountResourceImpl.this._roleService.getUserRoles(user.getUserId()), role -> UserAccountResourceImpl.this._toRoleBrief(role), RoleBrief.class);
                this.siteBriefs = (SiteBrief[])UserAccountResourceImpl.this.transformToArray(UserAccountResourceImpl.this._groupService.getGroups(UserAccountResourceImpl.this.contextCompany.getCompanyId(), 0L, true), group -> UserAccountResourceImpl.this._toSiteBrief(group), SiteBrief.class);
                this.setDashboardURL(() -> {
                    Group group = user.getGroup();
                    return group.getDisplayURL(UserAccountResourceImpl.this._getThemeDisplay(group), true);
                });
                this.setImage(() -> {
                    if (user.getPortraitId() == 0L) {
                        return null;
                    }
                    ThemeDisplay themeDisplay = new ThemeDisplay(){
                        {
                            this.setPathImage(UserAccountResourceImpl.this._portal.getPathImage());
                        }
                    };
                    return user.getPortraitURL(themeDisplay);
                });
                this.setProfileURL(() -> {
                    Group group = user.getGroup();
                    return group.getDisplayURL(UserAccountResourceImpl.this._getThemeDisplay(group));
                });
            }
        };
    }
}

