/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.headless.admin.user.dto.v1_0.SegmentUser;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseSegmentUserResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.SegmentUserResource;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.segments.provider.SegmentsEntryProviderRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/segment-user.properties"}, scope=ServiceScope.PROTOTYPE, service={SegmentUserResource.class})
public class SegmentUserResourceImpl
extends BaseSegmentUserResourceImpl {
    @Reference
    private SegmentsEntryProviderRegistry _segmentsEntryProviderRegistry;
    @Reference
    private UserService _userService;

    @Override
    public Page<SegmentUser> getSegmentUserAccountsPage(Long segmentId, Pagination pagination) throws Exception {
        long[] segmentsEntryClassPKs = this._segmentsEntryProviderRegistry.getSegmentsEntryClassPKs(segmentId.longValue(), pagination.getStartPosition(), pagination.getEndPosition());
        return Page.of(this.transformToList(ArrayUtil.toArray((long[])segmentsEntryClassPKs), this::_toSegmentUser), (Pagination)pagination, (long)this._segmentsEntryProviderRegistry.getSegmentsEntryClassPKsCount(segmentId.longValue()));
    }

    private SegmentUser _toSegmentUser(long segmentsEntryClassPK) throws Exception {
        final User user = this._userService.getUserById(segmentsEntryClassPK);
        return new SegmentUser(){
            {
                this.emailAddress = user.getEmailAddress();
                this.id = user.getUserId();
                this.name = user.getFullName();
            }
        };
    }
}

