/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.user.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.headless.admin.user.dto.v1_0.ContactInformation;
import com.liferay.headless.admin.user.dto.v1_0.EmailAddress;
import com.liferay.headless.admin.user.dto.v1_0.HoursAvailable;
import com.liferay.headless.admin.user.dto.v1_0.Location;
import com.liferay.headless.admin.user.dto.v1_0.Organization;
import com.liferay.headless.admin.user.dto.v1_0.Phone;
import com.liferay.headless.admin.user.dto.v1_0.PostalAddress;
import com.liferay.headless.admin.user.dto.v1_0.Service;
import com.liferay.headless.admin.user.dto.v1_0.WebUrl;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.EmailAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.PhoneUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.PostalAddressUtil;
import com.liferay.headless.admin.user.internal.dto.v1_0.util.WebUrlUtil;
import com.liferay.headless.admin.user.internal.odata.entity.v1_0.OrganizationEntityModel;
import com.liferay.headless.admin.user.internal.resource.v1_0.BaseOrganizationResourceImpl;
import com.liferay.headless.admin.user.resource.v1_0.OrganizationResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.EmailAddressService;
import com.liferay.portal.kernel.service.OrgLaborService;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.PhoneService;
import com.liferay.portal.kernel.service.RegionService;
import com.liferay.portal.kernel.service.WebsiteService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/organization.properties"}, scope=ServiceScope.PROTOTYPE, service={OrganizationResource.class})
public class OrganizationResourceImpl
extends BaseOrganizationResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new OrganizationEntityModel();
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private CountryService _countryService;
    @Reference
    private EmailAddressService _emailAddressService;
    @Reference
    private OrganizationService _organizationService;
    @Reference
    private OrgLaborService _orgLaborService;
    @Reference
    private PhoneService _phoneService;
    @Reference
    private Portal _portal;
    @Reference
    private RegionService _regionService;
    @Reference
    private WebsiteService _websiteService;

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public Organization getOrganization(Long organizationId) throws Exception {
        return this._toOrganization(this._organizationService.getOrganization(organizationId.longValue()));
    }

    @Override
    public Page<Organization> getOrganizationOrganizationsPage(Long parentOrganizationId, Boolean flatten, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getOrganizationsPage(parentOrganizationId, flatten, search, filter, pagination, sorts);
    }

    @Override
    public Page<Organization> getOrganizationsPage(Boolean flatten, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getOrganizationsPage(0L, flatten, search, filter, pagination, sorts);
    }

    private HoursAvailable _createHoursAvailable(final int closeHour, final String day, final int openHour) {
        return new HoursAvailable(){
            {
                this.closes = OrganizationResourceImpl.this._formatHour(closeHour);
                this.dayOfWeek = day;
                this.opens = OrganizationResourceImpl.this._formatHour(openHour);
            }
        };
    }

    private String _formatHour(int hour) {
        if (hour == -1) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("00,00"){
            {
                this.setDecimalFormatSymbols(new DecimalFormatSymbols(){
                    {
                        this.setGroupingSeparator(':');
                    }
                });
                this.setGroupingSize(2);
            }
        };
        return decimalFormat.format(hour);
    }

    private Page<Organization> _getOrganizationsPage(Long organizationId, Boolean flatten, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            if (GetterUtil.getBoolean((Object)flatten)) {
                if (organizationId != 0L) {
                    booleanFilter.add((Filter)new QueryFilter((Query)new WildcardQueryImpl("treePath", "*" + organizationId + "*")));
                    booleanFilter.add((Filter)new TermFilter("organizationId", String.valueOf(organizationId)), BooleanClauseOccur.MUST_NOT);
                }
            } else {
                booleanFilter.add((Filter)new TermFilter("parentOrganizationId", String.valueOf(organizationId)), BooleanClauseOccur.MUST);
            }
        }, (Filter)filter, com.liferay.portal.kernel.model.Organization.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), document -> this._toOrganization(this._organizationService.getOrganization(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    private Organization _toOrganization(final com.liferay.portal.kernel.model.Organization organization) throws Exception {
        if (organization == null) {
            return null;
        }
        return new Organization(){
            {
                this.comment = organization.getComments();
                this.contactInformation = new ContactInformation(){
                    {
                        this.emailAddresses = (EmailAddress[])OrganizationResourceImpl.this.transformToArray(OrganizationResourceImpl.this._emailAddressService.getEmailAddresses(organization.getModelClassName(), organization.getOrganizationId()), EmailAddressUtil::toEmailAddress, EmailAddress.class);
                        this.postalAddresses = (PostalAddress[])OrganizationResourceImpl.this.transformToArray(organization.getAddresses(), address -> PostalAddressUtil.toPostalAddress(OrganizationResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), address, organization.getCompanyId(), OrganizationResourceImpl.this.contextAcceptLanguage.getPreferredLocale()), PostalAddress.class);
                        this.telephones = (Phone[])OrganizationResourceImpl.this.transformToArray(OrganizationResourceImpl.this._phoneService.getPhones(organization.getModelClassName(), organization.getOrganizationId()), PhoneUtil::toPhone, Phone.class);
                        this.webUrls = (WebUrl[])OrganizationResourceImpl.this.transformToArray(OrganizationResourceImpl.this._websiteService.getWebsites(organization.getModelClassName(), organization.getOrganizationId()), WebUrlUtil::toWebUrl, WebUrl.class);
                    }
                };
                this.customFields = CustomFieldsUtil.toCustomFields(OrganizationResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), com.liferay.portal.kernel.model.Organization.class.getName(), organization.getOrganizationId(), organization.getCompanyId(), OrganizationResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.dateCreated = organization.getCreateDate();
                this.dateModified = organization.getModifiedDate();
                this.id = organization.getOrganizationId();
                this.keywords = (String[])ListUtil.toArray((List)OrganizationResourceImpl.this._assetTagLocalService.getTags(organization.getModelClassName(), organization.getOrganizationId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.location = new Location(){
                    {
                        this.setAddressCountry(() -> {
                            if (organization.getCountryId() <= 0L) {
                                return null;
                            }
                            Country country = OrganizationResourceImpl.this._countryService.getCountry(organization.getCountryId());
                            return country.getName(OrganizationResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                        });
                        this.setAddressCountry_i18n(() -> {
                            if (!OrganizationResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages()) {
                                return null;
                            }
                            Set locales = LanguageUtil.getCompanyAvailableLocales((long)organization.getCompanyId());
                            Stream localesStream = locales.stream();
                            Country country = OrganizationResourceImpl.this._countryService.getCountry(organization.getCountryId());
                            return localesStream.collect(Collectors.toMap(LocaleUtil::toBCP47LanguageId, arg_0 -> ((Country)country).getName(arg_0)));
                        });
                        this.setAddressRegion(() -> {
                            if (organization.getRegionId() <= 0L) {
                                return null;
                            }
                            Region region = OrganizationResourceImpl.this._regionService.getRegion(organization.getRegionId());
                            return region.getName();
                        });
                    }
                };
                this.name = organization.getName();
                this.numberOfOrganizations = OrganizationResourceImpl.this._organizationService.getOrganizationsCount(organization.getCompanyId(), organization.getOrganizationId());
                this.parentOrganization = OrganizationResourceImpl.this._toOrganization(organization.getParentOrganization());
                this.services = (Service[])OrganizationResourceImpl.this.transformToArray(OrganizationResourceImpl.this._orgLaborService.getOrgLabors(organization.getOrganizationId()), x$0 -> OrganizationResourceImpl.this._toService(x$0), Service.class);
                this.setImage(() -> {
                    if (organization.getLogoId() <= 0L) {
                        return null;
                    }
                    return StringBundler.concat((Object[])new Object[]{OrganizationResourceImpl.this._portal.getPathImage(), "/organization_logo?img_id=", organization.getLogoId(), "&t=", WebServerServletTokenUtil.getToken((long)organization.getLogoId())});
                });
            }
        };
    }

    private Service _toService(final OrgLabor orgLabor) throws Exception {
        final ListType listType = orgLabor.getType();
        return new Service(){
            {
                this.hoursAvailable = new HoursAvailable[]{OrganizationResourceImpl.this._createHoursAvailable(orgLabor.getSunClose(), "Sunday", orgLabor.getSunOpen()), OrganizationResourceImpl.this._createHoursAvailable(orgLabor.getMonClose(), "Monday", orgLabor.getMonOpen()), OrganizationResourceImpl.this._createHoursAvailable(orgLabor.getTueClose(), "Tuesday", orgLabor.getTueOpen()), OrganizationResourceImpl.this._createHoursAvailable(orgLabor.getWedClose(), "Wednesday", orgLabor.getWedOpen()), OrganizationResourceImpl.this._createHoursAvailable(orgLabor.getThuClose(), "Thursday", orgLabor.getThuOpen()), OrganizationResourceImpl.this._createHoursAvailable(orgLabor.getFriClose(), "Friday", orgLabor.getFriOpen()), OrganizationResourceImpl.this._createHoursAvailable(orgLabor.getSatClose(), "Saturday", orgLabor.getSatOpen())};
                this.serviceType = listType.getName();
            }
        };
    }
}

